/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle;

import javax.inject.Inject;
import me.champeau.gradle.IsolatedRunner;
import me.champeau.gradle.JMHPluginExtension;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.tasks.Jar;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerExecutor;
import org.openjdk.jmh.runner.options.Options;

public class JMHTask
extends DefaultTask {
    private static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    private final WorkerExecutor workerExecutor;

    @Inject
    public JMHTask(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    @TaskAction
    public void before() {
        JMHPluginExtension extension = (JMHPluginExtension)this.getProject().getExtensions().getByType(JMHPluginExtension.class);
        Options options = extension.resolveArgs();
        extension.getResultsFile().getParentFile().mkdirs();
        this.workerExecutor.submit(IsolatedRunner.class, workerConfiguration -> {
            workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
            ConfigurationContainer configurations = this.getProject().getConfigurations();
            FileCollection classpath = configurations.getByName("jmh").plus((FileCollection)this.getProject().files(new Object[]{this.getJarArchive()}));
            if (extension.isIncludeTests()) {
                classpath = classpath.plus((FileCollection)configurations.getByName("testRuntimeClasspath"));
            }
            workerConfiguration.classpath((Iterable)classpath);
            workerConfiguration.params(new Object[]{options, classpath.getFiles()});
            workerConfiguration.getForkOptions().getSystemProperties().put(JAVA_IO_TMPDIR, this.getTemporaryDir());
        });
    }

    public void setDidWork(boolean didWork) {
        super.setDidWork(didWork);
    }

    private Provider<RegularFile> getJarArchive() {
        return ((Jar)this.getProject().getTasks().getByName("jmhJar")).getArchiveFile();
    }
}

