/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle;

import java.io.File;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;

public class IsolatedRunner
implements Runnable {
    private final Options options;
    private Set<File> classpathUnderTest;

    @Inject
    public IsolatedRunner(Options options, Set<File> classpathUnderTest) {
        this.options = options;
        this.classpathUnderTest = classpathUnderTest;
    }

    @Override
    public void run() {
        String originalClasspath = System.getProperty("java.class.path");
        Runner runner = new Runner(this.options);
        try {
            System.setProperty("java.class.path", this.toPath(this.classpathUnderTest));
            runner.run();
        }
        catch (RunnerException e) {
            throw new GradleException("Error during execution of benchmarks", (Throwable)e);
        }
        finally {
            runner.runSystemGC();
            if (originalClasspath != null) {
                System.setProperty("java.class.path", originalClasspath);
            } else {
                System.clearProperty("java.class.path");
            }
        }
    }

    private String toPath(Set<File> classpathUnderTest) {
        StringBuilder sb = new StringBuilder();
        for (File entry : classpathUnderTest) {
            sb.append(entry.getAbsolutePath());
            sb.append(File.pathSeparatorChar);
        }
        return sb.toString();
    }
}

