/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.openjdk.jmh.generators.asm.ASMGeneratorSource;
import org.openjdk.jmh.generators.core.BenchmarkGenerator;
import org.openjdk.jmh.generators.core.FileSystemDestination;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.GeneratorSource;
import org.openjdk.jmh.generators.core.SourceError;
import org.openjdk.jmh.generators.reflection.RFGeneratorSource;
import org.openjdk.jmh.util.FileUtils;

public class JmhBytecodeGeneratorRunnable
implements Runnable {
    private final File[] compiledBytecodeDirectories;
    private final File outputSourceDirectory;
    private final File outputResourceDirectory;
    private final String generatorType;

    @Inject
    public JmhBytecodeGeneratorRunnable(File[] compiledBytecodeDirectories, File outputSourceDirectory, File outputResourceDirectory, String generatorType) {
        this.compiledBytecodeDirectories = compiledBytecodeDirectories;
        this.outputSourceDirectory = outputSourceDirectory;
        this.outputResourceDirectory = outputResourceDirectory;
        this.generatorType = generatorType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        JmhBytecodeGeneratorRunnable.cleanup(this.outputSourceDirectory);
        JmhBytecodeGeneratorRunnable.cleanup(this.outputResourceDirectory);
        String generatorType = this.generatorType;
        if (generatorType.equals("default")) {
            generatorType = "reflection";
        }
        URL[] urls = new URL[this.compiledBytecodeDirectories.length];
        for (int i = 0; i < this.compiledBytecodeDirectories.length; ++i) {
            try {
                urls[i] = this.compiledBytecodeDirectories[i].toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
        URLClassLoader amendedCL = new URLClassLoader(urls, this.getClass().getClassLoader());
        ClassLoader ocl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(amendedCL);
            FileSystemDestination destination = new FileSystemDestination(this.outputResourceDirectory, this.outputSourceDirectory);
            HashMap<File, Collection> allClasses = new HashMap<File, Collection>(urls.length);
            for (File compiledBytecodeDirectory : this.compiledBytecodeDirectories) {
                Collection classes = FileUtils.getClasses((File)compiledBytecodeDirectory);
                System.out.println("Processing " + classes.size() + " classes from " + compiledBytecodeDirectory + " with \"" + generatorType + "\" generator");
                allClasses.put(compiledBytecodeDirectory, classes);
            }
            System.out.println("Writing out Java source to " + this.outputSourceDirectory + " and resources to " + this.outputResourceDirectory);
            for (Map.Entry entry : allClasses.entrySet()) {
                ASMGeneratorSource src;
                File compiledBytecodeDirectory = (File)entry.getKey();
                Collection classes = (Collection)entry.getValue();
                ASMGeneratorSource source = null;
                if (generatorType.equalsIgnoreCase("asm")) {
                    src = new ASMGeneratorSource();
                    try {
                        src.processClasses(classes);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    source = src;
                } else if (generatorType.equalsIgnoreCase("reflection")) {
                    src = new RFGeneratorSource();
                    for (File f : classes) {
                        String name = f.getAbsolutePath().substring(compiledBytecodeDirectory.getAbsolutePath().length() + 1);
                        name = name.replaceAll("\\\\", ".");
                        if (!(name = name.replaceAll("/", ".")).endsWith(".class")) continue;
                        try {
                            src.processClasses(new Class[]{Class.forName(name.substring(0, name.length() - 6), false, amendedCL)});
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    source = src;
                }
                BenchmarkGenerator gen = new BenchmarkGenerator();
                gen.generate((GeneratorSource)source, (GeneratorDestination)destination);
                gen.complete((GeneratorSource)source, (GeneratorDestination)destination);
            }
            if (destination.hasErrors()) {
                int errCount = 0;
                StringBuilder stringBuilder = new StringBuilder();
                for (SourceError e : destination.getErrors()) {
                    ++errCount;
                    stringBuilder.append("  - ").append(e.toString()).append("\n");
                }
                throw new RuntimeException("Generation of JMH bytecode failed with " + errCount + "errors:\n" + stringBuilder);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ocl);
        }
    }

    private static void cleanup(File file) {
        if (file.exists()) {
            File[] listing = file.listFiles();
            if (listing != null) {
                for (File sub : listing) {
                    JmhBytecodeGeneratorRunnable.cleanup(sub);
                }
            }
            file.delete();
        }
    }
}

