/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.file.DuplicatesStrategy;
import org.gradle.api.provider.Property;

public class JMHPluginExtension {
    private final Project project;
    private String jmhVersion = "1.17.4";
    private final Property<Boolean> includeTestState;
    private List<String> include = new ArrayList<String>();
    private List<String> exclude = new ArrayList<String>();
    private List<String> benchmarkMode;
    private Integer iterations;
    private Integer batchSize;
    private Integer fork;
    private Boolean failOnError;
    private Boolean forceGC;
    private String jvm;
    private List<String> jvmArgs = new ArrayList<String>();
    private List<String> jvmArgsAppend;
    private List<String> jvmArgsPrepend;
    private File humanOutputFile;
    private File resultsFile;
    private Integer operationsPerInvocation;
    private Map<String, Collection<String>> benchmarkParameters;
    private List<String> profilers;
    private String timeOnIteration;
    private String resultExtension;
    private String resultFormat;
    private Boolean synchronizeIterations;
    private Integer threads;
    private List<Integer> threadGroups;
    private String timeUnit;
    private String verbosity;
    private String timeout;
    private String warmup;
    private Integer warmupBatchSize;
    private Integer warmupForks;
    private Integer warmupIterations;
    private String warmupMode;
    private List<String> warmupBenchmarks;
    private boolean zip64 = false;
    private DuplicatesStrategy duplicateClassesStrategy = DuplicatesStrategy.FAIL;

    public JMHPluginExtension(Project project) {
        this.project = project;
        this.includeTestState = project.getObjects().property(Boolean.class);
        this.setIncludeTests(true);
    }

    public String getJmhVersion() {
        return this.jmhVersion;
    }

    public void setJmhVersion(String jmhVersion) {
        this.jmhVersion = jmhVersion;
    }

    void resolveArgs() {
        this.resolveResultExtension();
        this.resolveResultFormat();
        this.resolveResultsFile();
    }

    private void resolveResultsFile() {
        this.resultsFile = this.resultsFile != null ? this.resultsFile : this.project.file((Object)(String.valueOf(this.project.getBuildDir()) + "/reports/jmh/results." + this.resultExtension));
    }

    private void resolveResultExtension() {
        this.resultExtension = this.resultFormat != null ? this.parseResultFormat() : "txt";
    }

    private void resolveResultFormat() {
        this.resultFormat = this.resultFormat != null ? this.resultFormat : "text";
    }

    private String parseResultFormat() {
        return ResultFormatType.translate(this.resultFormat);
    }

    public List<String> getInclude() {
        return this.include;
    }

    @Deprecated
    public void setInclude(String include) {
        this.include = Collections.singletonList(include);
    }

    public void setInclude(List<String> include) {
        this.include = include;
    }

    public List<String> getExclude() {
        return this.exclude;
    }

    @Deprecated
    public void setExclude(String exclude) {
        this.exclude = Collections.singletonList(exclude);
    }

    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public List<String> getBenchmarkMode() {
        return this.benchmarkMode;
    }

    public void setBenchmarkMode(List<String> benchmarkMode) {
        this.benchmarkMode = benchmarkMode;
    }

    public Integer getIterations() {
        return this.iterations;
    }

    public void setIterations(Integer iterations) {
        this.iterations = iterations;
    }

    public Integer getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public Integer getFork() {
        return this.fork;
    }

    public void setFork(Integer fork) {
        this.fork = fork;
    }

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(Boolean failOnError) {
        this.failOnError = failOnError;
    }

    public Boolean getForceGC() {
        return this.forceGC;
    }

    public void setForceGC(Boolean forceGC) {
        this.forceGC = forceGC;
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Deprecated
    public void setJvmArgs(String jvmArgs) {
        this.jvmArgs = Arrays.asList(jvmArgs.split(" "));
    }

    public void setJvmArgs(List<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    public List<String> getJvmArgsAppend() {
        return this.jvmArgsAppend;
    }

    @Deprecated
    public void setJvmArgsAppend(String jvmArgsAppend) {
        this.jvmArgsAppend = Arrays.asList(jvmArgsAppend.split(" "));
    }

    public void setJvmArgsAppend(List<String> jvmArgsAppend) {
        this.jvmArgsAppend = jvmArgsAppend;
    }

    public List<String> getJvmArgsPrepend() {
        return this.jvmArgsPrepend;
    }

    @Deprecated
    public void setJvmArgsPrepend(String jvmArgsPrepend) {
        this.jvmArgsPrepend = Arrays.asList(jvmArgsPrepend.split(" "));
    }

    public void setJvmArgsPrepend(List<String> jvmArgsPrepend) {
        this.jvmArgsPrepend = jvmArgsPrepend;
    }

    public File getHumanOutputFile() {
        return this.humanOutputFile;
    }

    public void setHumanOutputFile(File humanOutputFile) {
        this.humanOutputFile = humanOutputFile;
    }

    public File getResultsFile() {
        return this.resultsFile;
    }

    public void setResultsFile(File resultsFile) {
        this.resultsFile = resultsFile;
    }

    public Integer getOperationsPerInvocation() {
        return this.operationsPerInvocation;
    }

    public void setOperationsPerInvocation(Integer operationsPerInvocation) {
        this.operationsPerInvocation = operationsPerInvocation;
    }

    public Map<String, Collection<String>> getBenchmarkParameters() {
        return this.benchmarkParameters;
    }

    public void setBenchmarkParameters(Map<String, Collection<String>> benchmarkParameters) {
        this.benchmarkParameters = benchmarkParameters;
    }

    public List<String> getProfilers() {
        return this.profilers;
    }

    public void setProfilers(List<String> profilers) {
        this.profilers = profilers;
    }

    public String getTimeOnIteration() {
        return this.timeOnIteration;
    }

    public void setTimeOnIteration(String timeOnIteration) {
        this.timeOnIteration = timeOnIteration;
    }

    public String getResultFormat() {
        return this.resultFormat;
    }

    public void setResultFormat(String resultFormat) {
        this.resultFormat = resultFormat;
    }

    public Boolean getSynchronizeIterations() {
        return this.synchronizeIterations;
    }

    public void setSynchronizeIterations(Boolean synchronizeIterations) {
        this.synchronizeIterations = synchronizeIterations;
    }

    public Integer getThreads() {
        return this.threads;
    }

    public void setThreads(Integer threads) {
        this.threads = threads;
    }

    public List<Integer> getThreadGroups() {
        return this.threadGroups;
    }

    public void setThreadGroups(List<Integer> threadGroups) {
        this.threadGroups = threadGroups;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(String timeUnit) {
        this.timeUnit = timeUnit;
    }

    public String getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(String verbosity) {
        this.verbosity = verbosity;
    }

    public String getWarmup() {
        return this.warmup;
    }

    public void setWarmup(String warmup) {
        this.warmup = warmup;
    }

    public Integer getWarmupBatchSize() {
        return this.warmupBatchSize;
    }

    public void setWarmupBatchSize(Integer warmupBatchSize) {
        this.warmupBatchSize = warmupBatchSize;
    }

    public Integer getWarmupForks() {
        return this.warmupForks;
    }

    public void setWarmupForks(Integer warmupForks) {
        this.warmupForks = warmupForks;
    }

    public Integer getWarmupIterations() {
        return this.warmupIterations;
    }

    public void setWarmupIterations(Integer warmupIterations) {
        this.warmupIterations = warmupIterations;
    }

    public String getWarmupMode() {
        return this.warmupMode;
    }

    public void setWarmupMode(String warmupMode) {
        this.warmupMode = warmupMode;
    }

    public List<String> getWarmupBenchmarks() {
        return this.warmupBenchmarks;
    }

    public void setWarmupBenchmarks(List<String> warmupBenchmarks) {
        this.warmupBenchmarks = warmupBenchmarks;
    }

    public boolean isZip64() {
        return this.zip64;
    }

    public void setZip64(boolean zip64) {
        this.zip64 = zip64;
    }

    public boolean isIncludeTests() {
        return (Boolean)this.includeTestState.get();
    }

    public void setIncludeTests(boolean includeTests) {
        this.includeTestState.set((Object)includeTests);
    }

    Property<Boolean> getIncludeTestsProvider() {
        return this.includeTestState;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public DuplicatesStrategy getDuplicateClassesStrategy() {
        return this.duplicateClassesStrategy;
    }

    public void setDuplicateClassesStrategy(DuplicatesStrategy duplicateClassesStrategy) {
        this.duplicateClassesStrategy = duplicateClassesStrategy;
    }

    private static enum ResultFormatType {
        TEXT("txt"),
        CSV("csv"),
        SCSV("scsv"),
        JSON("json"),
        LATEX("tex");

        private String extension;

        private ResultFormatType(String extension) {
            this.extension = extension;
        }

        public static String translate(String resultFormat) {
            return ResultFormatType.valueOf((String)resultFormat.toUpperCase()).extension;
        }
    }
}

