/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle;

import java.io.File;
import javax.inject.Inject;
import me.champeau.gradle.ExtensionOptions;
import me.champeau.gradle.IsolatedRunner;
import me.champeau.gradle.JMHPluginExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.TaskAction;
import org.gradle.jvm.tasks.Jar;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;

public class JMHTask
extends DefaultTask {
    private final WorkerExecutor workerExecutor;

    @Inject
    public JMHTask(WorkerExecutor workerExecutor) {
        this.workerExecutor = workerExecutor;
    }

    @TaskAction
    public void before() {
        final JMHPluginExtension extension = (JMHPluginExtension)this.getProject().getExtensions().getByType(JMHPluginExtension.class);
        extension.resolveArgs();
        final ExtensionOptions options = new ExtensionOptions(extension);
        extension.getResultsFile().getParentFile().mkdirs();
        this.workerExecutor.submit(IsolatedRunner.class, (Action)new Action<WorkerConfiguration>(){

            public void execute(WorkerConfiguration workerConfiguration) {
                workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
                ConfigurationContainer configurations = JMHTask.this.getProject().getConfigurations();
                FileCollection classpath = configurations.getByName("jmh").plus((FileCollection)JMHTask.this.getProject().files(new Object[]{JMHTask.this.getJarArchive()}));
                if (extension.isIncludeTests()) {
                    classpath = classpath.plus((FileCollection)configurations.getByName("testRuntimeClasspath"));
                }
                workerConfiguration.classpath((Iterable)classpath);
                workerConfiguration.params(new Object[]{options.asSerializable()});
            }
        });
    }

    public void setDidWork(boolean didWork) {
        super.setDidWork(didWork);
    }

    private File getJarArchive() {
        return ((Jar)this.getProject().getTasks().getByName("jmhJar")).getArchivePath();
    }
}

