/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.champeau.gradle.JMHPluginExtension;
import me.champeau.gradle.SerializableOptions;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.ProfilerConfig;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.openjdk.jmh.util.Optional;

class ExtensionOptions
implements Options {
    private final JMHPluginExtension extension;

    public ExtensionOptions(JMHPluginExtension extension) {
        this.extension = extension;
    }

    public List<String> getIncludes() {
        return this.extension.getInclude();
    }

    public List<String> getExcludes() {
        return this.extension.getExclude();
    }

    public Optional<String> getOutput() {
        return this.fromNullableFile(this.extension.getHumanOutputFile());
    }

    private Optional<String> fromNullableFile(File humanOutputFile) {
        if (humanOutputFile != null) {
            return Optional.of((Object)humanOutputFile.getAbsolutePath());
        }
        return Optional.none();
    }

    public Optional<ResultFormatType> getResultFormat() {
        String resultFormat = this.extension.getResultFormat();
        if (resultFormat != null) {
            return Optional.of((Object)ResultFormatType.valueOf((String)resultFormat.toUpperCase()));
        }
        return Optional.none();
    }

    public Optional<String> getResult() {
        return this.fromNullableFile(this.extension.getResultsFile());
    }

    public Optional<Boolean> shouldDoGC() {
        return Optional.eitherOf((Object)this.extension.getForceGC());
    }

    public List<ProfilerConfig> getProfilers() {
        List<String> profilers = this.extension.getProfilers();
        if (profilers == null) {
            return Collections.emptyList();
        }
        ArrayList<ProfilerConfig> configs = new ArrayList<ProfilerConfig>(profilers.size());
        for (String profiler : profilers) {
            int idx = profiler.indexOf(":");
            String profName = idx == -1 ? profiler : profiler.substring(0, idx);
            String params = idx == -1 ? "" : profiler.substring(idx + 1);
            configs.add(new ProfilerConfig(profName, params));
        }
        return configs;
    }

    public Optional<VerboseMode> verbosity() {
        String verbosity = this.extension.getVerbosity();
        if (verbosity != null) {
            return Optional.of((Object)VerboseMode.valueOf((String)verbosity.toUpperCase()));
        }
        return Optional.none();
    }

    public Optional<Boolean> shouldFailOnError() {
        return Optional.eitherOf((Object)this.extension.getFailOnError());
    }

    public Optional<Integer> getThreads() {
        return Optional.eitherOf((Object)this.extension.getThreads());
    }

    public Optional<int[]> getThreadGroups() {
        List<Integer> threadGroups = this.extension.getThreadGroups();
        if (threadGroups != null) {
            int[] arr = new int[threadGroups.size()];
            Iterator<Integer> it = threadGroups.iterator();
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = it.next();
            }
            return Optional.of((Object)arr);
        }
        return Optional.none();
    }

    public Optional<Boolean> shouldSyncIterations() {
        return Optional.eitherOf((Object)this.extension.getSynchronizeIterations());
    }

    public Optional<Integer> getWarmupIterations() {
        return Optional.eitherOf((Object)this.extension.getWarmupIterations());
    }

    public Optional<TimeValue> getWarmupTime() {
        if (this.extension.getWarmup() != null) {
            return Optional.of((Object)TimeValue.fromString((String)this.extension.getWarmup()));
        }
        return Optional.none();
    }

    public Optional<Integer> getWarmupBatchSize() {
        return Optional.eitherOf((Object)this.extension.getWarmupBatchSize());
    }

    public Optional<WarmupMode> getWarmupMode() {
        String warmupMode = this.extension.getWarmupMode();
        if (warmupMode != null) {
            return Optional.of((Object)WarmupMode.valueOf((String)warmupMode.toUpperCase()));
        }
        return Optional.none();
    }

    public List<String> getWarmupIncludes() {
        List<String> warmupBenchmarks = this.extension.getWarmupBenchmarks();
        return warmupBenchmarks != null ? warmupBenchmarks : Collections.emptyList();
    }

    public Optional<Integer> getMeasurementIterations() {
        return Optional.eitherOf((Object)this.extension.getIterations());
    }

    public Optional<TimeValue> getMeasurementTime() {
        if (this.extension.getTimeOnIteration() != null) {
            return Optional.of((Object)TimeValue.fromString((String)this.extension.getTimeOnIteration()));
        }
        return Optional.none();
    }

    public Optional<Integer> getMeasurementBatchSize() {
        return Optional.eitherOf((Object)this.extension.getBatchSize());
    }

    public Collection<Mode> getBenchModes() {
        List<String> benchmarkMode = this.extension.getBenchmarkMode();
        ArrayList<Mode> modes = new ArrayList<Mode>();
        if (benchmarkMode != null) {
            for (String str : benchmarkMode) {
                modes.add(Mode.deepValueOf((String)str));
            }
        }
        return modes;
    }

    public Optional<TimeUnit> getTimeUnit() {
        String timeUnit = this.extension.getTimeUnit();
        if (timeUnit != null) {
            return Optional.of((Object)((Object)this.toTimeUnit(timeUnit.toLowerCase())));
        }
        return Optional.none();
    }

    public Optional<Integer> getOperationsPerInvocation() {
        return Optional.eitherOf((Object)this.extension.getOperationsPerInvocation());
    }

    public Optional<Integer> getForkCount() {
        return Optional.eitherOf((Object)this.extension.getFork());
    }

    public Optional<Integer> getWarmupForkCount() {
        return Optional.eitherOf((Object)this.extension.getWarmupForks());
    }

    public Optional<String> getJvm() {
        return Optional.eitherOf((Object)this.extension.getJvm());
    }

    public Optional<Collection<String>> getJvmArgs() {
        return Optional.eitherOf(this.extension.getJvmArgs());
    }

    public Optional<Collection<String>> getJvmArgsAppend() {
        List<String> jvmArgsAppend = this.extension.getJvmArgsAppend();
        return Optional.eitherOf(jvmArgsAppend);
    }

    public Optional<Collection<String>> getJvmArgsPrepend() {
        List<String> jvmArgsPrepend = this.extension.getJvmArgsPrepend();
        return Optional.eitherOf(jvmArgsPrepend);
    }

    public Optional<Collection<String>> getParameter(String name) {
        Map<String, Collection<String>> benchmarkParameters = this.extension.getBenchmarkParameters();
        if (benchmarkParameters != null) {
            Collection<String> stringCollection = benchmarkParameters.get(name);
            return Optional.eitherOf(stringCollection);
        }
        return Optional.none();
    }

    public Optional<TimeValue> getTimeout() {
        if (this.extension.getTimeout() != null) {
            return Optional.of((Object)TimeValue.fromString((String)this.extension.getTimeOnIteration()));
        }
        return Optional.none();
    }

    private TimeUnit toTimeUnit(String str) {
        TimeUnit tu;
        if (str.equalsIgnoreCase("ns")) {
            tu = TimeUnit.NANOSECONDS;
        } else if (str.equalsIgnoreCase("us")) {
            tu = TimeUnit.MICROSECONDS;
        } else if (str.equalsIgnoreCase("ms")) {
            tu = TimeUnit.MILLISECONDS;
        } else if (str.equalsIgnoreCase("s")) {
            tu = TimeUnit.SECONDS;
        } else if (str.equalsIgnoreCase("m")) {
            tu = TimeUnit.MINUTES;
        } else if (str.equalsIgnoreCase("h")) {
            tu = TimeUnit.HOURS;
        } else {
            throw new IllegalArgumentException("Unknown time unit: " + str);
        }
        return tu;
    }

    public SerializableOptions asSerializable() {
        Map<String, Collection<String>> benchmarkParameters = this.extension.getBenchmarkParameters();
        HashMap<String, Optional<Collection<String>>> asOptional = new HashMap<String, Optional<Collection<String>>>();
        if (benchmarkParameters != null) {
            for (Map.Entry<String, Collection<String>> entry : benchmarkParameters.entrySet()) {
                asOptional.put(entry.getKey(), (Optional<Collection<String>>)Optional.eitherOf(entry.getValue()));
            }
        }
        return new SerializableOptions(this, asOptional);
    }
}

