/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.japicmp.report;

import japicmp.model.JApiChangeStatus;
import japicmp.model.JApiClass;
import japicmp.model.JApiCompatibility;
import japicmp.model.JApiCompatibilityChange;
import japicmp.model.JApiConstructor;
import japicmp.model.JApiField;
import japicmp.model.JApiHasChangeStatus;
import japicmp.model.JApiImplementedInterface;
import japicmp.model.JApiMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.champeau.gradle.japicmp.report.AbstractContextAwareViolationRule;
import me.champeau.gradle.japicmp.report.PostProcessViolationsRule;
import me.champeau.gradle.japicmp.report.SetupRule;
import me.champeau.gradle.japicmp.report.Violation;
import me.champeau.gradle.japicmp.report.ViolationCheckContext;
import me.champeau.gradle.japicmp.report.ViolationCheckContextWithViolations;
import me.champeau.gradle.japicmp.report.ViolationRule;

public class ViolationsGenerator {
    private final List<Pattern> includePatterns;
    private final List<Pattern> excludePatterns;
    private final Map<JApiCompatibilityChange, List<ViolationRule>> apiCompatibilityRules = new HashMap<JApiCompatibilityChange, List<ViolationRule>>();
    private final Map<JApiChangeStatus, List<ViolationRule>> statusRules = new HashMap<JApiChangeStatus, List<ViolationRule>>();
    private final List<ViolationRule> genericRules = new ArrayList<ViolationRule>();
    private final List<SetupRule> setupRules = new ArrayList<SetupRule>();
    private final List<PostProcessViolationsRule> postProcessRules = new ArrayList<PostProcessViolationsRule>();

    public ViolationsGenerator(List<String> includePatterns, List<String> excludePatterns) {
        this.includePatterns = ViolationsGenerator.toPatterns(includePatterns);
        this.excludePatterns = ViolationsGenerator.toPatterns(excludePatterns);
    }

    private static List<Pattern> toPatterns(List<String> regexps) {
        if (regexps == null) {
            return null;
        }
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(regexps.size());
        for (String regexp : regexps) {
            patterns.add(Pattern.compile(regexp));
        }
        return patterns;
    }

    private static boolean anyMatches(List<Pattern> patterns, String className) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(className).find()) continue;
            return true;
        }
        return false;
    }

    public void addRule(SetupRule rule) {
        this.setupRules.add(rule);
    }

    public void addRule(PostProcessViolationsRule rule) {
        this.postProcessRules.add(rule);
    }

    public void addRule(ViolationRule rule) {
        this.genericRules.add(rule);
    }

    public void addRule(JApiCompatibilityChange change, ViolationRule rule) {
        List<ViolationRule> violationRules = this.apiCompatibilityRules.get(change);
        if (violationRules == null) {
            violationRules = new ArrayList<ViolationRule>();
            this.apiCompatibilityRules.put(change, violationRules);
        }
        violationRules.add(rule);
    }

    public void addRule(JApiChangeStatus status, ViolationRule rule) {
        List<ViolationRule> violationRules = this.statusRules.get(status);
        if (violationRules == null) {
            violationRules = new ArrayList<ViolationRule>();
            this.statusRules.put(status, violationRules);
        }
        violationRules.add(rule);
    }

    public Map<String, List<Violation>> toViolations(List<JApiClass> classes) {
        Context ctx = new Context();
        for (SetupRule setupRule : this.setupRules) {
            setupRule.execute(ctx);
        }
        this.injectContextIntoRules(ctx);
        for (JApiClass aClass : classes) {
            this.maybeProcess(aClass, ctx);
        }
        for (PostProcessViolationsRule postProcessViolationsRule : this.postProcessRules) {
            postProcessViolationsRule.execute(ctx);
        }
        return ctx.violations;
    }

    private void injectContextIntoRules(ViolationCheckContext context) {
        for (List<ViolationRule> rules : this.apiCompatibilityRules.values()) {
            this.injectContextIntoRules(context, rules);
        }
        for (List<ViolationRule> rules : this.statusRules.values()) {
            this.injectContextIntoRules(context, rules);
        }
        this.injectContextIntoRules(context, this.genericRules);
    }

    private void injectContextIntoRules(ViolationCheckContext context, List<ViolationRule> rules) {
        for (ViolationRule rule : rules) {
            if (!(rule instanceof AbstractContextAwareViolationRule)) continue;
            ((AbstractContextAwareViolationRule)rule).setContext(context);
        }
    }

    private void maybeProcess(JApiClass clazz, Context context) {
        String fullyQualifiedName = clazz.getFullyQualifiedName();
        if (this.includePatterns != null) {
            if (ViolationsGenerator.anyMatches(this.includePatterns, fullyQualifiedName)) {
                if (this.excludePatterns != null && ViolationsGenerator.anyMatches(this.excludePatterns, fullyQualifiedName)) {
                    return;
                }
                this.processClass(clazz, context);
                return;
            }
            return;
        }
        if (this.excludePatterns != null && ViolationsGenerator.anyMatches(this.excludePatterns, fullyQualifiedName)) {
            return;
        }
        this.processClass(clazz, context);
    }

    private void processCompatibilityChange(JApiCompatibilityChange kind, JApiCompatibility member, Context context) {
        List<ViolationRule> violationRules = this.apiCompatibilityRules.get(kind);
        if (violationRules != null) {
            for (ViolationRule violationRule : violationRules) {
                context.maybeAddViolation(violationRule.maybeViolation(member));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClass(JApiClass clazz, Context context) {
        String oldClass = context.currentClass;
        try {
            context.currentClass = clazz.getFullyQualifiedName();
            this.processAllChanges((JApiCompatibility)clazz, context);
            for (JApiField field : clazz.getFields()) {
                this.processAllChanges((JApiCompatibility)field, context);
            }
            for (JApiMethod method : clazz.getMethods()) {
                this.processAllChanges((JApiCompatibility)method, context);
            }
            for (JApiConstructor constructor : clazz.getConstructors()) {
                this.processAllChanges((JApiCompatibility)constructor, context);
            }
            for (JApiImplementedInterface anInterface : clazz.getInterfaces()) {
                this.processAllChanges((JApiCompatibility)anInterface, context);
            }
        }
        finally {
            context.currentClass = oldClass;
        }
    }

    private void processAllChanges(JApiCompatibility elt, Context context) {
        this.processElement(elt, context);
        for (JApiCompatibilityChange compatibilityChange : elt.getCompatibilityChanges()) {
            this.processCompatibilityChange(compatibilityChange, elt, context);
        }
    }

    private void processElement(JApiCompatibility elt, Context context) {
        List<ViolationRule> violationRules;
        for (ViolationRule genericRule : this.genericRules) {
            context.maybeAddViolation(genericRule.maybeViolation(elt));
        }
        if (elt instanceof JApiHasChangeStatus && (violationRules = this.statusRules.get(((JApiHasChangeStatus)elt).getChangeStatus())) != null) {
            for (ViolationRule violationRule : violationRules) {
                context.maybeAddViolation(violationRule.maybeViolation(elt));
            }
        }
    }

    private static class Context
    implements ViolationCheckContextWithViolations {
        private final Map<String, List<Violation>> violations = new LinkedHashMap<String, List<Violation>>();
        private final Map<String, ?> userData = new LinkedHashMap();
        private String currentClass;

        private Context() {
        }

        void maybeAddViolation(Violation v) {
            if (v == null) {
                return;
            }
            if (this.currentClass == null) {
                throw new IllegalStateException();
            }
            List<Violation> violations = this.violations.get(this.currentClass);
            if (violations == null) {
                violations = new ArrayList<Violation>();
                this.violations.put(this.currentClass, violations);
            }
            violations.add(v);
        }

        @Override
        public String getClassName() {
            return this.currentClass;
        }

        @Override
        public Map<String, ?> getUserData() {
            return this.userData;
        }

        @Override
        public Map<String, List<Violation>> getViolations() {
            return this.violations;
        }
    }
}

