/*
 * Decompiled with CFR 0.152.
 */
package me.champeau.gradle.japicmp;

import java.io.File;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.champeau.gradle.japicmp.JApiCmpWorkerAction;
import me.champeau.gradle.japicmp.JapiCmpWorkerConfiguration;
import me.champeau.gradle.japicmp.report.RichReport;
import me.champeau.gradle.japicmp.report.RuleConfiguration;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.CompileClasspath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.IsolationMode;
import org.gradle.workers.WorkerConfiguration;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class JapicmpTask
extends DefaultTask {
    private List<String> packageIncludes = new ArrayList<String>();
    private List<String> packageExcludes = new ArrayList<String>();
    private String accessModifier = "public";
    private boolean onlyModified = false;
    private boolean onlyBinaryIncompatibleModified = false;
    private File xmlOutputFile;
    private File htmlOutputFile;
    private File txtOutputFile;
    private boolean failOnModification = false;
    private boolean includeSynthetic = false;
    private FileCollection oldClasspath;
    private FileCollection newClasspath;
    private FileCollection oldArchives;
    private FileCollection newArchives;
    private boolean ignoreMissingClasses = false;
    private RichReport richReport;

    @TaskAction
    public void exec() {
        WorkerExecutor workerExecutor = (WorkerExecutor)this.getServices().get(WorkerExecutor.class);
        workerExecutor.submit(JApiCmpWorkerAction.class, (Action)new Action<WorkerConfiguration>(){

            public void execute(WorkerConfiguration workerConfiguration) {
                workerConfiguration.setIsolationMode(IsolationMode.PROCESS);
                HashSet<File> classpath = new HashSet<File>();
                if (JapicmpTask.this.richReport != null) {
                    for (RuleConfiguration configuration : JapicmpTask.this.richReport.getRules()) {
                        ProtectionDomain domain = configuration.getRuleClass().getProtectionDomain();
                        CodeSource codeSource = domain.getCodeSource();
                        if (codeSource == null) continue;
                        try {
                            classpath.add(new File(codeSource.getLocation().toURI()));
                        }
                        catch (URISyntaxException uRISyntaxException) {}
                    }
                }
                workerConfiguration.setClasspath(classpath);
                List baseline = JapicmpTask.this.oldArchives != null ? JapicmpTask.toArchives(JapicmpTask.this.oldArchives) : JapicmpTask.this.inferArchives(JapicmpTask.this.oldClasspath);
                List current = JapicmpTask.this.newArchives != null ? JapicmpTask.toArchives(JapicmpTask.this.newArchives) : JapicmpTask.this.inferArchives(JapicmpTask.this.newClasspath);
                workerConfiguration.setDisplayName("Comparing " + current + " with " + baseline);
                workerConfiguration.params(new Object[]{new JapiCmpWorkerConfiguration(JapicmpTask.this.getIncludeSynthetic(), JapicmpTask.this.getIgnoreMissingClasses(), JapicmpTask.this.getPackageIncludes(), JapicmpTask.this.getPackageExcludes(), JapicmpTask.toArchives(JapicmpTask.this.getOldClasspath()), JapicmpTask.toArchives(JapicmpTask.this.getNewClasspath()), baseline, current, JapicmpTask.this.getOnlyModified(), JapicmpTask.this.getOnlyBinaryIncompatibleModified(), JapicmpTask.this.getAccessModifier(), JapicmpTask.this.getXmlOutputFile(), JapicmpTask.this.getHtmlOutputFile(), JapicmpTask.this.getTxtOutputFile(), JapicmpTask.this.getFailOnModification(), JapicmpTask.this.getProject().getBuildDir(), JapicmpTask.this.richReport)});
            }
        });
    }

    private List<JApiCmpWorkerAction.Archive> inferArchives(FileCollection fc) {
        if (fc instanceof Configuration) {
            ArrayList<JApiCmpWorkerAction.Archive> archives = new ArrayList<JApiCmpWorkerAction.Archive>();
            Set firstLevelModuleDependencies = ((Configuration)fc).getResolvedConfiguration().getFirstLevelModuleDependencies();
            for (ResolvedDependency moduleDependency : firstLevelModuleDependencies) {
                this.collectArchives(archives, moduleDependency);
            }
            return archives;
        }
        return JapicmpTask.toArchives(fc);
    }

    private static List<JApiCmpWorkerAction.Archive> toArchives(FileCollection fc) {
        Set files = fc.getFiles();
        ArrayList<JApiCmpWorkerAction.Archive> archives = new ArrayList<JApiCmpWorkerAction.Archive>(files.size());
        for (File file : files) {
            archives.add(new JApiCmpWorkerAction.Archive(file, "1.0"));
        }
        return archives;
    }

    private void collectArchives(List<JApiCmpWorkerAction.Archive> archives, ResolvedDependency resolvedDependency) {
        String version = resolvedDependency.getModule().getId().getVersion();
        archives.add(new JApiCmpWorkerAction.Archive(((ResolvedArtifact)resolvedDependency.getAllModuleArtifacts().iterator().next()).getFile(), version));
        for (ResolvedDependency dependency : resolvedDependency.getChildren()) {
            this.collectArchives(archives, dependency);
        }
    }

    public void richReport(Action<? super RichReport> configureAction) {
        if (this.richReport == null) {
            this.richReport = new RichReport();
        }
        configureAction.execute((Object)this.richReport);
    }

    @Input
    @Optional
    public List<String> getPackageIncludes() {
        return this.packageIncludes;
    }

    public void setPackageIncludes(List<String> packageIncludes) {
        this.packageIncludes = packageIncludes;
    }

    @Input
    @Optional
    public List<String> getPackageExcludes() {
        return this.packageExcludes;
    }

    public void setPackageExcludes(List<String> packageExcludes) {
        this.packageExcludes = packageExcludes;
    }

    @Input
    @Optional
    public String getAccessModifier() {
        return this.accessModifier;
    }

    public void setAccessModifier(String accessModifier) {
        this.accessModifier = accessModifier;
    }

    @Input
    @Optional
    public boolean getOnlyModified() {
        return this.onlyModified;
    }

    public boolean isOnlyModified() {
        return this.onlyModified;
    }

    public void setOnlyModified(boolean onlyModified) {
        this.onlyModified = onlyModified;
    }

    @Input
    @Optional
    public boolean getOnlyBinaryIncompatibleModified() {
        return this.onlyBinaryIncompatibleModified;
    }

    public boolean isOnlyBinaryIncompatibleModified() {
        return this.onlyBinaryIncompatibleModified;
    }

    public void setOnlyBinaryIncompatibleModified(boolean onlyBinaryIncompatibleModified) {
        this.onlyBinaryIncompatibleModified = onlyBinaryIncompatibleModified;
    }

    @OutputFile
    @Optional
    public File getXmlOutputFile() {
        return this.xmlOutputFile;
    }

    public void setXmlOutputFile(File xmlOutputFile) {
        this.xmlOutputFile = xmlOutputFile;
    }

    @OutputFile
    @Optional
    public File getHtmlOutputFile() {
        return this.htmlOutputFile;
    }

    public void setHtmlOutputFile(File htmlOutputFile) {
        this.htmlOutputFile = htmlOutputFile;
    }

    @OutputFile
    @Optional
    public File getTxtOutputFile() {
        return this.txtOutputFile;
    }

    public void setTxtOutputFile(File txtOutputFile) {
        this.txtOutputFile = txtOutputFile;
    }

    @Input
    @Optional
    public boolean getFailOnModification() {
        return this.failOnModification;
    }

    public boolean isFailOnModification() {
        return this.failOnModification;
    }

    public void setFailOnModification(boolean failOnModification) {
        this.failOnModification = failOnModification;
    }

    @Input
    @Optional
    public boolean getIncludeSynthetic() {
        return this.includeSynthetic;
    }

    public boolean isIncludeSynthetic() {
        return this.includeSynthetic;
    }

    public void setIncludeSynthetic(boolean includeSynthetic) {
        this.includeSynthetic = includeSynthetic;
    }

    @CompileClasspath
    public FileCollection getOldClasspath() {
        return this.oldClasspath;
    }

    public void setOldClasspath(FileCollection oldClasspath) {
        this.oldClasspath = oldClasspath;
    }

    @CompileClasspath
    public FileCollection getNewClasspath() {
        return this.newClasspath;
    }

    public void setNewClasspath(FileCollection newClasspath) {
        this.newClasspath = newClasspath;
    }

    @Optional
    @CompileClasspath
    public FileCollection getOldArchives() {
        return this.oldArchives;
    }

    public void setOldArchives(FileCollection oldArchives) {
        this.oldArchives = oldArchives;
    }

    @Optional
    @CompileClasspath
    public FileCollection getNewArchives() {
        return this.newArchives;
    }

    public void setNewArchives(FileCollection newArchives) {
        this.newArchives = newArchives;
    }

    @Optional
    @Input
    public boolean getIgnoreMissingClasses() {
        return this.ignoreMissingClasses;
    }

    public boolean isIgnoreMissingClasses() {
        return this.ignoreMissingClasses;
    }

    public void setIgnoreMissingClasses(boolean ignoreMissingClasses) {
        this.ignoreMissingClasses = ignoreMissingClasses;
    }

    @Optional
    @Nested
    public RichReport getRichReport() {
        return this.richReport;
    }

    public void setRichReport(RichReport richReport) {
        this.richReport = richReport;
    }
}

