/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.codec.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.web.codec.BodyCodec;
import io.vertx.ext.web.codec.spi.BodyStream;

public class StreamingBodyCodec
implements BodyCodec<Void> {
    private final WriteStream<Buffer> stream;
    private final boolean close;

    public StreamingBodyCodec(WriteStream<Buffer> stream) {
        this(stream, true);
    }

    public StreamingBodyCodec(WriteStream<Buffer> stream, boolean close) {
        this.stream = stream;
        this.close = close;
    }

    @Override
    public void create(Handler<AsyncResult<BodyStream<Void>>> handler) {
        handler.handle((Object)Future.succeededFuture((Object)new BodyStream<Void>(){
            Future<Void> fut = Future.future();

            @Override
            public Future<Void> result() {
                return this.fut;
            }

            public void handle(Throwable cause) {
                this.fut.tryFail(cause);
            }

            public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
                StreamingBodyCodec.this.stream.exceptionHandler(handler);
                return this;
            }

            public WriteStream<Buffer> write(Buffer data, Handler<AsyncResult<Void>> handler) {
                StreamingBodyCodec.this.stream.write((Object)data, handler);
                return this;
            }

            public WriteStream<Buffer> write(Buffer data) {
                return this.write(data, (Handler<AsyncResult<Void>>)null);
            }

            public void end() {
                this.end((Handler<AsyncResult<Void>>)((Handler)null));
            }

            public void end(Handler<AsyncResult<Void>> handler) {
                if (StreamingBodyCodec.this.close) {
                    StreamingBodyCodec.this.stream.end(ar -> {
                        if (ar.succeeded()) {
                            this.fut.tryComplete();
                        } else {
                            this.fut.tryFail(ar.cause());
                        }
                        if (handler != null) {
                            handler.handle(ar);
                        }
                    });
                } else {
                    this.fut.tryComplete();
                    if (handler != null) {
                        handler.handle((Object)Future.succeededFuture());
                    }
                }
            }

            public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
                StreamingBodyCodec.this.stream.setWriteQueueMaxSize(maxSize);
                return this;
            }

            public boolean writeQueueFull() {
                return StreamingBodyCodec.this.stream.writeQueueFull();
            }

            public WriteStream<Buffer> drainHandler(Handler<Void> handler) {
                StreamingBodyCodec.this.stream.drainHandler(handler);
                return this;
            }
        }));
    }
}

