/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.DynamicRealmObject;
import io.realm.ImportFlag;
import io.realm.ManagedListOperator;
import io.realm.Realm;
import io.realm.RealmModel;
import io.realm.internal.OsList;
import io.realm.internal.OsObjectStore;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.RealmProxyMediator;
import io.realm.internal.Table;
import io.realm.internal.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import javax.annotation.Nullable;

final class RealmModelListOperator<T>
extends ManagedListOperator<T> {
    @Nullable
    private final String className;

    RealmModelListOperator(BaseRealm realm, OsList osList, @Nullable Class<T> clazz, @Nullable String className) {
        super(realm, osList, clazz);
        this.className = className;
    }

    @Override
    public boolean forRealmModel() {
        return true;
    }

    @Override
    public T get(int index) {
        return (T)this.realm.get(this.clazz, this.className, this.osList.getUncheckedRow(index));
    }

    @Override
    protected void checkValidValue(@Nullable Object value) {
        if (value == null) {
            throw new IllegalArgumentException("RealmList does not accept null values.");
        }
        if (!(value instanceof RealmModel)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unacceptable value type. Acceptable: %1$s, actual: %2$s .", "java.lang.String", value.getClass().getName()));
        }
    }

    private void checkInsertIndex(int index) {
        int size = this.size();
        if (index < 0 || size < index) {
            throw new IndexOutOfBoundsException("Invalid index " + index + ", size is " + this.osList.size());
        }
    }

    @Override
    public void appendValue(Object value) {
        RealmModel realmObject = (RealmModel)value;
        boolean copyObject = this.checkCanObjectBeCopied(this.realm, realmObject);
        if (this.isEmbedded((RealmModel)value)) {
            if (value instanceof DynamicRealmObject) {
                throw new IllegalArgumentException("Embedded objects are not supported by RealmLists of DynamicRealmObjects yet.");
            }
            long objKey = this.osList.createAndAddEmbeddedObject();
            this.updateEmbeddedObject(realmObject, objKey);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)(copyObject ? this.copyToRealm((RealmModel)value) : realmObject);
            this.osList.addRow(proxy.realmGet$proxyState().getRow$realm().getObjectKey());
        }
    }

    @Override
    protected void insertNull(int index) {
        throw new RuntimeException("Should not reach here.");
    }

    @Override
    public void insertValue(int index, Object value) {
        this.checkInsertIndex(index);
        RealmModel realmObject = (RealmModel)value;
        boolean copyObject = this.checkCanObjectBeCopied(this.realm, realmObject);
        if (this.isEmbedded(realmObject)) {
            if (value instanceof DynamicRealmObject) {
                throw new IllegalArgumentException("Embedded objects are not supported by RealmLists of DynamicRealmObjects yet.");
            }
            long objKey = this.osList.createAndAddEmbeddedObject(index);
            this.updateEmbeddedObject(realmObject, objKey);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)(copyObject ? this.copyToRealm((RealmModel)value) : realmObject);
            this.osList.insertRow(index, proxy.realmGet$proxyState().getRow$realm().getObjectKey());
        }
    }

    private boolean isEmbedded(RealmModel value) {
        if (this.realm instanceof Realm) {
            return this.realm.getSchema().getSchemaForClass(value.getClass()).isEmbedded();
        }
        String objectType = ((DynamicRealmObject)value).getType();
        return this.realm.getSchema().getSchemaForClass(objectType).isEmbedded();
    }

    @Override
    protected void setNull(int index) {
        throw new RuntimeException("Should not reach here.");
    }

    @Override
    protected void setValue(int index, Object value) {
        RealmModel realmObject = (RealmModel)value;
        boolean copyObject = this.checkCanObjectBeCopied(this.realm, realmObject);
        if (this.isEmbedded(realmObject)) {
            if (value instanceof DynamicRealmObject) {
                throw new IllegalArgumentException("Embedded objects are not supported by RealmLists of DynamicRealmObjects yet.");
            }
            long objKey = this.osList.createAndSetEmbeddedObject(index);
            this.updateEmbeddedObject(realmObject, objKey);
        } else {
            RealmObjectProxy proxy = (RealmObjectProxy)(copyObject ? this.copyToRealm((RealmModel)value) : realmObject);
            this.osList.setRow(index, proxy.realmGet$proxyState().getRow$realm().getObjectKey());
        }
    }

    private boolean checkCanObjectBeCopied(BaseRealm realm, RealmModel object) {
        if (object instanceof RealmObjectProxy) {
            RealmObjectProxy proxy = (RealmObjectProxy)object;
            if (proxy instanceof DynamicRealmObject) {
                String listClassName = this.className;
                if (proxy.realmGet$proxyState().getRealm$realm() == realm) {
                    String objectClassName = ((DynamicRealmObject)object).getType();
                    if (listClassName.equals(objectClassName)) {
                        return false;
                    }
                    throw new IllegalArgumentException(String.format(Locale.US, "The object has a different type from list's. Type of the list is '%s', type of object is '%s'.", listClassName, objectClassName));
                }
                if (realm.threadId == proxy.realmGet$proxyState().getRealm$realm().threadId) {
                    throw new IllegalArgumentException("Cannot copy DynamicRealmObject between Realm instances.");
                }
                throw new IllegalStateException("Cannot copy an object to a Realm instance created in another thread.");
            }
            if (proxy.realmGet$proxyState().getRow$realm() != null && proxy.realmGet$proxyState().getRealm$realm().getPath().equals(realm.getPath())) {
                if (realm != proxy.realmGet$proxyState().getRealm$realm()) {
                    throw new IllegalArgumentException("Cannot copy an object from another Realm instance.");
                }
                return false;
            }
        }
        return true;
    }

    private <E extends RealmModel> E copyToRealm(E object) {
        Realm realm = (Realm)this.realm;
        if (OsObjectStore.getPrimaryKeyForObject(realm.getSharedRealm(), realm.getConfiguration().getSchemaMediator().getSimpleClassName(object.getClass())) != null) {
            return realm.copyToRealmOrUpdate(object, new ImportFlag[0]);
        }
        return realm.copyToRealm(object, new ImportFlag[0]);
    }

    private void updateEmbeddedObject(RealmModel unmanagedObject, long objKey) {
        RealmProxyMediator schemaMediator = this.realm.getConfiguration().getSchemaMediator();
        Class<? extends RealmModel> modelClass = Util.getOriginalModelClass(unmanagedObject.getClass());
        Table table = ((Realm)this.realm).getTable(modelClass);
        RealmModel managedObject = schemaMediator.newInstance(modelClass, this.realm, table.getUncheckedRow(objKey), this.realm.getSchema().getColumnInfo(modelClass), true, Collections.EMPTY_LIST);
        schemaMediator.updateEmbeddedObject((Realm)this.realm, unmanagedObject, managedObject, new HashMap<RealmModel, RealmObjectProxy>(), Collections.EMPTY_SET);
    }
}

