/*
 * Decompiled with CFR 0.152.
 */
package io.realm;

import io.realm.BaseRealm;
import io.realm.BinaryListOperator;
import io.realm.BooleanListOperator;
import io.realm.DateListOperator;
import io.realm.Decimal128ListOperator;
import io.realm.DoubleListOperator;
import io.realm.DynamicRealm;
import io.realm.FloatListOperator;
import io.realm.LongListOperator;
import io.realm.ManagedListOperator;
import io.realm.ObjectIdListOperator;
import io.realm.ProxyState;
import io.realm.RealmFieldType;
import io.realm.RealmList;
import io.realm.RealmModel;
import io.realm.RealmObject;
import io.realm.RealmObjectSchema;
import io.realm.RealmResults;
import io.realm.RealmSchema;
import io.realm.StringListOperator;
import io.realm.internal.CheckedRow;
import io.realm.internal.OsList;
import io.realm.internal.RealmObjectProxy;
import io.realm.internal.Row;
import io.realm.internal.Table;
import io.realm.internal.UncheckedRow;
import io.realm.internal.android.JsonUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nullable;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;

public class DynamicRealmObject
extends RealmObject
implements RealmObjectProxy {
    static final String MSG_LINK_QUERY_NOT_SUPPORTED = "Queries across relationships are not supported";
    private final ProxyState<DynamicRealmObject> proxyState = new ProxyState<DynamicRealmObject>(this);

    public DynamicRealmObject(RealmModel obj) {
        if (obj == null) {
            throw new IllegalArgumentException("A non-null object must be provided.");
        }
        if (obj instanceof DynamicRealmObject) {
            throw new IllegalArgumentException("The object is already a DynamicRealmObject: " + obj);
        }
        if (!RealmObject.isManaged(obj)) {
            throw new IllegalArgumentException("An object managed by Realm must be provided. This is an unmanaged object.");
        }
        if (!RealmObject.isValid(obj)) {
            throw new IllegalArgumentException("A valid object managed by Realm must be provided. This object was deleted.");
        }
        RealmObjectProxy proxy = (RealmObjectProxy)obj;
        Row row = proxy.realmGet$proxyState().getRow$realm();
        this.proxyState.setRealm$realm(proxy.realmGet$proxyState().getRealm$realm());
        this.proxyState.setRow$realm(((UncheckedRow)row).convertToChecked());
        this.proxyState.setConstructionFinished();
    }

    DynamicRealmObject(BaseRealm realm, Row row) {
        this.proxyState.setRealm$realm(realm);
        this.proxyState.setRow$realm(row);
        this.proxyState.setConstructionFinished();
    }

    public <E> E get(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
        switch (type) {
            case BOOLEAN: {
                return (E)Boolean.valueOf(this.proxyState.getRow$realm().getBoolean(columnKey));
            }
            case INTEGER: {
                return (E)Long.valueOf(this.proxyState.getRow$realm().getLong(columnKey));
            }
            case FLOAT: {
                return (E)Float.valueOf(this.proxyState.getRow$realm().getFloat(columnKey));
            }
            case DOUBLE: {
                return (E)Double.valueOf(this.proxyState.getRow$realm().getDouble(columnKey));
            }
            case STRING: {
                return (E)this.proxyState.getRow$realm().getString(columnKey);
            }
            case BINARY: {
                return (E)this.proxyState.getRow$realm().getBinaryByteArray(columnKey);
            }
            case DATE: {
                return (E)this.proxyState.getRow$realm().getDate(columnKey);
            }
            case DECIMAL128: {
                return (E)this.proxyState.getRow$realm().getDecimal128(columnKey);
            }
            case OBJECT_ID: {
                return (E)this.proxyState.getRow$realm().getObjectId(columnKey);
            }
            case OBJECT: {
                return (E)this.getObject(fieldName);
            }
            case LIST: {
                return (E)this.getList(fieldName);
            }
        }
        throw new IllegalStateException("Field type not supported: " + (Object)((Object)type));
    }

    public boolean getBoolean(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getBoolean(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.BOOLEAN);
            throw e;
        }
    }

    public int getInt(String fieldName) {
        return (int)this.getLong(fieldName);
    }

    public short getShort(String fieldName) {
        return (short)this.getLong(fieldName);
    }

    public long getLong(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getLong(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.INTEGER);
            throw e;
        }
    }

    public byte getByte(String fieldName) {
        return (byte)this.getLong(fieldName);
    }

    public float getFloat(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getFloat(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.FLOAT);
            throw e;
        }
    }

    public double getDouble(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getDouble(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.DOUBLE);
            throw e;
        }
    }

    public byte[] getBlob(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getBinaryByteArray(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.BINARY);
            throw e;
        }
    }

    public String getString(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            return this.proxyState.getRow$realm().getString(columnKey);
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.STRING);
            throw e;
        }
    }

    public Date getDate(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.DATE);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDate(columnKey);
    }

    public Decimal128 getDecimal128(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.DECIMAL128);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        return this.proxyState.getRow$realm().getDecimal128(columnKey);
    }

    public ObjectId getObjectId(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.OBJECT_ID);
        if (this.proxyState.getRow$realm().isNull(columnKey)) {
            return null;
        }
        return this.proxyState.getRow$realm().getObjectId(columnKey);
    }

    @Nullable
    public DynamicRealmObject getObject(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.checkFieldType(fieldName, columnKey, RealmFieldType.OBJECT);
        if (this.proxyState.getRow$realm().isNullLink(columnKey)) {
            return null;
        }
        long linkObjectKey = this.proxyState.getRow$realm().getLink(columnKey);
        CheckedRow linkRow = this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey).getCheckedRow(linkObjectKey);
        return new DynamicRealmObject(this.proxyState.getRealm$realm(), linkRow);
    }

    public RealmList<DynamicRealmObject> getList(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        try {
            OsList osList = this.proxyState.getRow$realm().getModelList(columnKey);
            String className = osList.getTargetTable().getClassName();
            return new RealmList<DynamicRealmObject>(className, osList, this.proxyState.getRealm$realm());
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, RealmFieldType.LIST);
            throw e;
        }
    }

    public <E> RealmList<E> getList(String fieldName, Class<E> primitiveType) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (primitiveType == null) {
            throw new IllegalArgumentException("Non-null 'primitiveType' required.");
        }
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType realmType = this.classToRealmType(primitiveType);
        try {
            OsList osList = this.proxyState.getRow$realm().getValueList(columnKey, realmType);
            return new RealmList<E>(primitiveType, osList, this.proxyState.getRealm$realm());
        }
        catch (IllegalArgumentException e) {
            this.checkFieldType(fieldName, columnKey, realmType);
            throw e;
        }
    }

    private <E> RealmFieldType classToRealmType(Class<E> primitiveType) {
        if (primitiveType.equals(Integer.class) || primitiveType.equals(Long.class) || primitiveType.equals(Short.class) || primitiveType.equals(Byte.class)) {
            return RealmFieldType.INTEGER_LIST;
        }
        if (primitiveType.equals(Boolean.class)) {
            return RealmFieldType.BOOLEAN_LIST;
        }
        if (primitiveType.equals(String.class)) {
            return RealmFieldType.STRING_LIST;
        }
        if (primitiveType.equals(byte[].class)) {
            return RealmFieldType.BINARY_LIST;
        }
        if (primitiveType.equals(Date.class)) {
            return RealmFieldType.DATE_LIST;
        }
        if (primitiveType.equals(Float.class)) {
            return RealmFieldType.FLOAT_LIST;
        }
        if (primitiveType.equals(Double.class)) {
            return RealmFieldType.DOUBLE_LIST;
        }
        if (primitiveType.equals(Decimal128.class)) {
            return RealmFieldType.DECIMAL128_LIST;
        }
        if (primitiveType.equals(ObjectId.class)) {
            return RealmFieldType.OBJECT_ID_LIST;
        }
        throw new IllegalArgumentException("Unsupported element type. Only primitive types supported. Yours was: " + primitiveType);
    }

    public boolean isNull(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
        switch (type) {
            case OBJECT: {
                return this.proxyState.getRow$realm().isNullLink(columnKey);
            }
            case BOOLEAN: 
            case INTEGER: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BINARY: 
            case DATE: 
            case DECIMAL128: 
            case OBJECT_ID: {
                return this.proxyState.getRow$realm().isNull(columnKey);
            }
        }
        return false;
    }

    public boolean hasField(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (fieldName == null || fieldName.isEmpty()) {
            return false;
        }
        return this.proxyState.getRow$realm().hasColumn(fieldName);
    }

    public String[] getFieldNames() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getColumnNames();
    }

    public void set(String fieldName, Object value) {
        this.proxyState.getRealm$realm().checkIfValid();
        boolean isString = value instanceof String;
        String strValue = isString ? (String)value : null;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
        if (isString && type != RealmFieldType.STRING) {
            switch (type) {
                case BOOLEAN: {
                    value = Boolean.parseBoolean(strValue);
                    break;
                }
                case INTEGER: {
                    value = Long.parseLong(strValue);
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(Float.parseFloat(strValue));
                    break;
                }
                case DOUBLE: {
                    value = Double.parseDouble(strValue);
                    break;
                }
                case DATE: {
                    value = JsonUtils.stringToDate(strValue);
                    break;
                }
                case DECIMAL128: {
                    value = Decimal128.parse((String)strValue);
                    break;
                }
                case OBJECT_ID: {
                    value = new ObjectId(strValue);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.US, "Field %s is not a String field, and the provide value could not be automatically converted: %s. Use a typedsetter instead", fieldName, value));
                }
            }
        }
        if (value == null) {
            this.setNull(fieldName);
        } else {
            this.setValue(fieldName, value);
        }
    }

    private void setValue(String fieldName, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass == Boolean.class) {
            this.setBoolean(fieldName, (Boolean)value);
        } else if (valueClass == Short.class) {
            this.setShort(fieldName, (Short)value);
        } else if (valueClass == Integer.class) {
            this.setInt(fieldName, (Integer)value);
        } else if (valueClass == Long.class) {
            this.setLong(fieldName, (Long)value);
        } else if (valueClass == Byte.class) {
            this.setByte(fieldName, (Byte)value);
        } else if (valueClass == Float.class) {
            this.setFloat(fieldName, ((Float)value).floatValue());
        } else if (valueClass == Double.class) {
            this.setDouble(fieldName, (Double)value);
        } else if (valueClass == String.class) {
            this.setString(fieldName, (String)value);
        } else if (value instanceof Date) {
            this.setDate(fieldName, (Date)value);
        } else if (value instanceof byte[]) {
            this.setBlob(fieldName, (byte[])value);
        } else if (valueClass == DynamicRealmObject.class) {
            this.setObject(fieldName, (DynamicRealmObject)value);
        } else if (valueClass == RealmList.class) {
            RealmList list = (RealmList)value;
            this.setList(fieldName, list);
        } else if (valueClass == Decimal128.class) {
            this.setDecimal128(fieldName, (Decimal128)value);
        } else if (valueClass == ObjectId.class) {
            this.setObjectId(fieldName, (ObjectId)value);
        } else {
            throw new IllegalArgumentException("Value is of an type not supported: " + value.getClass());
        }
    }

    public void setBoolean(String fieldName, boolean value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setBoolean(columnKey, value);
    }

    public void setShort(String fieldName, short value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setLong(columnKey, value);
    }

    public void setInt(String fieldName, int value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setLong(columnKey, value);
    }

    public void setLong(String fieldName, long value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setLong(columnKey, value);
    }

    public void setByte(String fieldName, byte value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setLong(columnKey, value);
    }

    public void setFloat(String fieldName, float value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setFloat(columnKey, value);
    }

    public void setDouble(String fieldName, double value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setDouble(columnKey, value);
    }

    public void setString(String fieldName, @Nullable String value) {
        this.proxyState.getRealm$realm().checkIfValid();
        this.checkIsPrimaryKey(fieldName);
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setString(columnKey, value);
    }

    public void setBlob(String fieldName, @Nullable byte[] value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        this.proxyState.getRow$realm().setBinaryByteArray(columnKey, value);
    }

    public void setDate(String fieldName, @Nullable Date value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnKey);
        } else {
            this.proxyState.getRow$realm().setDate(columnKey, value);
        }
    }

    public void setDecimal128(String fieldName, @Nullable Decimal128 value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnKey);
        } else {
            this.proxyState.getRow$realm().setDecimal128(columnKey, value);
        }
    }

    public void setObjectId(String fieldName, @Nullable ObjectId value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().setNull(columnKey);
        } else {
            this.proxyState.getRow$realm().setObjectId(columnKey, value);
        }
    }

    public void setObject(String fieldName, @Nullable DynamicRealmObject value) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        if (value == null) {
            this.proxyState.getRow$realm().nullifyLink(columnKey);
        } else {
            Table inputTable;
            if (value.proxyState.getRealm$realm() == null || value.proxyState.getRow$realm() == null) {
                throw new IllegalArgumentException("Cannot link to objects that are not part of the Realm.");
            }
            if (this.proxyState.getRealm$realm() != value.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Cannot add an object from another Realm instance.");
            }
            Table table = this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey);
            if (!table.hasSameSchema(inputTable = value.proxyState.getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Type of object is wrong. Was %s, expected %s", inputTable.getName(), table.getName()));
            }
            this.proxyState.getRow$realm().setLink(columnKey, value.proxyState.getRow$realm().getObjectKey());
        }
    }

    public <E> void setList(String fieldName, RealmList<E> list) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (list == null) {
            throw new IllegalArgumentException("Non-null 'list' required");
        }
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType columnType = this.proxyState.getRow$realm().getColumnType(columnKey);
        switch (columnType) {
            case LIST: {
                E element;
                if (!list.isEmpty() && !((element = list.first()) instanceof DynamicRealmObject) && RealmModel.class.isAssignableFrom(element.getClass())) {
                    throw new IllegalArgumentException("RealmList must contain `DynamicRealmObject's, not Java model classes.");
                }
                this.setModelList(fieldName, list);
                break;
            }
            case INTEGER_LIST: 
            case BOOLEAN_LIST: 
            case STRING_LIST: 
            case BINARY_LIST: 
            case DATE_LIST: 
            case FLOAT_LIST: 
            case DOUBLE_LIST: 
            case DECIMAL128_LIST: 
            case OBJECT_ID_LIST: {
                this.setValueList(fieldName, list, columnType);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Field '%s' is not a list but a %s", new Object[]{fieldName, columnType}));
            }
        }
    }

    private void setModelList(String fieldName, RealmList<DynamicRealmObject> list) {
        int i;
        boolean typeValidated;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        OsList osList = this.proxyState.getRow$realm().getModelList(columnKey);
        Table linkTargetTable = osList.getTargetTable();
        String linkTargetTableName = linkTargetTable.getClassName();
        if (list.className == null && list.clazz == null) {
            typeValidated = false;
        } else {
            String listType;
            String string = listType = list.className != null ? list.className : this.proxyState.getRealm$realm().getSchema().getTable(list.clazz).getClassName();
            if (!linkTargetTableName.equals(listType)) {
                throw new IllegalArgumentException(String.format(Locale.US, "The elements in the list are not the proper type. Was %s expected %s.", listType, linkTargetTableName));
            }
            typeValidated = true;
        }
        int listLength = list.size();
        long[] indices = new long[listLength];
        for (i = 0; i < listLength; ++i) {
            RealmObjectProxy obj = list.get(i);
            if (obj.realmGet$proxyState().getRealm$realm() != this.proxyState.getRealm$realm()) {
                throw new IllegalArgumentException("Each element in 'list' must belong to the same Realm instance.");
            }
            if (!typeValidated && !linkTargetTable.hasSameSchema(obj.realmGet$proxyState().getRow$realm().getTable())) {
                throw new IllegalArgumentException(String.format(Locale.US, "Element at index %d is not the proper type. Was '%s' expected '%s'.", i, obj.realmGet$proxyState().getRow$realm().getTable().getClassName(), linkTargetTableName));
            }
            indices[i] = obj.realmGet$proxyState().getRow$realm().getObjectKey();
        }
        osList.removeAll();
        for (i = 0; i < listLength; ++i) {
            osList.addRow(indices[i]);
        }
    }

    private <E> void setValueList(String fieldName, RealmList<E> list, RealmFieldType primitiveType) {
        Class elementClass;
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        OsList osList = this.proxyState.getRow$realm().getValueList(columnKey, primitiveType);
        switch (primitiveType) {
            case INTEGER_LIST: {
                elementClass = Long.class;
                break;
            }
            case BOOLEAN_LIST: {
                elementClass = Boolean.class;
                break;
            }
            case STRING_LIST: {
                elementClass = String.class;
                break;
            }
            case BINARY_LIST: {
                elementClass = byte[].class;
                break;
            }
            case DATE_LIST: {
                elementClass = Date.class;
                break;
            }
            case FLOAT_LIST: {
                elementClass = Float.class;
                break;
            }
            case DOUBLE_LIST: {
                elementClass = Double.class;
                break;
            }
            case DECIMAL128_LIST: {
                elementClass = Decimal128.class;
                break;
            }
            case OBJECT_ID_LIST: {
                elementClass = ObjectId.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)primitiveType));
            }
        }
        ManagedListOperator<Long> operator = this.getOperator(this.proxyState.getRealm$realm(), osList, primitiveType, elementClass);
        if (list.isManaged() && osList.size() == (long)list.size()) {
            int size = list.size();
            Iterator<E> iterator = list.iterator();
            for (int i = 0; i < size; ++i) {
                E value = iterator.next();
                operator.set(i, value);
            }
        } else {
            osList.removeAll();
            for (E value : list) {
                operator.append(value);
            }
        }
    }

    private <E> ManagedListOperator<E> getOperator(BaseRealm realm, OsList osList, RealmFieldType valueListType, Class<E> valueClass) {
        if (valueListType == RealmFieldType.STRING_LIST) {
            return new StringListOperator(realm, osList, valueClass);
        }
        if (valueListType == RealmFieldType.INTEGER_LIST) {
            return new LongListOperator<String>(realm, osList, valueClass);
        }
        if (valueListType == RealmFieldType.BOOLEAN_LIST) {
            return new BooleanListOperator(realm, osList, (Class<Boolean>)valueClass);
        }
        if (valueListType == RealmFieldType.BINARY_LIST) {
            return new BinaryListOperator(realm, osList, (Class<byte[]>)valueClass);
        }
        if (valueListType == RealmFieldType.DOUBLE_LIST) {
            return new DoubleListOperator(realm, osList, (Class<Double>)valueClass);
        }
        if (valueListType == RealmFieldType.FLOAT_LIST) {
            return new FloatListOperator(realm, osList, (Class<Float>)valueClass);
        }
        if (valueListType == RealmFieldType.DATE_LIST) {
            return new DateListOperator(realm, osList, (Class<Date>)valueClass);
        }
        if (valueListType == RealmFieldType.DECIMAL128_LIST) {
            return new Decimal128ListOperator(realm, osList, (Class<Decimal128>)valueClass);
        }
        if (valueListType == RealmFieldType.OBJECT_ID_LIST) {
            return new ObjectIdListOperator(realm, osList, (Class<ObjectId>)valueClass);
        }
        throw new IllegalArgumentException("Unexpected list type: " + valueListType.name());
    }

    public void setNull(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
        if (type == RealmFieldType.OBJECT) {
            this.proxyState.getRow$realm().nullifyLink(columnKey);
        } else {
            this.checkIsPrimaryKey(fieldName);
            this.proxyState.getRow$realm().setNull(columnKey);
        }
    }

    public String getType() {
        this.proxyState.getRealm$realm().checkIfValid();
        return this.proxyState.getRow$realm().getTable().getClassName();
    }

    public RealmFieldType getFieldType(String fieldName) {
        this.proxyState.getRealm$realm().checkIfValid();
        long columnKey = this.proxyState.getRow$realm().getColumnKey(fieldName);
        return this.proxyState.getRow$realm().getColumnType(columnKey);
    }

    private void checkFieldType(String fieldName, long columnIndex, RealmFieldType expectedType) {
        RealmFieldType columnType = this.proxyState.getRow$realm().getColumnType(columnIndex);
        if (columnType != expectedType) {
            String expectedIndefiniteVowel = "";
            if (expectedType == RealmFieldType.INTEGER || expectedType == RealmFieldType.OBJECT) {
                expectedIndefiniteVowel = "n";
            }
            String columnTypeIndefiniteVowel = "";
            if (columnType == RealmFieldType.INTEGER || columnType == RealmFieldType.OBJECT) {
                columnTypeIndefiniteVowel = "n";
            }
            throw new IllegalArgumentException(String.format(Locale.US, "'%s' is not a%s '%s', but a%s '%s'.", new Object[]{fieldName, expectedIndefiniteVowel, expectedType, columnTypeIndefiniteVowel, columnType}));
        }
    }

    public int hashCode() {
        this.proxyState.getRealm$realm().checkIfValid();
        String realmName = this.proxyState.getRealm$realm().getPath();
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        long rowIndex = this.proxyState.getRow$realm().getObjectKey();
        int result = 17;
        result = 31 * result + (realmName != null ? realmName.hashCode() : 0);
        result = 31 * result + (tableName != null ? tableName.hashCode() : 0);
        result = 31 * result + (int)(rowIndex ^ rowIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        this.proxyState.getRealm$realm().checkIfValid();
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DynamicRealmObject other = (DynamicRealmObject)o;
        String path = this.proxyState.getRealm$realm().getPath();
        String otherPath = other.proxyState.getRealm$realm().getPath();
        if (path != null ? !path.equals(otherPath) : otherPath != null) {
            return false;
        }
        String tableName = this.proxyState.getRow$realm().getTable().getName();
        String otherTableName = other.proxyState.getRow$realm().getTable().getName();
        if (tableName != null ? !tableName.equals(otherTableName) : otherTableName != null) {
            return false;
        }
        return this.proxyState.getRow$realm().getObjectKey() == other.proxyState.getRow$realm().getObjectKey();
    }

    public String toString() {
        String[] fields;
        this.proxyState.getRealm$realm().checkIfValid();
        if (!this.proxyState.getRow$realm().isValid()) {
            return "Invalid object";
        }
        String className = this.proxyState.getRow$realm().getTable().getClassName();
        StringBuilder sb = new StringBuilder(className + " = dynamic[");
        for (String field : fields = this.getFieldNames()) {
            long columnKey = this.proxyState.getRow$realm().getColumnKey(field);
            RealmFieldType type = this.proxyState.getRow$realm().getColumnType(columnKey);
            sb.append("{");
            sb.append(field).append(":");
            switch (type) {
                case BOOLEAN: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : Boolean.valueOf(this.proxyState.getRow$realm().getBoolean(columnKey)));
                    break;
                }
                case INTEGER: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : Long.valueOf(this.proxyState.getRow$realm().getLong(columnKey)));
                    break;
                }
                case FLOAT: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : Float.valueOf(this.proxyState.getRow$realm().getFloat(columnKey)));
                    break;
                }
                case DOUBLE: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : Double.valueOf(this.proxyState.getRow$realm().getDouble(columnKey)));
                    break;
                }
                case STRING: {
                    sb.append(this.proxyState.getRow$realm().getString(columnKey));
                    break;
                }
                case BINARY: {
                    sb.append(Arrays.toString(this.proxyState.getRow$realm().getBinaryByteArray(columnKey)));
                    break;
                }
                case DATE: {
                    sb.append(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : this.proxyState.getRow$realm().getDate(columnKey));
                    break;
                }
                case DECIMAL128: {
                    sb.append((Object)(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : this.proxyState.getRow$realm().getDecimal128(columnKey)));
                    break;
                }
                case OBJECT_ID: {
                    sb.append((Object)(this.proxyState.getRow$realm().isNull(columnKey) ? "null" : this.proxyState.getRow$realm().getObjectId(columnKey)));
                    break;
                }
                case OBJECT: {
                    sb.append(this.proxyState.getRow$realm().isNullLink(columnKey) ? "null" : this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey).getClassName());
                    break;
                }
                case LIST: {
                    String targetClassName = this.proxyState.getRow$realm().getTable().getLinkTarget(columnKey).getClassName();
                    sb.append(String.format(Locale.US, "RealmList<%s>[%s]", targetClassName, this.proxyState.getRow$realm().getModelList(columnKey).size()));
                    break;
                }
                case INTEGER_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Long>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case BOOLEAN_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Boolean>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case STRING_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<String>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case BINARY_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<byte[]>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case DATE_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Date>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case FLOAT_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Float>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case DOUBLE_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Double>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case DECIMAL128_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<Decimal128>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                case OBJECT_ID_LIST: {
                    sb.append(String.format(Locale.US, "RealmList<ObjectId>[%s]", this.proxyState.getRow$realm().getValueList(columnKey, type).size()));
                    break;
                }
                default: {
                    sb.append("?");
                }
            }
            sb.append("},");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        sb.append("]");
        return sb.toString();
    }

    public RealmResults<DynamicRealmObject> linkingObjects(String srcClassName, String srcFieldName) {
        DynamicRealm realm = (DynamicRealm)this.proxyState.getRealm$realm();
        realm.checkIfValid();
        this.proxyState.getRow$realm().checkIfAttached();
        RealmSchema schema = realm.getSchema();
        RealmObjectSchema realmObjectSchema = schema.get(srcClassName);
        if (realmObjectSchema == null) {
            throw new IllegalArgumentException("Class not found: " + srcClassName);
        }
        if (srcFieldName == null) {
            throw new IllegalArgumentException("Non-null 'srcFieldName' required.");
        }
        if (srcFieldName.contains(".")) {
            throw new IllegalArgumentException(MSG_LINK_QUERY_NOT_SUPPORTED);
        }
        RealmFieldType fieldType = realmObjectSchema.getFieldType(srcFieldName);
        if (fieldType != RealmFieldType.OBJECT && fieldType != RealmFieldType.LIST) {
            throw new IllegalArgumentException(String.format(Locale.US, "Unexpected field type: %1$s. Field type should be either %2$s.%3$s or %2$s.%4$s.", fieldType.name(), RealmFieldType.class.getSimpleName(), RealmFieldType.OBJECT.name(), RealmFieldType.LIST.name()));
        }
        return RealmResults.createDynamicBacklinkResults(realm, (UncheckedRow)this.proxyState.getRow$realm(), realmObjectSchema.getTable(), srcFieldName);
    }

    public DynamicRealm getDynamicRealm() {
        BaseRealm realm = this.realmGet$proxyState().getRealm$realm();
        realm.checkIfValid();
        if (!this.isValid()) {
            throw new IllegalStateException("the object is already deleted.");
        }
        return (DynamicRealm)realm;
    }

    @Override
    public void realm$injectObjectContext() {
    }

    @Override
    public ProxyState realmGet$proxyState() {
        return this.proxyState;
    }

    private void checkIsPrimaryKey(String fieldName) {
        RealmObjectSchema objectSchema = this.proxyState.getRealm$realm().getSchema().getSchemaForClass(this.getType());
        if (objectSchema.hasPrimaryKey() && objectSchema.getPrimaryKey().equals(fieldName)) {
            throw new IllegalArgumentException(String.format(Locale.US, "Primary key field '%s' cannot be changed after object was created.", fieldName));
        }
    }
}

