/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import reactor.netty.http.Cookies;
import reactor.netty.http.HttpOperations;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.http.client.HttpClientRequest;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

final class FailedHttpClientRequest
implements HttpClientRequest {
    final ContextView contextView;
    final ClientCookieDecoder cookieDecoder;
    final HttpHeaders headers;
    final boolean isWebsocket;
    final HttpMethod method;
    final String path;
    final Duration responseTimeout;
    final String uri;
    static final String[] EMPTY = new String[0];

    FailedHttpClientRequest(ContextView contextView, HttpClientConfig c) {
        this.contextView = contextView;
        this.cookieDecoder = c.cookieDecoder;
        this.headers = c.headers;
        this.isWebsocket = c.websocketClientSpec != null;
        this.method = c.method;
        this.uri = c.uri == null ? c.uriStr : c.uri.toString();
        this.path = HttpOperations.resolvePath(this.uri);
        this.responseTimeout = c.responseTimeout;
    }

    @Override
    public HttpClientRequest addCookie(Cookie cookie) {
        throw new UnsupportedOperationException("Should not add Cookie");
    }

    @Override
    public HttpClientRequest addHeader(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException("Should not add Header");
    }

    @Override
    public Map<CharSequence, Set<Cookie>> cookies() {
        return Cookies.newClientResponseHolder(this.headers, this.cookieDecoder).getCachedCookies();
    }

    @Override
    public Context currentContext() {
        return Context.of((ContextView)this.contextView);
    }

    @Override
    public ContextView currentContextView() {
        return this.contextView;
    }

    @Override
    public String fullPath() {
        return this.path;
    }

    @Override
    public HttpClientRequest header(CharSequence name, CharSequence value) {
        throw new UnsupportedOperationException("Should not add Header");
    }

    @Override
    public HttpClientRequest headers(HttpHeaders headers) {
        throw new UnsupportedOperationException("Should not add Header");
    }

    @Override
    public boolean isFollowRedirect() {
        return true;
    }

    @Override
    public boolean isKeepAlive() {
        return HttpHeaderValues.CLOSE.contentEqualsIgnoreCase((CharSequence)this.headers.get((CharSequence)HttpHeaderNames.CONNECTION));
    }

    @Override
    public boolean isWebsocket() {
        return this.isWebsocket;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String[] redirectedFrom() {
        return EMPTY;
    }

    @Override
    public HttpHeaders requestHeaders() {
        return this.headers;
    }

    @Override
    public HttpClientRequest responseTimeout(Duration timeout) {
        throw new UnsupportedOperationException("Should not add request timeout");
    }

    @Override
    public String resourceUrl() {
        return null;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_1_1;
    }
}

