/************************************************************
  *  * EaseMob CONFIDENTIAL 
  * __________________ 
  * Copyright (C) 2013-2014 EaseMob Technologies. All rights reserved. 
  *  
  * NOTICE: All information contained herein is, and remains 
  * the property of EaseMob Technologies.
  * Dissemination of this information or reproduction of this material 
  * is strictly forbidden unless prior written permission is obtained
  * from EaseMob Technologies.
  */
package com.hyphenate.chat.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMOptions;
import com.hyphenate.chat.adapter.EMACallback;
import com.hyphenate.chat.adapter.EMAChatConfig;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.util.EMLog;

import java.io.File;
import java.util.List;

/**
 * EMChatConfig 负责 初始化SDK的时候，读入应用 manifest 文件里面的相关设置。
 * <p>
 * 
 * @version 2.0
 * 
 */
public class EMChatConfigPrivate {
	
    public EMAChatConfig emaObject;

    /**
     * 运行环境模式
     */
    public enum EMEnvMode{
        /**
         * app上线前应该在测试环境下做测试,开发
         * 测试环境
         */
        EMSandboxMode,
        
        /**
         * app上线后的生产环境
         * 生产环境
         */
        EMProductMode,
        
        /**
         * 内部测试模式
         */
        EMDevMode
    }

    /**
     * SDK 模式
     * 主要用来处理长连接和短连接，一般客服模式短连接即可，否者会极大浪费后台资源
     *
     */
    public enum EMSDKMode{
    	/**
    	 * IM 聊天模式
    	 * 如果及支持IM也支持客服，也请用此模式
    	 */
    	EMChatMode,
    	
    	/**
    	 * 客服模式
    	 */
    	EMHelpDeskMode
    }

    private static final String TAG = "conf";

	/**
	 *  APPKEY
	 */
	private static final String CONFIG_EASEMOB_APPKEY = "EASEMOB_APPKEY";
	
	/**
	 *  xmpp config keys
	 */
	private static final String CONFIG_EASEMOB_CHAT_ADDRESS = "EASEMOB_CHAT_ADDRESS";
	private static final String CONFIG_EASEMOB_CHAT_DOMAIN = "EASEMOB_CHAT_DOMAIN";
	private static final String CONFIG_EASEMOB_GROUP_DOMAIN="EASEMOB_GROUP_DOMAIN";
	private static final String CONFIG_EASEMOB_CHAT_PORT = "EASEMOB_CHAT_PORT";

	/**
	 * rest server key from xml
	 */
	private static final String CONFIG_EASEMOB_API_URL = "EASEMOB_API_URL";
	
	/**
	 * keys
	 */
	static final String UUID          = "uuid";
	static final String SHARE_SERCRET = "share-secret";
	static final String TOKEN_ENTITY  = "entities";
	private String appkey             = null;

    private String chatServer;

    private int chatServerPort = -1;
    
    private String restServer;

    private String rtcServer;

    private String chatDomain;
    
    private String groupDomain;

	private EMOptions myOptions;

	private Context mContext = null;
	
	public EMChatConfigPrivate() {
	    emaObject = new EMAChatConfig();
	}
	
	/**
	 * used by internal test
	 * @return
	 */
	public static boolean isDebugTrafficMode(){
        /*
            internal flag to debug network traffic
        */
        return false;
    }

	public boolean load(Context appContext, EMOptions options){
	    File file = appContext.getFilesDir();
		String workDir = file.getAbsolutePath();
		
		mContext = appContext;
		String appPackageName = mContext.getPackageName();
		ApplicationInfo ai = null;
		try {
			ai = mContext.getPackageManager().getApplicationInfo(appPackageName, PackageManager.GET_META_DATA);
		} catch (NameNotFoundException e) {
			EMLog.e(TAG, e.getMessage());
			EMLog.e(TAG,"找不到ApplicationInfo");
		}
		
        appkey = (options != null && !TextUtils.isEmpty(options.getAppKey()))?options.getAppKey():null;
        
		do{
			if(ai != null){
				Bundle metaData = ai.metaData;
				if(metaData == null){
					EMLog.w(TAG,"请确认meta属性写在清单文件里的application节点以内");
					
					break;
				}
				
				// read appkey
				String appKeyFromConfig = metaData.getString(CONFIG_EASEMOB_APPKEY);
				
                if (appKeyFromConfig == null && appkey == null) {
                    Log.e(TAG, "EASEMOB_APPKEY is not set in AndroidManifest file");
                    System.exit(-1);
				} else if(TextUtils.isEmpty(appkey)){
					appkey = appKeyFromConfig;
				}
				
				//set im server
				String chatServerFromConfig = metaData.getString(CONFIG_EASEMOB_CHAT_ADDRESS);
				if (chatServerFromConfig != null) {
				    chatServer = chatServerFromConfig;
				}
				
				//set im server
                int chatServerPortFromConfig = metaData.getInt(CONFIG_EASEMOB_CHAT_PORT, -1);
                if (chatServerPortFromConfig != -1) {
                    chatServerPort = chatServerPortFromConfig;
                }
				
				//set rest server
				String UserServerFromConfig = metaData.getString(CONFIG_EASEMOB_API_URL);
				if (UserServerFromConfig != null) {
					restServer = UserServerFromConfig;
				}
				
		        String chatDomainFromConfig = metaData.getString(CONFIG_EASEMOB_CHAT_DOMAIN);
                if (chatDomainFromConfig != null) {
                    chatDomain = chatDomainFromConfig;
                }
                
                String groupDomainFromConfig = metaData.getString(CONFIG_EASEMOB_GROUP_DOMAIN);
                if (groupDomainFromConfig != null) {
                    groupDomain = groupDomainFromConfig;
                }


				
			}
		}while(false);

        emaObject.init(workDir, workDir, appkey);

        // set options passed by app
        // set options before load advance debug config
        setOption(options);

        updatePath(appkey);
        
		EMLog.i(TAG, "EASEMOB_APPKEY is set to:" + appkey);
		
		if(chatServer != null && !chatServer.equals("")){
			emaObject.setChatServer(chatServer);
		}
		
		if(restServer != null && !restServer.equals("")){
			emaObject.setRestServer(restServer);
		}

        if(rtcServer != null && !rtcServer.equals("")){
            emaObject.setRtcServer(rtcServer);
        }

		if (chatDomain != null && !chatDomain.equals("")) {
		    emaObject.setChatDomain(chatDomain);
		}

		if (groupDomain != null && !groupDomain.equals("")) {
		    emaObject.setGroupDomain(groupDomain);
		}
		
		if (chatServerPort != -1) {
		    emaObject.setChatPort(chatServerPort);
		}

        if(hasServerChanged){
            emaObject.enableDnsConfig(false);
        }

		emaObject.setSDKVersion(EMClient.VERSION);
        try {
            emaObject.setOSVersion(Build.VERSION.RELEASE);
        } catch (Exception e) {
            EMLog.e(TAG, e.getMessage());
        }

        emaObject.setAppId(appContext.getPackageName());
		
		printConfig();
		return true;
	}
	

	public void updatePath(String appkey)
	{
        if (mContext == null)
            return;

        File file = mContext.getFilesDir();
        String workDir = file.getAbsolutePath();
        String logPath = workDir;
        String downloadPath = workDir;

        // May null if storage is not currently available.
        // Can use Environment.getExternalStorageState() to check.
        File extDir = mContext.getExternalFilesDir(null);

        if (extDir != null && extDir.exists() && extDir.canWrite()) {
            String path = extDir.getAbsolutePath();
            EMLog.e(TAG, "path: " + path);
            int pos = path.indexOf("/files");
            String basePath;
            if (pos == -1) {
                basePath = path;
            } else {
                basePath = path.substring(0, pos);
            }
            logPath = basePath + "/" + appkey + "/core_log";
            downloadPath = basePath + "/" + appkey + "/files";

            new File(logPath).mkdirs();
            new File(downloadPath).mkdirs();
        }

        emaObject.setLogPath(logPath);
        emaObject.setDownloadPath(downloadPath);
	}

	
	boolean hasServerChanged = false;

	private void setOption(EMOptions options) {
		myOptions = options;
		
		emaObject.setRequireReadAck(options.getRequireAck());
		emaObject.setRequireDeliveryAck(options.getRequireDeliveryAck());
        //noinspection deprecation
		emaObject.setAutoAccept(options.getAcceptInvitationAlways());
		emaObject.setDeleteMessageAsExitGroup(options.isDeleteMessagesAsExitGroup());
		emaObject.setIsChatroomOwnerLeaveAllowed(options.isChatroomOwnerLeaveAllowed());
		emaObject.setDeleteMessageAsExitChatRoom(options.isDeleteMessagesAsExitChatRoom());
        emaObject.setAutoAcceptGroupInvitation(options.isAutoAcceptGroupInvitation());
        emaObject.enableDnsConfig(options.getEnableDNSConfig());
        emaObject.setSortMessageByServerTime(options.isSortMessageByServerTime());
        emaObject.setUsingHttpsOnly(options.getUsingHttpsOnly());
        emaObject.setTransferAttachments(options.getAutoTransferMessageAttachments());
        emaObject.setAutodownloadThumbnail(options.getAutodownloadThumbnail());
        if (options.getDnsUrl() != null && !options.getDnsUrl().isEmpty()) {
            emaObject.setDnsUrl(options.getDnsUrl());
        }
        if(options.getRestServer() != null && options.getImServer() != null){
            emaObject.enableDnsConfig(false);
            restServer = options.getRestServer();
            chatServer = options.getImServer();
            if(options.getImPort() > 0){
                chatServerPort = options.getImPort();
            }
        }
        emaObject.setAreaCode(options.getAreaCode());
        emaObject.setEnableStatistics(options.isEnableStatistics());
        if(options.getCustomOSPlatform() != -1) {
            emaObject.setCustomOSPlatform(options.getCustomOSPlatform());
        }
        emaObject.setDeviceName(options.getCustomDeviceName());
        emaObject.setLoginCustomExt(options.getLoginCustomExt());
        emaObject.setLoadEmptyConversations(options.isLoadEmptyConversations());
        emaObject.setUseReplacedMessageContents(options.isUseReplacedMessageContents());
        emaObject.setCallbackSendMessageInMessageListener(options.isIncludeSendMessageInMessageListener());
        emaObject.setRegardImportedMsgAsRead(options.regardImportedMsgAsRead());
        emaObject.setEnableTLSConnection(options.isEnableTLSConnection());
        emaObject.setAutoConversationLoaded(options.isAutoLoadAllConversations());
	}
	
	public EMOptions getOptions() {
		return myOptions;
	}

	private void printConfig() {
		EMLog.d(TAG, " APPKEY:" + appkey + " CHATSERVER:" + emaObject.getChatAddress());
		// EMLog.d(TAG, "PUSHSERVER:" + PUSHSERVER);
		EMLog.d(TAG, "STORAGE_URL:" + emaObject.getRestServer());
		EMLog.d(TAG, "RTCSERVER: " + rtcServer);
	}
	
    void setSDKMode(EMSDKMode mode){
    	
    }
    
    EMSDKMode getSDKMode(){
    	return EMSDKMode.EMChatMode;
    }

	EMEnvMode getEnvMode(){
		boolean sandboxMode = emaObject.getIsSandboxMode();
	    return sandboxMode ? EMEnvMode.EMSandboxMode : EMEnvMode.EMProductMode;
	}
	
	public String getVersion() {
		return EMClient.VERSION;
	}
	

    //========================== new add api
	public void importGroup(String id, int style, String owner, String subject, String description, List<String> allMembers, boolean isBlocked, int maxUsers) {
	    emaObject.importGroup(id, style, owner, subject, description, allMembers, isBlocked, maxUsers);
	}

	public void importChatRoom(String username, String ownerName, String subject, String description, List<String> members, int maxUsers) {
	    emaObject.importChatRoom(username, ownerName, subject, description, members, maxUsers);
	}
	
	public void importConversation(String convId, int type, String ext) {
	    emaObject.importConversation(convId, type, ext);
	}
	
	public void importBlackList(List<String> blacklist) {
	    emaObject.importBlackList(blacklist);
	}
	
	public void importContacts(List<String> contacts) {
	    emaObject.importContacts(contacts);
	}
    
    public boolean openDatabase(String username) {
        return emaObject.openDatabase(username);
    }
    
    public void importMessages(List<EMAMessage> messages) {
        emaObject.importMessages(messages);
    }
    
    public String getBaseUrl(boolean withAppkey, boolean nextHost) {
        return emaObject.getBaseUrl(withAppkey, nextHost);
    }
    
    public boolean useHttps() {
        return emaObject.useHttps();
    }
    
    public void retrieveDNSConfig() {
        emaObject.retrieveDNSConfig();
    }
    
    public boolean isEnableDnsConfig() {
        return emaObject.isEnableDnsConfig();       
    }
    
    public void enableDnsConfig(boolean enable) {
        emaObject.enableDnsConfig(enable);
    }
    
    public boolean isGcmEnabled(){
        return emaObject.isGcmEnabled();
    }
    
    public void setChatServer(String address) {
        emaObject.setChatServer(address);
    }
    
    public void setChatPort(int port) {
        emaObject.setChatPort(port);
    }
    
    public void setRestServer(String address) {
        emaObject.setRestServer(address);
    }

    public String getRestServer() {
        return emaObject.getRestServer();
    }
    
    public String getAppKey() {
        return emaObject.getAppKey();
    }
    
    public String getNextAvailableBaseUrl() {
        return emaObject.getNextAvailableBaseUrl();
    }
    
    public String getAccessToken() {
        return emaObject.getAccessToken();
    }
    
    public String getAccessToken(boolean getFromServer) {
        return emaObject.getAccessToken(getFromServer);
    }
    
    public long getTokenSaveTime() {
        return emaObject.getTokenSaveTime();
    }
    
    public void setDebugMode(boolean debugMode) {
        emaObject.setDebugMode(debugMode);
    }
    
    public void setRequireDeliveryAck(boolean b) {
        emaObject.setRequireDeliveryAck(b);
    }

    public boolean getRequireDeliveryAck() {
        return emaObject.getRequireDeliveryAck();
    }

    public void setRequireReadAck(boolean b) {
        emaObject.setRequireReadAck(b);
    }
    
    public boolean getRequireReadAck() {
        return emaObject.getRequireReadAck();
    }

    public void setAutoAccept(boolean b) {
        emaObject.setAutoAccept(b);
    }
    
    public boolean getAutoAccept() {
        return emaObject.getAutoAccept();
    }

    public void setDeleteMessageAsExitGroup(boolean delete) {
        emaObject.setDeleteMessageAsExitGroup(delete);
    }
    
    public boolean getDeleteMessageAsExitGroup() {
        return emaObject.getDeleteMessageAsExitGroup();
    }
    
    public void setAutoAcceptGroupInvitation(boolean value) {
        emaObject.setAutoAcceptGroupInvitation(value);
    }
    
    public boolean isAutoAcceptGroupInvitation() {
        return emaObject.getAutoAcceptGroupInvitation();
    }
    
    public void setIsChatroomOwnerLeaveAllowed(boolean allowLeave) {
        emaObject.setIsChatroomOwnerLeaveAllowed(allowLeave);
    }
    
    public boolean getIsChatroomOwnerLeaveAllowed() {
        return emaObject.getIsChatroomOwnerLeaveAllowed();
    }

    public void setDeleteMessageAsExitChatRoom(boolean delete) {
        emaObject.setDeleteMessageAsExitChatRoom(delete);
    }

    public boolean getDeleteMessageAsExitChatRoom() {
        return emaObject.getDeleteMessageAsExitChatRoom();
    }

    public void uploadLog(EMCallBack callback) {
    	EMACallback cb = new EMACallback(callback);
    	
        emaObject.uploadLog(cb);
    }
    
    public void updateConversationUnreadCount(String conversationId, int count) {
        emaObject.updateConversationUnreadCount(conversationId, count);
    }
    
    public void reloadAll() {
        emaObject.reloadAll();
    }
    
    public boolean getSortMessageByServerTime() {
        return emaObject.getSortMessageByServerTime();
    }
    
    public void setSortMessageByServerTime(boolean sortByServerTime) {
        emaObject.setSortMessageByServerTime(sortByServerTime);
    }

    public String getGaoDeDiscoverKey() {
        return emaObject.getGaoDeDiscoverKey();
    }

    public String getGaoDeLocationKey() {
        return emaObject.getGaoDeLocationKey();
    }
    
    public void setUseHttps(boolean useHttps) {
        emaObject.setUseHttps(useHttps);
    }

    public void setUsingHttpsOnly(boolean usingHttpsOnly) {
        emaObject.setUsingHttpsOnly(usingHttpsOnly);
    }

    public boolean getUsingHttpsOnly() {
        return emaObject.getUsingHttpsOnly();
    }

    public void setAutoTransferMessageAttachments(boolean serverTransfer) {
        emaObject.setTransferAttachments(serverTransfer);
    }
    public boolean getAutoTransferMessageAttachments() {
        return emaObject.getTransferAttachments();
    }

    public void setAutodownloadThumbnail(boolean autodownload) {
        emaObject.setAutodownloadThumbnail(autodownload);
    }
    public boolean getAutodownloadThumbnail() {
        return emaObject.getAutodownloadThumbnail();
    }

    public void setUseRtcConfig(boolean useRtcConfig) {
        emaObject.setUseRtcConfig(useRtcConfig);
    }
    public boolean getUseRtcConfig() {
        return emaObject.getUseRtcConfig();
    }

    public void setRtcConfigUrl(String rtcConfigUrl) {
        emaObject.setRtcConfigUrl(rtcConfigUrl);
    }
    public String getRtcConfigUrl() { return emaObject.getRtcConfigUrl(); }

    public String getDownloadPath() {
        return emaObject.getDownloadPath();
    }

    public void setDeviceUuid(String uuid) {
        emaObject.setDeviceUuid(uuid);
    }
    public void setDid(String did) {
        emaObject.setDid(did);
    }

    public void setAreaCode(int code) {
	    emaObject.setAreaCode(code);
    }

    public void setServiceId(String serviceId) {
        emaObject.setServiceId(serviceId);
    }

    public void setDeviceName(String deviceName) {
        emaObject.setDeviceName(deviceName);
    }

    public String getDeviceName() {
        return emaObject.getDeviceName();
    }

    public void setLoginInfoCustomExt(String ext) {
        emaObject.setLoginCustomExt(ext);
    }

    public String getLoginInfoCustomExt() {
        return emaObject.getLoginInfoCustomExt();
    }

    public void setDnsUrl(String dnsUrl) {
        emaObject.setDnsUrl(dnsUrl);
    }

    public String getDnsUrl() {
        return emaObject.getDnsUrl();
    }

    public boolean getUsingSQLCipher() { return emaObject.getUsingSQLCipher(); }

    public boolean isNewLoginOnDevice() {return  emaObject.isNewLoginOnDevice(); }

    public boolean isEnableStatistics() {
        return emaObject.isEnableStatistics();
    }

    public void setEnableStatistics(boolean enable) {
        emaObject.setEnableStatistics(enable);
    }

    public void setCustomOSPlatform(int platform) {
        emaObject.setCustomOSPlatform(platform);
    }

    public int getCustomOSPlatform() {
        return  emaObject.getCustomOSPlatform();
    }
    public boolean isLoadEmptyConversations() {
        return emaObject.isLoadEmptyConversations();
    }
    public void setLoadEmptyConversations(boolean isLoadEmptyConversations) {
        emaObject.setLoadEmptyConversations(isLoadEmptyConversations);
    }

    public boolean isUseReplacedMessageContents() {
        return emaObject.isUseReplacedMessageContents();

    }

    public void setUseReplacedMessageContents(boolean useReplacedMessageContents) {
        emaObject.setUseReplacedMessageContents(useReplacedMessageContents);
    }

    public boolean isCallbackSendMessageInMessageListener() {
        return emaObject.isCallbackSendMessageInMessageListener();
    }

    public void setCallbackSendMessageInMessageListener(boolean whetherCallback) {
        emaObject.setCallbackSendMessageInMessageListener(whetherCallback);
    }
    public boolean regardImportedMsgAsRead() {return emaObject.regardImportedMsgAsRead(); }
    public void  setRegardImportedMsgAsRead(boolean regardImportedMsgAsRead) {
        emaObject.setRegardImportedMsgAsRead(regardImportedMsgAsRead);
    }

    public void setEnableTLSConnection(boolean enableTLSConnection) {
        emaObject.setEnableTLSConnection(enableTLSConnection);
    }

    public boolean isEnableTLSConnection() {
        return emaObject.isEnableTLSConnection();
    }

    public void setAutoLoadAllConversations(boolean autoLoadAllConversations) {
        emaObject.setAutoConversationLoaded(autoLoadAllConversations);
    }

    public boolean isAutoLoadAllConversations() {
        return emaObject.getAutoConversationLoaded();
    }
}

