/*
 * Decompiled with CFR 0.152.
 */
package internal.com.getkeepsafe.relinker;

import android.content.Context;
import android.util.Log;
import internal.com.getkeepsafe.relinker.ApkLibraryInstaller;
import internal.com.getkeepsafe.relinker.MissingLibraryException;
import internal.com.getkeepsafe.relinker.ReLinker;
import internal.com.getkeepsafe.relinker.SystemLibraryLoader;
import internal.com.getkeepsafe.relinker.TextUtils;
import internal.com.getkeepsafe.relinker.elf.ElfParser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ReLinkerInstance {
    private static final String LIB_DIR = "lib";
    protected final Set<String> loadedLibraries;
    protected final ReLinker.LibraryLoader libraryLoader;
    protected final ReLinker.LibraryInstaller libraryInstaller;
    protected boolean force;
    protected boolean recursive;
    protected ReLinker.Logger logger;

    protected ReLinkerInstance() {
        ApkLibraryInstaller apkLibraryInstaller;
        SystemLibraryLoader systemLibraryLoader;
        ReLinkerInstance reLinkerInstance = this_;
        SystemLibraryLoader this_ = systemLibraryLoader;
        systemLibraryLoader = new SystemLibraryLoader();
        ApkLibraryInstaller apkLibraryInstaller2 = apkLibraryInstaller;
        apkLibraryInstaller = new ApkLibraryInstaller();
        reLinkerInstance(this_, apkLibraryInstaller2);
    }

    /*
     * WARNING - void declaration
     */
    protected ReLinkerInstance(ReLinker.LibraryLoader libraryLoader, ReLinker.LibraryInstaller libraryInstaller) {
        HashSet<String> hashSet;
        HashSet<String> hashSet2 = hashSet;
        hashSet = new HashSet<String>();
        this.loadedLibraries = hashSet2;
        if (libraryLoader != null) {
            void var2_2;
            if (var2_2 != null) {
                void var1_1;
                ReLinkerInstance reLinkerInstance = this;
                reLinkerInstance.libraryLoader = var1_1;
                reLinkerInstance.libraryInstaller = var2_2;
                return;
            }
            throw new IllegalArgumentException("Cannot pass null library installer");
        }
        throw new IllegalArgumentException("Cannot pass null library loader");
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     */
    private void loadLibraryInternal(Context context, String library, String version) {
        void var3_6;
        Object[] objectArray;
        Object[] this_;
        void var2_5;
        if (this_.loadedLibraries.contains(var2_5) && !this_.force) {
            Object[] objectArray2 = this_;
            Object[] objectArray3 = new Object[1];
            this_ = objectArray3;
            objectArray3[0] = var2_5;
            objectArray2.log("%s already loaded previously!", this_);
            return;
        }
        try {
            Object[] objectArray4 = this_;
            objectArray = this_;
            objectArray4.libraryLoader.loadLibrary((String)var2_5);
            objectArray4.loadedLibraries.add((String)var2_5);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Object object;
            block19: {
                Object object2;
                block20: {
                    ElfParser elfParser;
                    void var1_1;
                    Object[] objectArray5 = new Object[1];
                    object2 = objectArray5;
                    objectArray5[0] = Log.getStackTraceString((Throwable)unsatisfiedLinkError);
                    this_.log("Loading the library normally failed: %s", (Object[])object2);
                    Object[] objectArray6 = new Object[2];
                    object = objectArray6;
                    objectArray6[0] = var2_5;
                    objectArray6[1] = var3_6;
                    this_.log("%s (%s) was not loaded normally, re-linking...", (Object[])object);
                    object = this_.getWorkaroundLibFile((Context)var1_1, (String)var2_5, (String)var3_6);
                    if (!((File)object).exists() || this_.force) {
                        if (this_.force) {
                            Object[] objectArray7 = new Object[2];
                            object2 = objectArray7;
                            objectArray7[0] = var2_5;
                            objectArray7[1] = var3_6;
                            this_.log("Forcing a re-link of %s (%s)...", (Object[])object2);
                        }
                        this_.cleanupOldLibFiles((Context)var1_1, (String)var2_5, (String)var3_6);
                        object2 = this_.libraryLoader.supportedAbis();
                        this_.libraryInstaller.installLibrary((Context)var1_1, (String[])object2, this_.libraryLoader.mapLibraryName((String)var2_5), (File)object, (ReLinkerInstance)this_);
                    }
                    if (!this_.recursive) break block19;
                    object2 = null;
                    Object object32222222 = elfParser;
                    elfParser = new ElfParser((File)object);
                    List<String> list = elfParser.parseNeededDependencies();
                    ((ElfParser)object32222222).close();
                    object2 = list.iterator();
                    while (true) {
                        if (!object2.hasNext()) break block19;
                        Object[] objectArray8 = this_;
                        void v10 = var1_1;
                        Object[] objectArray9 = this_;
                        object32222222 = (String)object2.next();
                        objectArray8.loadLibrary((Context)v10, objectArray9.libraryLoader.unmapLibraryName((String)object32222222));
                        continue;
                        break;
                    }
                    catch (Throwable throwable) {
                        object2 = object32222222;
                        break block20;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                try {
                    void var1_4;
                    ((ElfParser)object2).close();
                    throw var1_4;
                }
                catch (IOException iOException) {}
            }
            Object[] objectArray10 = this_;
            objectArray10.libraryLoader.loadPath(((File)object).getAbsolutePath());
            objectArray10.loadedLibraries.add((String)var2_5);
            Object[] objectArray11 = new Object[2];
            this_ = objectArray11;
            objectArray11[0] = var2_5;
            objectArray11[1] = var3_6;
            this_.log("%s (%s) was re-linked!", this_);
            return;
        }
        objectArray.log("%s (%s) was loaded normally!", var2_5, var3_6);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(ReLinkerInstance x0, Context x1, String x2, String x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        x0.loadLibraryInternal((Context)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public ReLinkerInstance log(ReLinker.Logger logger) {
        void var1_1;
        this.logger = var1_1;
        return this;
    }

    public ReLinkerInstance force() {
        this.force = true;
        return this;
    }

    public ReLinkerInstance recursively() {
        this.recursive = true;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void loadLibrary(Context context, String library) {
        void var2_2;
        void var1_1;
        this.loadLibrary((Context)var1_1, (String)var2_2, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void loadLibrary(Context context, String library, String version) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.loadLibrary((Context)var1_1, (String)var2_2, (String)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    public void loadLibrary(Context context, String library, ReLinker.LoadListener listener) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.loadLibrary((Context)var1_1, (String)var2_2, null, (ReLinker.LoadListener)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void loadLibrary(Context context, String library, String version, ReLinker.LoadListener listener) {
        if (context != null) {
            void var2_2;
            if (!TextUtils.isEmpty((CharSequence)var2_2)) {
                void var3_3;
                void var1_1;
                void var4_4;
                Object[] objectArray = new Object[1];
                Object object = objectArray;
                objectArray[0] = var2_2;
                this.log("Beginning load of %s...", object);
                if (var4_4 == null) {
                    this.loadLibraryInternal((Context)var1_1, (String)var2_2, (String)var3_3);
                } else {
                    Runnable runnable;
                    object = runnable;
                    runnable = new Runnable(this, (Context)var1_1, (String)var2_2, (String)var3_3, (ReLinker.LoadListener)var4_4){
                        final /* synthetic */ Context val$context;
                        final /* synthetic */ String val$library;
                        final /* synthetic */ String val$version;
                        final /* synthetic */ ReLinker.LoadListener val$listener;
                        final /* synthetic */ ReLinkerInstance this$0;
                        {
                            void var1_1;
                            this.this$0 = var1_1;
                            this.val$context = context;
                            this.val$library = string;
                            this.val$version = string2;
                            this.val$listener = loadListener;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public void run() {
                            block6: {
                                void var1_4;
                                1 v0 = this;
                                1 v1 = v0;
                                ReLinkerInstance reLinkerInstance = v0.this$0;
                                1 v3 = this;
                                1 v4 = v3;
                                1 v5 = v3;
                                Context context = v3.val$context;
                                String string = v5.val$library;
                                String string2 = v4.val$version;
                                try {
                                    ReLinkerInstance.access$000(reLinkerInstance, context, string, string2);
                                    v1.val$listener.success();
                                    break block6;
                                }
                                catch (MissingLibraryException missingLibraryException) {
                                }
                                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                    // empty catch block
                                }
                                this.val$listener.failure((Throwable)var1_4);
                            }
                        }
                    };
                    new Thread((Runnable)object).start();
                }
                return;
            }
            throw new IllegalArgumentException("Given library is either null or empty");
        }
        throw new IllegalArgumentException("Given context is null");
    }

    protected File getWorkaroundLibDir(Context context) {
        return context.getDir(LIB_DIR, 0);
    }

    /*
     * WARNING - void declaration
     */
    protected File getWorkaroundLibFile(Context context, String library, String version) {
        void var3_3;
        void var1_1;
        String string;
        string = this.libraryLoader.mapLibraryName(string);
        if (TextUtils.isEmpty(version)) {
            return new File(this.getWorkaroundLibDir((Context)var1_1), string);
        }
        return new File(this.getWorkaroundLibDir((Context)var1_1), string + "." + (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    protected void cleanupOldLibFiles(Context context, String library, String currentVersion) {
        void var3_3;
        File[] fileArray;
        File file;
        File file2 = this.getWorkaroundLibDir((Context)file);
        ReLinkerInstance reLinkerInstance = this;
        file = reLinkerInstance.getWorkaroundLibFile((Context)file, (String)fileArray, (String)var3_3);
        fileArray = reLinkerInstance.libraryLoader.mapLibraryName((String)fileArray);
        if ((fileArray = file2.listFiles(new FilenameFilter(this, (String)fileArray){
            final /* synthetic */ String val$mappedLibraryName;
            final /* synthetic */ ReLinkerInstance this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$mappedLibraryName = string;
            }

            @Override
            public boolean accept(File dir, String filename) {
                return filename.startsWith(this.val$mappedLibraryName);
            }
        })) == null) {
            return;
        }
        for (File file3 : fileArray) {
            if (!this.force && file3.getAbsolutePath().equals(file.getAbsolutePath())) continue;
            file3.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void log(String format, Object ... args) {
        void var2_2;
        void var1_1;
        this.log(String.format(Locale.US, (String)var1_1, (Object[])var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void log(String message) {
        ReLinker.Logger this_ = ((ReLinkerInstance)((Object)this_)).logger;
        if (this_ != null) {
            void var1_1;
            this_.log((String)var1_1);
        }
    }
}

