/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.util;

import android.annotation.SuppressLint;
import com.hyphenate.util.TimeInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    private static final long INTERVAL_IN_MILLISECONDS = 30000L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getTimestampString(Date messageDate) {
        Date date;
        String string;
        boolean bl = Locale.getDefault().getLanguage().startsWith("zh");
        long l = messageDate.getTime();
        if (DateUtils.isSameDay(l)) {
            string = bl ? "aa hh:mm" : "hh:mm aa";
        } else if (DateUtils.isYesterday(l)) {
            if (!bl) return "Yesterday " + new SimpleDateFormat("hh:mm aa", Locale.ENGLISH).format(date);
            string = "\u6628\u5929aa hh:mm";
        } else {
            string = bl ? "M\u6708d\u65e5aa hh:mm" : "MMM dd hh:mm aa";
        }
        if (!bl) return new SimpleDateFormat(string, Locale.ENGLISH).format(date);
        return new SimpleDateFormat(string, Locale.CHINESE).format(date);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isCloseEnough(long time1, long time2) {
        void var2_1;
        long l = time1 - var2_1;
        if (l < 0L) {
            l = -l;
        }
        return l < 30000L;
    }

    private static boolean isSameDay(long inputTime) {
        long l;
        TimeInfo timeInfo = DateUtils.getTodayStartAndEndTime();
        return inputTime > timeInfo.getStartTime() && l < timeInfo.getEndTime();
    }

    private static boolean isYesterday(long inputTime) {
        long l;
        TimeInfo timeInfo = DateUtils.getYesterdayStartAndEndTime();
        return inputTime > timeInfo.getStartTime() && l < timeInfo.getEndTime();
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static Date StringToDate(String dateStr, String formatStr) {
        Date date;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)((Object)date));
        date = null;
        try {
            String string;
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        return date;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toTime(int timeLength) {
        int n = timeLength / 1000;
        int n2 = n / 60;
        if (n2 >= 60) {
            int n3 = n2;
            int cfr_ignored_0 = n3 / 60;
            n2 = n3 % 60;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n2;
        objectArray[1] = n %= 60;
        return String.format("%02d:%02d", objectArray2);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toTimeBySecond(int timeLength) {
        int n = timeLength / 60;
        if (n >= 60) {
            int n2 = n;
            int cfr_ignored_0 = n2 / 60;
            n = n2 % 60;
        }
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n;
        objectArray[1] = var0 %= 60;
        return String.format("%02d:%02d", objectArray2);
    }

    public static TimeInfo getYesterdayStartAndEndTime() {
        TimeInfo timeInfo;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, -1);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        long l2 = calendar2.getTime().getTime();
        TimeInfo timeInfo2 = timeInfo;
        timeInfo2();
        timeInfo2.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static TimeInfo getTodayStartAndEndTime() {
        TimeInfo timeInfo;
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        long l2 = calendar2.getTime().getTime();
        TimeInfo timeInfo2 = timeInfo;
        timeInfo2();
        timeInfo2.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static TimeInfo getBeforeYesterdayStartAndEndTime() {
        TimeInfo timeInfo;
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, -2);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        long l2 = calendar2.getTime().getTime();
        TimeInfo timeInfo2 = timeInfo;
        timeInfo2();
        timeInfo2.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static TimeInfo getCurrentMonthStartAndEndTime() {
        TimeInfo timeInfo;
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        long l2 = Calendar.getInstance().getTime().getTime();
        TimeInfo timeInfo2 = timeInfo;
        timeInfo2();
        timeInfo2.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static TimeInfo getLastMonthStartAndEndTime() {
        TimeInfo timeInfo;
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -1);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long l = calendar.getTime().getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, -1);
        calendar2.set(5, 1);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        calendar2.roll(5, -1);
        long l2 = calendar2.getTime().getTime();
        TimeInfo timeInfo2 = timeInfo;
        timeInfo2();
        timeInfo2.setStartTime(l);
        timeInfo.setEndTime(l2);
        return timeInfo;
    }

    public static String getTimestampStr() {
        return Long.toString(System.currentTimeMillis());
    }
}

