/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.chat;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.PowerManager;
import com.hyphenate.EMConnectionListener;
import com.hyphenate.EMMessageListener;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMCollector;
import com.hyphenate.chat.EMGroupReadAck;
import com.hyphenate.chat.EMHeartBeatReceiver;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.adapter.EMAChatClient;
import com.hyphenate.chat.adapter.EMAHeartBeatCustomizedParams;
import com.hyphenate.monitor.a;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.NetUtils;
import com.hyphenate.util.Utils;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class EMSmartHeartBeat {
    private static final String TAG = "smart ping";
    static boolean Debug = false;
    private static final int PING_PONG_TIMEOUT = 8000;
    private static final int GCM_DISCONNECT_CHECK_INTERVAL = 180000;
    private int fixedInterval = -1;
    boolean useCustomizedParams = false;
    EMAHeartBeatCustomizedParams mCustomizedWifiParams = null;
    EMAHeartBeatCustomizedParams mCustomizedMobileParams = null;
    private Context mContext;
    private int succeededInterval;
    private int currentInterval;
    private boolean dataReceivedDuringInterval = false;
    IParams params;
    private EMHeartBeatReceiver alarmIntentReceiver = null;
    private PendingIntent alarmIntent = null;
    private EMConnectionListener cnnListener = null;
    private EMMessageListener messageListener = null;
    private PowerManager.WakeLock wakeLock;
    private Object stateLock = new Object();
    private boolean inited = false;
    private boolean prevWifi = false;
    private Timer disconnectTimer = null;
    private TimerTask disconnectTask = null;
    private AlarmManager alarmManager;
    private boolean isInBackground = false;
    private EMSmartPingState pingState = EMSmartPingState.EMReady;
    ExecutorService threadPool;
    private Runnable heartBeatRunnable = new Runnable(this){
        final /* synthetic */ EMSmartHeartBeat this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            EMLog.d(EMSmartHeartBeat.TAG, "has network connection:" + NetUtils.hasNetwork(this.this$0.mContext) + " has data conn:" + NetUtils.hasDataConnection(this.this$0.mContext) + " isConnected to hyphenate server : " + EMClient.getInstance().isConnected());
            if (this.this$0.hasDataConnection()) {
                try {
                    this.this$0.wakeLock.acquire();
                }
                catch (Exception exception) {
                    EMLog.e(EMSmartHeartBeat.TAG, exception.getMessage());
                }
                5 v1 = this;
                EMLog.d(EMSmartHeartBeat.TAG, "acquire wake lock");
                v1.this$0.checkPingPong();
                v1.this$0.releaseWakelock();
            } else {
                EMLog.d(EMSmartHeartBeat.TAG, "....no connection to server");
                if (!NetUtils.hasDataConnection(this.this$0.mContext) && EMClient.getInstance().isConnected()) {
                    if (Utils.isSdk14()) {
                        EMLog.d(EMSmartHeartBeat.TAG, "no data connection but im connection is connected, reconnect");
                        EMClient.getInstance().onNetworkChanged(EMAChatClient.EMANetwork.NETWORK_NONE);
                    } else {
                        EMClient.getInstance().forceReconnect();
                    }
                }
            }
            a.a();
            this.this$0.scheduleNextAlarm();
        }
    };

    /*
     * WARNING - void declaration
     */
    private EMSmartHeartBeat(Context context) {
        void var1_1;
        this.mContext = var1_1;
    }

    public static EMSmartHeartBeat create(Context context) {
        Context context2;
        return new EMSmartHeartBeat(context2);
    }

    private TimerTask getTask() {
        return new TimerTask(this){
            final /* synthetic */ EMSmartHeartBeat this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void run() {
                EMLog.d(EMSmartHeartBeat.TAG, "enter the disconnect task");
                if (EMClient.getInstance().isConnected()) {
                    EMClient.getInstance().disconnect();
                }
                try {
                    4 v0 = this;
                    v0.this$0.alarmManager.cancel(this.this$0.alarmIntent);
                    v0.this$0.mContext.unregisterReceiver((BroadcastReceiver)this.this$0.alarmIntentReceiver);
                    EMSmartHeartBeat.access$1002(v0.this$0, null);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    private void checkPingPong() {
        EMLog.d("smart ping", "check pingpong ...");
        var1_1 = false;
        var2_3 = 3;
        for (var3_5 = 0; var3_5 < var2_3; ++var3_5) {
            block16: {
                v0 = this;
                Thread.sleep(1000L);
                try {
                    if (!v0.dataReceivedDuringInterval) break block16;
                    return;
                }
                catch (Exception v1) {
                    return;
                }
            }
            var1_1 = this.sendPingPong();
            if (!var1_1) continue;
            v2 = this;
            v3 = v2;
            v4 = v2;
            v5 = v2;
            v6 = "smart ping";
            v7 = new StringBuilder().append("success to send ping pong ... with current heartbeat interval : ");
            v8 = this.currentInterval;
            EMLog.d(v6, v7.append(EMCollector.timeToString(v8)).toString());
            v5.succeededInterval = v4.currentInterval;
            EMLog.d("smart ping", "send ping-pong successes");
            var2_4 = EMSmartPingState.EMHitted;
            if (v3.pingState != var2_4) ** GOTO lbl34
            EMLog.d("smart ping", "that's already in the EMHitted state, just return...");
            return;
lbl34:
            // 1 sources

            if (this.succeededInterval == this.params.getMaxInterval()) ** GOTO lbl40
            if (this.pingState == EMSmartPingState.EMReevaluating) ** GOTO lbl40
            this.currentInterval = this.params.getNextInterval(this.currentInterval, true);
            break;
lbl40:
            // 2 sources

            if (this.succeededInterval != this.params.getMaxInterval()) ** GOTO lbl43
            EMLog.d("smart ping", "Find the best interval, interval is the max interval");
lbl43:
            // 2 sources

            if (this.pingState != EMSmartPingState.EMReevaluating) ** GOTO lbl46
            EMLog.d("smart ping", "success to pingping and current state is EMSmartPingState.EMReevaluating, so use current interval as final interval");
lbl46:
            // 2 sources

            EMLog.d("smart ping", "enter the ping state : " + (Object)this.pingState);
            this.changeState(var2_4);
            return;
            catch (InterruptedException v9) {
                EMLog.e("smart ping", "heartbeat thread be interrupt");
                Thread.currentThread().interrupt();
                return;
            }
        }
        if (!var1_1) {
            EMLog.d("smart ping", "failed to send ping pong ... with current heartbeat interval : " + EMCollector.timeToString(this.currentInterval));
            if (this.hasDataConnection()) {
                EMLog.d("smart ping", "failed to send ping pong ... with current heartbeat interval : " + EMCollector.timeToString(this.currentInterval));
                var1_2 = this.pingState;
                if (var1_2 == EMSmartPingState.EMEvaluating || var1_2 == EMSmartPingState.EMHitted) {
                    EMLog.d("smart ping", "send ping-pong failed, but has success interval candidate with ping state : " + (Object)this.pingState + " enter EMSmartPingState.EMReevaluating");
                    this.changeState(EMSmartPingState.EMReevaluating);
                }
                this.succeededInterval = 0;
                EMClient.getInstance().forceReconnect();
            }
        }
    }

    private boolean hasDataConnection() {
        return NetUtils.hasDataConnection(this.mContext) && EMClient.getInstance().isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void releaseWakelock() {
        EMSmartHeartBeat eMSmartHeartBeat = this;
        synchronized (eMSmartHeartBeat) {
            PowerManager.WakeLock wakeLock = eMSmartHeartBeat.wakeLock;
            if (wakeLock != null && wakeLock.isHeld()) {
                try {
                    this.wakeLock.release();
                }
                catch (Exception exception) {
                    EMLog.e(TAG, exception.getMessage());
                }
                EMLog.d(TAG, "released the wake lock");
            }
            // ** MonitorExit[this] (shouldn't be in output)
            return;
        }
    }

    private boolean sendPingPong() {
        EMLog.d(TAG, "send ping-pong type heartbeat");
        if (!EMClient.getInstance().isConnected()) {
            return false;
        }
        EMClient.getInstance().checkTokenAvailability();
        return EMClient.getInstance().sendPing(true, 8000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void changeState(EMSmartPingState toState) {
        void var1_1;
        EMLog.d(TAG, "change smart ping state from : " + (Object)((Object)this.pingState) + " to : " + var1_1);
        Object object = this.stateLock;
        synchronized (object) {
            this.pingState = var1_1;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSameNet(boolean isWifi) {
        void var1_1;
        EMLog.d(TAG, "prevWifi:" + this.prevWifi + " isWifi:" + (boolean)var1_1);
        return this.prevWifi == var1_1;
    }

    private void reset() {
        EMLog.d(TAG, "reset interval...");
        this.currentInterval = 0;
        this.succeededInterval = 0;
        this.dataReceivedDuringInterval = false;
        this.changeState(EMSmartPingState.EMEvaluating);
    }

    private void calcDisconnectedInterval() {
        EMSmartHeartBeat eMSmartHeartBeat = this;
        EMLog.d(TAG, "reset interval...");
        int n = NetUtils.isWifiConnected(eMSmartHeartBeat.mContext);
        boolean bl = NetUtils.isEthernetConnected(eMSmartHeartBeat.mContext);
        if (Debug) {
            EMParamsQuickTest eMParamsQuickTest;
            EMParamsQuickTest eMParamsQuickTest2 = eMParamsQuickTest;
            eMParamsQuickTest = new EMParamsQuickTest(this);
            this.params = eMParamsQuickTest2;
        } else if (this.useCustomizedParams) {
            IParams iParams;
            if (bl) {
                EMParams eMParams;
                iParams = eMParams;
                eMParams = new EMParams(this);
            } else {
                EMAHeartBeatCustomizedParams eMAHeartBeatCustomizedParams = n != 0 ? this.mCustomizedWifiParams : this.mCustomizedMobileParams;
                iParams = new EMParamsCustomized(this, eMAHeartBeatCustomizedParams);
            }
            this.params = iParams;
        } else {
            EMParams eMParams;
            EMParams eMParams2 = eMParams;
            eMParams = new EMParams(this);
            this.params = eMParams2;
        }
        this.prevWifi = n;
        if (this.isSameNet(n != 0) && (n = this.currentInterval) != 0) {
            EMSmartHeartBeat eMSmartHeartBeat2 = this;
            eMSmartHeartBeat2.currentInterval = eMSmartHeartBeat2.params.getNextInterval(n, false);
            if (eMSmartHeartBeat2.pingState == EMSmartPingState.EMHitted) {
                this.changeState(EMSmartPingState.EMEvaluating);
            } else {
                this.changeState(EMSmartPingState.EMReevaluating);
            }
            this.succeededInterval = 0;
        } else {
            EMSmartHeartBeat eMSmartHeartBeat3 = this;
            eMSmartHeartBeat3.currentInterval = eMSmartHeartBeat3.params.getDefaultInterval();
            eMSmartHeartBeat3.succeededInterval = 0;
            eMSmartHeartBeat3.changeState(EMSmartPingState.EMEvaluating);
        }
        this.dataReceivedDuringInterval = false;
        EMLog.d(TAG, "reset currentInterval:" + EMCollector.timeToString(this.currentInterval));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$402(EMSmartHeartBeat x0, boolean x1) {
        void var1_1;
        var0.dataReceivedDuringInterval = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$202(EMSmartHeartBeat x0, boolean x1) {
        void var1_1;
        var0.isInBackground = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ TimerTask access$502(EMSmartHeartBeat x0, TimerTask x1) {
        void var1_1;
        var0.disconnectTask = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ EMHeartBeatReceiver access$1002(EMSmartHeartBeat x0, EMHeartBeatReceiver x1) {
        void var1_1;
        var0.alarmIntentReceiver = var1_1;
        return x1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomizedParams(EMAHeartBeatCustomizedParams wifiParams, EMAHeartBeatCustomizedParams mobileParams) {
        void var2_2;
        if (wifiParams != null && var2_2 != null) {
            void var1_1;
            EMSmartHeartBeat eMSmartHeartBeat = this;
            eMSmartHeartBeat.useCustomizedParams = true;
            eMSmartHeartBeat.mCustomizedWifiParams = var1_1;
            eMSmartHeartBeat.mCustomizedMobileParams = var2_2;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setFixedInterval(int interval) {
        void var1_1;
        this.fixedInterval = var1_1 * 1000;
    }

    public void onInit() {
        Object object;
        EMSmartHeartBeat eMSmartHeartBeat = this;
        eMSmartHeartBeat.threadPool = Executors.newSingleThreadExecutor();
        eMSmartHeartBeat.changeState(EMSmartPingState.EMEvaluating);
        eMSmartHeartBeat.reset();
        eMSmartHeartBeat.disconnectTimer = new Timer();
        eMSmartHeartBeat.alarmManager = (AlarmManager)eMSmartHeartBeat.mContext.getSystemService("alarm");
        if (eMSmartHeartBeat.cnnListener == null) {
            EMConnectionListener eMConnectionListener;
            object = eMConnectionListener;
            eMConnectionListener = new EMConnectionListener(this){
                final /* synthetic */ EMSmartHeartBeat this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onDisconnected(int error) {
                    void var1_1;
                    EMLog.d(EMSmartHeartBeat.TAG, " onDisconnected ..." + (int)var1_1);
                }

                @Override
                public void onConnected() {
                    EMLog.d(EMSmartHeartBeat.TAG, " onConnectred ...");
                    if (EMPushHelper.getInstance().getPushType() == EMPushType.FCM && this.this$0.isInBackground) {
                        EMClient.getInstance().disconnect();
                        return;
                    }
                    1 v0 = this;
                    v0.this$0.calcDisconnectedInterval();
                    v0.this$0.scheduleNextAlarm();
                }
            };
            this.cnnListener = object;
        }
        if (this.messageListener == null) {
            EMMessageListener eMMessageListener;
            object = eMMessageListener;
            eMMessageListener = new EMMessageListener(this){
                final /* synthetic */ EMSmartHeartBeat this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void onMessageReceived(List<EMMessage> messages) {
                    2 v0 = this;
                    EMSmartHeartBeat.access$402(v0.this$0, true);
                    v0.this$0.scheduleNextAlarm();
                }

                @Override
                public void onCmdMessageReceived(List<EMMessage> messages) {
                    2 v0 = this;
                    EMSmartHeartBeat.access$402(v0.this$0, true);
                    v0.this$0.scheduleNextAlarm();
                }

                @Override
                public void onMessageRead(List<EMMessage> messages) {
                    2 v0 = this;
                    EMSmartHeartBeat.access$402(v0.this$0, true);
                    v0.this$0.scheduleNextAlarm();
                }

                @Override
                public void onMessageDelivered(List<EMMessage> messages) {
                    2 v0 = this;
                    EMSmartHeartBeat.access$402(v0.this$0, true);
                    v0.this$0.scheduleNextAlarm();
                }

                @Override
                public void onMessageRecalled(List<EMMessage> messages) {
                    2 v0 = this;
                    EMSmartHeartBeat.access$402(v0.this$0, true);
                    v0.this$0.scheduleNextAlarm();
                }

                @Override
                public void onMessageChanged(EMMessage message, Object change) {
                }

                @Override
                public void onGroupMessageRead(List<EMGroupReadAck> groupReadAcks) {
                }

                @Override
                public void onReadAckForGroupMessageUpdated() {
                }
            };
            this.messageListener = object;
        }
        EMSmartHeartBeat eMSmartHeartBeat2 = this;
        EMClient.getInstance().addConnectionListener(this.cnnListener);
        EMClient.getInstance().chatManager().addMessageListener(this.messageListener);
        object = (PowerManager)eMSmartHeartBeat2.mContext.getSystemService("power");
        if (eMSmartHeartBeat2.wakeLock == null) {
            this.wakeLock = object.newWakeLock(1, "heartbeatlock");
        }
        if (Utils.isSdk14()) {
            EMClient.getInstance().setAppStateListener(new EMClient.AppStateListener(this){
                final /* synthetic */ EMSmartHeartBeat this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void onForeground() {
                    EMLog.d(EMSmartHeartBeat.TAG, "app onForeground");
                    EMSmartHeartBeat.access$202(this.this$0, false);
                    new Thread(new Runnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void run() {
                            if (EMPushHelper.getInstance().getPushType() == EMPushType.FCM && this.this$1.this$0.disconnectTask != null) {
                                this.this$1.this$0.disconnectTask.cancel();
                            }
                            if (NetUtils.hasDataConnection(this.this$1.this$0.mContext)) {
                                if (!EMClient.getInstance().isConnected()) {
                                    EMClient.getInstance().onNetworkChanged();
                                } else {
                                    this.this$1.this$0.sendPingCheckConnection();
                                }
                            }
                        }
                    }).start();
                }

                @Override
                public void onBackground() {
                    EMSmartHeartBeat.access$202(this.this$0, true);
                    EMLog.d(EMSmartHeartBeat.TAG, "app onBackground");
                    new Thread(new Runnable(this){
                        final /* synthetic */ 3 this$1;
                        {
                            void var1_1;
                            this.this$1 = var1_1;
                        }

                        @Override
                        public void run() {
                            if (EMPushHelper.getInstance().getPushType() == EMPushType.FCM) {
                                2 v0 = this;
                                EMSmartHeartBeat eMSmartHeartBeat = v0.this$1.this$0;
                                EMSmartHeartBeat.access$502(eMSmartHeartBeat, eMSmartHeartBeat.getTask());
                                try {
                                    v0.this$1.this$0.disconnectTimer.schedule(this.this$1.this$0.disconnectTask, 180000L);
                                    EMLog.d(EMSmartHeartBeat.TAG, "schedule disconnect task");
                                }
                                catch (Exception exception) {}
                            }
                        }
                    }).start();
                }
            });
        }
        this.inited = true;
    }

    void sendPingCheckConnection() {
        boolean bl = EMClient.getInstance().sendPing(true, 3000L);
        EMClient.getInstance().checkTokenAvailability();
        String string = TAG;
        StringBuilder stringBuilder = new StringBuilder().append("send check Ping ");
        String string2 = bl ? "success" : "timeout";
        EMLog.d(string, stringBuilder.append(string2).toString());
        if (bl) {
            this.dataReceivedDuringInterval = true;
            this.scheduleNextAlarm();
        } else {
            EMClient.getInstance().forceReconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        if (this.pingState == EMSmartPingState.EMStopped) {
            return;
        }
        if (!EMClient.getInstance().isConnected() && NetUtils.hasDataConnection(this.mContext)) {
            EMClient.getInstance().onNetworkChanged();
        }
        if (EMClient.getInstance().isConnected() && NetUtils.hasNetwork(this.mContext)) {
            if (this.dataReceivedDuringInterval) {
                this.dataReceivedDuringInterval = false;
                EMLog.d(TAG, "receiving packet...");
                return;
            }
            EMSmartHeartBeat eMSmartHeartBeat = this;
            EMLog.d(TAG, "post heartbeat runnable");
            synchronized (eMSmartHeartBeat) {
                ExecutorService executorService = eMSmartHeartBeat.threadPool;
                if (executorService != null && !executorService.isShutdown()) {
                    this.threadPool.execute(this.heartBeatRunnable);
                }
                // ** MonitorExit[this] (shouldn't be in output)
                return;
            }
        }
        if (this.dataReceivedDuringInterval) {
            this.dataReceivedDuringInterval = false;
        }
        this.scheduleNextAlarm();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scheduleNextAlarm() {
        try {
            EMLog.d("smart ping", "schedule next alarm");
            EMLog.d("smart ping", "current heartbeat interval : " + EMCollector.timeToString(this.currentInterval) + " smart ping state : " + (Object)this.pingState);
            this.dataReceivedDuringInterval = false;
            if (this.alarmIntent == null) {
            }
            ** GOTO lbl24
        }
        catch (Exception var0_5) {
            var0_5.printStackTrace();
            EMLog.e("smart ping", "schedule next alarm error : " + var0_5.getMessage());
            return;
        }
        var1_6 = v0;
        {
            var1_6("hyphenate.chat.heatbeat." + EMClient.getInstance().getChatConfigPrivate().b());
            v0.setPackage(this.mContext.getPackageName());
        }
        {
            if (Build.VERSION.SDK_INT >= 23) {
                v1 = this;
                v2 = v1;
                v3 = PendingIntent.getBroadcast((Context)v1.mContext, (int)0, (Intent)var1_6, (int)0x4000000);
            } else {
                v4 = this;
                v2 = v4;
                v3 = v2.alarmIntent = PendingIntent.getBroadcast((Context)v4.mContext, (int)0, (Intent)var1_6, (int)0);
            }
lbl24:
            // 3 sources

            if (this.alarmIntentReceiver != null) ** GOTO lbl32
            this.alarmIntentReceiver = new EMHeartBeatReceiver(this);
        }
        var1_6 = v5;
        {
            v5 = new IntentFilter("hyphenate.chat.heatbeat." + EMClient.getInstance().getChatConfigPrivate().b());
            if (Build.VERSION.SDK_INT < 33) ** GOTO lbl-1000
            v6 = this.mContext.registerReceiver((BroadcastReceiver)this.alarmIntentReceiver, (IntentFilter)var1_6, 2);
        }
        ** GOTO lbl32
lbl-1000:
        // 1 sources

        {
            v6 = this.mContext.registerReceiver((BroadcastReceiver)this.alarmIntentReceiver, (IntentFilter)var1_6);
lbl32:
            // 3 sources

            v7 = this;
            System.currentTimeMillis();
        }
        {
            if (!v7.hasDataConnection()) ** GOTO lbl43
            if (this.currentInterval > 0) ** GOTO lbl41
            var1_6 = this.params;
            if (var1_6 == null) ** GOTO lbl40
        }
        {
            block16: {
                this.currentInterval = var1_6.getDefaultInterval();
lbl40:
                // 2 sources

                EMLog.d("smart ping", "current heartbeat interval is not set, use default interval : " + EMCollector.timeToString(this.currentInterval));
lbl41:
                // 2 sources

                var1_7 = System.currentTimeMillis() + (long)this.currentInterval;
                break block16;
lbl43:
                // 1 sources

                var1_7 = System.currentTimeMillis() + 180000L;
                EMLog.d("smart ping", "is not connected to server, so use idle interval : 3 mins");
            }
            var3_8 = Build.VERSION.SDK_INT;
            if (var3_8 < 31) ** GOTO lbl59
        }
        {
            if (!this.alarmManager.canScheduleExactAlarms()) {
                var0_2 = 0;
                var3_10 = this.alarmIntent;
                this.alarmManager.setAndAllowWhileIdle(var0_2, var1_7, var3_10);
                return;
            }
            v8 = this.alarmManager;
            var0_1 = 0;
            var3_9 = this.alarmIntent;
lbl56:
            // 2 sources

            while (true) {
                v8.setExactAndAllowWhileIdle(var0_1, var1_7, var3_9);
                return;
            }
lbl59:
            // 1 sources

            if (var3_8 >= 23) {
                v8 = this.alarmManager;
                var0_1 = 0;
                var3_9 = this.alarmIntent;
                ** continue;
            }
            if (var3_8 >= 19) {
                var0_3 = 0;
                var3_11 = this.alarmIntent;
                this.alarmManager.setExact(var0_3, var1_7, var3_11);
                return;
            }
            var0_4 = 0;
            var3_12 = this.alarmIntent;
            this.alarmManager.set(var0_4, var1_7, var3_12);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        block9: {
            EMLog.d(TAG, "stop heart beat timer");
            if (!this.inited) {
                EMLog.w(TAG, "smart heartbeat is not inited!");
                return;
            }
            EMSmartHeartBeat eMSmartHeartBeat = this;
            eMSmartHeartBeat.changeState(EMSmartPingState.EMStopped);
            synchronized (eMSmartHeartBeat) {
                eMSmartHeartBeat.threadPool.shutdownNow();
                {
                    // MONITOREXIT @DISABLED, blocks:[1, 3] lbl14 : MonitorExitStatement: MONITOREXIT : v42455
                    eMSmartHeartBeat.reset();
                    eMSmartHeartBeat.releaseWakelock();
                    eMSmartHeartBeat.disconnectTimer.cancel();
                    if (eMSmartHeartBeat.cnnListener != null) {
                        EMClient.getInstance().removeConnectionListener(this.cnnListener);
                    }
                    if (this.messageListener == null) break block9;
                    EMClient.getInstance().chatManager().removeMessageListener(this.messageListener);
                    this.messageListener = null;
                }
            }
        }
        try {
            EMSmartHeartBeat eMSmartHeartBeat = this;
            eMSmartHeartBeat.alarmManager.cancel(this.alarmIntent);
            eMSmartHeartBeat.mContext.unregisterReceiver((BroadcastReceiver)this.alarmIntentReceiver);
            eMSmartHeartBeat.alarmIntentReceiver = null;
            return;
        }
        catch (Exception exception) {
            if (exception.getMessage().contains("Receiver not registered")) {
                return;
            }
            exception.printStackTrace();
        }
    }

    private static enum EMSmartPingState {
        EMReady,
        EMEvaluating,
        EMReevaluating,
        EMHitted,
        EMStopped;

    }

    abstract class IParams {
        final /* synthetic */ EMSmartHeartBeat this$0;

        /*
         * WARNING - void declaration
         */
        IParams(EMSmartHeartBeat this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        abstract int getMinInterval();

        abstract int getMaxInterval();

        abstract int getDefaultInterval();

        abstract int getPingPongTimeout();

        abstract int getPingPongCheckInterval();

        /*
         * Unable to fully structure code
         */
        int getNextInterval(int interval, boolean increase) {
            block7: {
                if (EMSmartHeartBeat.access$000(this.this$0) != -1) {
                    EMLog.d("smart ping", "use fixed interval: " + EMSmartHeartBeat.access$000(this.this$0));
                    return EMSmartHeartBeat.access$000(this.this$0);
                }
                if ((var2_2 = var2_2 != 0 ? 1 : -1) >= 0) break block7;
                if (var1_1 <= 60000) ** GOTO lbl-1000
                if (var1_1 > 120000) ** GOTO lbl-1000
                ** GOTO lbl-1000
            }
            if (var1_1 < 60000) lbl-1000:
            // 2 sources

            {
                var1_1 += var2_2 * 10 * 1000;
            } else if (var1_1 < 120000) lbl-1000:
            // 2 sources

            {
                var1_1 += var2_2 * 30 * 1000;
            } else lbl-1000:
            // 2 sources

            {
                var1_1 += var2_2 * 45 * 1000;
            }
            if (var1_1 > this.getMaxInterval()) {
                var1_1 = this.getMaxInterval();
            }
            if (var1_1 < this.getMinInterval()) {
                var1_1 = this.getMinInterval();
            }
            return var1_1;
        }
    }

    class EMParamsQuickTest
    extends IParams {
        static final int MOBILE_DEFAULT_INTERVAL = 20000;
        static final int WIFI_DEFAULT_INTERVAL = 20000;
        static final int MIN_INTERVAL = 10000;
        static final int MAX_INTERVAL = 30000;
        static final int MAX_MIN_INTERVAL_COUNTER = 3;
        static final int PING_PONG_TIMEOUT = 8000;
        static final int PING_PONG_CHECK_INTERVAL = 900000;
        final /* synthetic */ EMSmartHeartBeat this$0;

        /*
         * WARNING - void declaration
         */
        EMParamsQuickTest(EMSmartHeartBeat this$0) {
            void var1_1;
            this.this$0 = var1_1;
            super((EMSmartHeartBeat)var1_1);
        }

        @Override
        int getDefaultInterval() {
            NetUtils.isWifiConnected(this.this$0.mContext);
            return 20000;
        }

        @Override
        int getMinInterval() {
            return 10000;
        }

        @Override
        int getMaxInterval() {
            return 30000;
        }

        @Override
        int getPingPongTimeout() {
            return 8000;
        }

        @Override
        int getPingPongCheckInterval() {
            return 900000;
        }

        @Override
        int getNextInterval(int interval, boolean increase) {
            int n;
            if ((n += (increase ? 1 : -1) * 5 * 1000) > this.getMaxInterval()) {
                n = this.getMaxInterval();
            }
            if (n < this.getMinInterval()) {
                n = this.getMinInterval();
            }
            return n;
        }
    }

    class EMParams
    extends IParams {
        static final int MOBILE_DEFAULT_INTERVAL = 180000;
        static final int WIFI_DEFAULT_INTERVAL = 120000;
        static final int MIN_INTERVAL = 30000;
        static final int MAX_INTERVAL = 270000;
        static final int MAX_MIN_INTERVAL_COUNTER = 3;
        static final int PING_PONG_TIMEOUT = 8000;
        static final int PING_PONG_CHECK_INTERVAL = 900000;
        final /* synthetic */ EMSmartHeartBeat this$0;

        /*
         * WARNING - void declaration
         */
        EMParams(EMSmartHeartBeat this$0) {
            void var1_1;
            this.this$0 = var1_1;
            super((EMSmartHeartBeat)var1_1);
        }

        @Override
        int getDefaultInterval() {
            if (this.this$0.fixedInterval != -1) {
                return this.this$0.fixedInterval;
            }
            return NetUtils.isWifiConnected(this.this$0.mContext) ? 120000 : 180000;
        }

        @Override
        int getMinInterval() {
            return 30000;
        }

        @Override
        int getMaxInterval() {
            return 270000;
        }

        @Override
        int getPingPongTimeout() {
            return 8000;
        }

        @Override
        int getPingPongCheckInterval() {
            return 900000;
        }
    }

    class EMParamsCustomized
    extends IParams {
        static final int PING_PONG_TIMEOUT = 8000;
        static final int PING_PONG_CHECK_INTERVAL = 900000;
        private final int defaultInterval;
        private final int minInterval;
        private final int maxInterval;
        final /* synthetic */ EMSmartHeartBeat this$0;

        /*
         * WARNING - void declaration
         */
        EMParamsCustomized(EMSmartHeartBeat this$0, EMAHeartBeatCustomizedParams params) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            super((EMSmartHeartBeat)var1_1);
            this.defaultInterval = var2_2.defaultInterval;
            this.minInterval = var2_2.minInterval;
            this.maxInterval = var2_2.maxInterval;
        }

        @Override
        int getDefaultInterval() {
            if (this.this$0.fixedInterval != -1) {
                return this.this$0.fixedInterval;
            }
            EMLog.d(EMSmartHeartBeat.TAG, "get customized default: " + this.defaultInterval);
            return this.defaultInterval;
        }

        @Override
        int getMinInterval() {
            return this.minInterval;
        }

        @Override
        int getMaxInterval() {
            return this.maxInterval;
        }

        @Override
        int getPingPongTimeout() {
            return 8000;
        }

        @Override
        int getPingPongCheckInterval() {
            return 900000;
        }
    }
}

