package com.hyphenate.push.platform.vivo;

import android.content.Context;


import com.hyphenate.push.EMPushConfig;
import com.hyphenate.push.EMPushHelper;
import com.hyphenate.push.EMPushType;
import com.hyphenate.push.PushListener;
import com.hyphenate.push.platform.IPush;
import com.hyphenate.util.EMLog;
import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;
import com.vivo.push.listener.IPushQueryActionListener;
import com.vivo.push.util.VivoPushException;

/**
 * Created by zhangsong on 19-2-20
 * <p>
 * 文档地址：https://dev.vivo.com.cn/documentCenter/doc/158
 * <p>
 * 应用安装后默认未打开设置中的通知栏通知权限，需要手动打开。
 */
public class EMVivoPush extends IPush {
    private static final String TAG = "EMVivoPush";

    @Override
    public EMPushType getPushType() {
        return EMPushType.VIVOPUSH;
    }

    @Override
    public void onRegister(final Context context, EMPushConfig config, PushListener pushListener) {
        EMLog.d(TAG,"vivo onRegister isAgreePrivacyStatement " + config.isAgreePrivacyStatement());
        try {
            PushClient.getInstance(context).checkManifest();
            com.vivo.push.PushConfig.Builder build = new com.vivo.push.PushConfig.Builder().agreePrivacyStatement(config.isAgreePrivacyStatement());
            PushClient.getInstance(context).initialize(build.build());
            PushClient.getInstance(context).turnOnPush(new IPushActionListener() {
                @Override
                public void onStateChanged(int state) {
                    EMLog.d(TAG,"turnOnPush onStateChanged state: " + state);
                    if (state == 0) {
                        PushClient.getInstance(context).getRegId(new IPushQueryActionListener() {
                            @Override
                            public void onSuccess(String regId) {
                                EMLog.d(TAG,"getRegId  onSuccess: " + regId);
                                // send regId to hyphenate server.
                                EMPushHelper.getInstance().onReceiveToken(getPushType(), regId);
                            }
                            @Override
                            public void onFail(Integer error) {
                                EMLog.e(TAG,"getRegId  onFail: " + error);
                                // handle register error.
                                EMPushHelper.getInstance().onErrorResponse(getPushType(), error);
                            }
                        });
                    }
                }
            });
        } catch (VivoPushException e) {
            EMLog.e(TAG, "Vivo init failed: " + e.getCode() + " " + e.getMessage());
        }
    }

    @Override
    public void onUnregister(Context context) {
    }

    @Override
    public String onGetNotifierName(EMPushConfig config) {
        return config.getVivoAppId() + "#" + config.getVivoAppKey();
    }
}
