/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import android.text.TextUtils;

import com.hyphenate.EMError;
import com.hyphenate.cloud.HttpClientManager;
import com.hyphenate.cloud.HttpResponse;
import com.hyphenate.util.EMLog;

import org.apache.http.conn.ConnectTimeoutException;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Map;

public class EMARHttpAPI {

    public static final String TAG = "EMARHttpAPI";

    public static int REQUEST_FAILED_CODE = 408;


    public static int upload(final String localFilePath, String remoteFilePath,  final String filename, final Map<String, String> headers,
            StringBuilder responseBuf, final EMARHttpCallback callback) {
        if(TextUtils.isEmpty(localFilePath)) {
            return EMError.FILE_NOT_FOUND;
        }
        return HttpClientManager.uploadFile(localFilePath, remoteFilePath, filename, headers, responseBuf, callback);
    }

    /**
     * @param filePath
     * @param remoteFilePath
     * @param partNum 分片序号
     * @param partLength 分片大小
     * @param offset 读取分片的偏移量
     * @param headers
     * @param responseBuf
     * @param callback
     * @return
     */
    public static int uploadInParts(String filePath,String remoteFilePath,int partNum,long partLength,long offset, final Map<String, String> headers,
            StringBuilder responseBuf, final EMARHttpCallback callback) {
        if(TextUtils.isEmpty(filePath)) {
            return EMError.INVALID_PARAM;
        }
        return HttpClientManager.uploadInParts(filePath,remoteFilePath,partNum,partLength,offset, headers, responseBuf, callback);
    }

    public static int uploadCrashDump(String filePath,String uploadUrl,final Map<String, String> headers,final Map<String, String> params,StringBuilder responseBuf, final EMARHttpCallback callback) {
        if(TextUtils.isEmpty(filePath)||TextUtils.isEmpty(uploadUrl)) {
            return EMError.INVALID_PARAM;
        }
        return HttpClientManager.uploadCrashDump(filePath,uploadUrl,headers,params,responseBuf, callback);
    }

    public static int download(String remoteUrl, final String localFilePath, final Map<String, String> headers, EMARHttpCallback callback) {
        if(TextUtils.isEmpty(localFilePath)) {
            return EMError.FILE_NOT_FOUND;
        }
        return HttpClientManager.downloadFile(remoteUrl, localFilePath, headers, callback);
    }

    public static int download(String remoteUrl, final String localFilePath, final Map<String, String> headers,StringBuilder responseBuf, EMARHttpCallback callback) {
        if(TextUtils.isEmpty(localFilePath)) {
            return EMError.FILE_NOT_FOUND;
        }
        return HttpClientManager.downloadFile(remoteUrl,localFilePath, headers,responseBuf, callback);
    }

    public static int httpExecute(String reqURL, Map<String, String> headers, String body, String method, StringBuilder strResponse) {
        int code = REQUEST_FAILED_CODE;

        try {
            HttpResponse response = _httpExecute(reqURL, headers, body, method);
            strResponse.append(response.content);
            code = response.code;
            if(code == HttpURLConnection.HTTP_CLIENT_TIMEOUT) {
                code = EMError.SERVER_TIMEOUT;
            }
            EMLog.d(TAG, "httpExecute code: " + code);
            return code;
        } catch(ConnectTimeoutException e) {
            EMLog.e(TAG, "ConnectTimeoutException");
        } catch (Exception e) {
            EMLog.e(TAG, e.getClass().getSimpleName()+": "+e.getMessage());
            e.printStackTrace();
        }
        EMLog.e(TAG, "can't catch exceptions");
        return code;
    }

    private static HttpResponse _httpExecute(String reqURL, Map<String, String> headers, String body, String method ) throws IOException{
        return HttpClientManager.httpExecute(reqURL, headers, body, method);
    }


}
