/*
 *  * EaseMob CONFIDENTIAL
 * __________________
 * Copyright (C) 2017 EaseMob Technologies. All rights reserved.
 *
 * NOTICE: All information contained herein is, and remains
 * the property of EaseMob Technologies.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from EaseMob Technologies.
 */
package com.hyphenate.chat.adapter;

import java.util.List;

public abstract class EMAConnectionListener extends EMABase implements EMAConnectionListenerInterface {

	@Override
	public void onConnected() {
	}

	@Override
	public void onDisconnected(final int errCode, EMALogoutInfo info) {
	}

	@Override
	public boolean verifyServerCert(List<String> certschain,String domain) {
		return true;
	}
	public void onTokenNotification(final int errCode) {
	}

	@Override
	public void onReceiveToken(String token, long expireTimestamp) {}

	@Override
	public void onDatabaseOpened(int errCode) {}

	@Override
	public void onOfflineMessageSyncStart() {

	}

	@Override
	public void onOfflineMessageSyncFinish() {

	}

	public EMAConnectionListener() {
		nativeInit();
	}
	
	@Override
	public void finalize() throws Throwable {
		nativeFinalize();
		super.finalize();
	}
	
	/**
	 * create native listener class which implements EMContactListener interface.
	 */
	native void nativeInit();
	native void nativeFinalize();
	
}
