package com.hyphenate.chat;

import com.hyphenate.chat.adapter.EMAGroupMemberInfo;

/**
 * \~chinese
 * 群组成员信息
 * <p>
 * \~english
 * Group member information
 */
public class EMGroupMemberInfo {
    private EMAGroupMemberInfo emaGroupMemberInfo;

    protected EMGroupMemberInfo() {
        emaGroupMemberInfo = new EMAGroupMemberInfo();
    }

    protected EMGroupMemberInfo(EMAGroupMemberInfo emaGroupMemberInfo) {
        this.emaGroupMemberInfo = emaGroupMemberInfo;
    }

    /**
     * \~chinese
     * 获取成员 ID 。
     *
     * @return 成员 ID。
     * <p>
     * \~english
     * Get member ID.
     * @return Member ID.
     */
    public String getMemberId() {
        if (emaGroupMemberInfo == null) {
            return "";
        }
        return emaGroupMemberInfo.getMemberId();
    }

    /**
     * \~chinese
     * 获取成员入群时间。
     *
     * @return 成员入群时间。Unix 时间戳，单位为毫秒。
     * <p>
     * \~english
     * Get the time when the member joined the group.
     * @return The time when the member joined the group. Unix timestamp in milliseconds.
     */
    public long getJoinTime() {
        if (emaGroupMemberInfo == null) {
            return 0;
        }
        return emaGroupMemberInfo.getJoinTime();
    }
    /**
     * \~chinese
     * 获取成员角色。
     *
     * @return 成员角色。详见{@link EMGroup.EMGroupPermissionType}。
     * <p>
     * \~english
     * Get member role.
     * @return Member role. See {@link EMGroup.EMGroupPermissionType}.
     */
    public EMGroup.EMGroupPermissionType getRole() {
        if (emaGroupMemberInfo == null) {
            return EMGroup.EMGroupPermissionType.none;
        }
        int role = emaGroupMemberInfo.getRole();
        if(role==0) {
            return EMGroup.EMGroupPermissionType.member;
        }else if(role==1) {
            return EMGroup.EMGroupPermissionType.admin;
        }else if(role==2) {
            return EMGroup.EMGroupPermissionType.owner;
        }
        return  EMGroup.EMGroupPermissionType.none;
    }

    @Override
    public String toString() {
        if(emaGroupMemberInfo!=null) {
            return "memberId:" + getMemberId() + ", joinTime:" + getJoinTime() + ", role:" + getRole().name();
        }
        return "";
    }
}
