package com.hyphenate.chat.adapter;

import android.text.TextUtils;

import com.hyphenate.chat.EMChatThreadEvent;
import com.hyphenate.chat.adapter.message.EMAMessage;
import com.hyphenate.util.EMLog;

public class EMAThreadInfo extends EMABase {

    public enum LeaveReason {
        LEFT,
        BE_KICKED,      //User is kicked out by the group owner.
        DESTROYED       //Thread was destroyed by the group owner.
    }

    public EMAThreadInfo() {
        nativeInit();
    }

    @Override
    public void finalize() throws Throwable {
        nativeFinalize();
        super.finalize();
    }

    public EMChatThreadEvent.TYPE getType() {
        String type = nativeGetThreadType();
        if(TextUtils.isEmpty(type)) {
            return EMChatThreadEvent.TYPE.UNKNOWN;
        }
        EMChatThreadEvent.TYPE value = null;
        try {
            value = EMChatThreadEvent.TYPE.valueOf(type.toUpperCase());
        } catch (Exception e) {
            EMLog.e("EMThreadEvent", e.getMessage());
            value = EMChatThreadEvent.TYPE.UNKNOWN;
        }
        return value;
    }

    public String getThreadId() {
        return nativeGetThreadId();
    }

    public String getThreadName() {
        return nativeGetThreadName();
    }

    public String getOwner() {
        return nativeGetOwner();
    }

    public String getParentId() {
        return nativeGetParentId();
    }

    public String getMessageId() {
        return nativeGetMessageId();
    }

    public String getFrom() {
        return nativeGetFrom();
    }

    public String getTo() {
        return nativeGetTo();
    }

    public long getCreateAt() {
        return nativeGetCreateAt();
    }

    public long getUpdateAt() {
        return nativeGetUpdateAt();
    }

    public int getMessageCount() {
        return nativeGetMessageCount();
    }

    public int getMemberCount() {
        return nativeGetMemberCount();
    }

    public EMAMessage getLastMessage() {
        return nativeGetLastMessage();
    }

    native void nativeInit();
    native void nativeFinalize();
    native String nativeGetThreadType();
    native String nativeGetThreadId();
    native String nativeGetThreadName();
    native String nativeGetOwner();
    native String nativeGetParentId();
    native String nativeGetMessageId();
    native String nativeGetFrom();
    native String nativeGetTo();
    native long nativeGetCreateAt();
    native long nativeGetUpdateAt();
    native int nativeGetMessageCount();
    native int nativeGetMemberCount();
    native EMAMessage nativeGetLastMessage();
}
