package com.hyphenate.chat;

/**
 * \~chinese
 * EMRTCTokenInfo 类用于存储 RTC Token 信息。包括用户Agora uid、Token 字符串和过期时间戳。
 * 
 * \~english
 * The EMRTCTokenInfo class is used to store RTC Token information, including the user's Agora uid, the Token string, and the expiration timestamp.
 */
public class EMRTCTokenInfo {


   /**
    * \~chinese
    * Token 字符串
    * 
    * \~english
    * Token string
    */ 
   private String rtcToken;

   /**
    * \~chinese
    * 过期时间戳
    * 
    * \~english
    * Expiration timestamp
    */
   private long expireTimeStamp;

   /**
    * \~chinese
    * 用户 Agora uid
    *
    * \~english
    * User Agora uid
    */
   private int uid;

   /**
    * \~chinese
    * 构造函数
    * 
    * \~english
    * Constructor
    */
   public EMRTCTokenInfo( String rtcToken, long expireTimeStamp,int uid) {
      this.rtcToken = rtcToken;
      this.expireTimeStamp = expireTimeStamp;
      this.uid = uid;
   }

   /**
    * \~chinese
    * 获取 Token 字符串
    * 
    * \~english
    * Get Token string
    */
   public String getRtcToken() {
      return rtcToken;
   }

   /**
    * \~chinese
    * 设置 Token 字符串
    * 
    * \~english
    * Set Token string
    */
   public void setRtcToken(String rtcToken) {
      this.rtcToken = rtcToken;
   }

   /**
    * \~chinese
    * 获取过期时间戳
    * 
    * \~english
    * Get expiration timestamp
    */
   public long getExpireTimeStamp() {
      return expireTimeStamp;
   }

   /**
    * \~chinese
    * 设置过期时间戳
    * 
    * \~english
    * Set expiration timestamp
    */
   public void setExpireTimeStamp(long expireTimeStamp) {
      this.expireTimeStamp = expireTimeStamp;
   }

   /**
    * \~chinese
    * 获取用户 Agora uid
    *
    * \~english
    * Get user Agora uid
    */
   public int getUid() {
      return uid;
   }

   /**
    * \~chinese
    * 设置用户 Agora uid
    *
    * \~english
    * Set user Agora uid
    */
   public void setUid(int uid) {
      this.uid = uid;
   }

   /**
    * \~chinese
    * toString 方法
    * 
   * \~english
    * toString method
    */
   @Override
   public String toString() {
      return "EMRTCTokenInfo{" +
              "uid=" + uid +
              ", token='" + rtcToken + '\'' +
              ", expireTimeStamp=" + expireTimeStamp +
              '}';
   }
}
