package com.hyphenate.chat;

/**
 * \~chinese
 * 自定义会话过滤器。
 * \~english
 * Custom conversation filter.
 */
public interface EMCustomConversationFilter  {

   /**
    * \~chinese
    *
    * 过滤会话。
    *
    * 该方法由用户实现，开发者可以根据会话属性来决定是否过滤掉该会话。
    *
    * @param emConversation 会话对象。
    * @return 由开发者决定返回一个布尔类型的返回值。
              - 返回 `true` 则会话不会被过滤掉，会返回给用户，同时会加载到内存。
              - 返回 `false` 则会话会被过滤，不会返回给用户，也不会加载到内存。
    *
    * \~english
    * Filters conversations.
    *
    * This method is implemented by yourself. You can decide whether to filter out the conversations based on the conversation properties.
    *
    * @param emConversation The conversation object.
    * @return A boolean return value determined by yourself.
    * If `true`, the conversation will be returned and loaded into memory.
    * If `false`, the conversation will be filtered out, instead of being returned and loaded into memory.
    */
   boolean filter(EMConversation emConversation);
}
