/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMVideoMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.utils.EaseDateUtils;
import com.hyphenate.easeui.utils.EaseImageUtils;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowFile;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.TextFormater;

public class EaseChatRowVideo
extends EaseChatRowFile {
    private static final String TAG = EaseChatRowVideo.class.getSimpleName();
    private ImageView imageView;
    private TextView sizeView;
    private TextView timeLengthView;
    private ImageView playView;

    public EaseChatRowVideo(Context context, boolean isSender) {
        super(context, isSender);
    }

    public EaseChatRowVideo(Context context, EMMessage message, int position, Object adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflateView() {
        this.inflater.inflate(!this.showSenderType ? R.layout.ease_row_received_video : R.layout.ease_row_sent_video, (ViewGroup)this);
    }

    @Override
    protected void onFindViewById() {
        this.imageView = (ImageView)this.findViewById(R.id.chatting_content_iv);
        this.sizeView = (TextView)this.findViewById(R.id.chatting_size_iv);
        this.timeLengthView = (TextView)this.findViewById(R.id.chatting_length_iv);
        this.playView = (ImageView)this.findViewById(R.id.chatting_status_btn);
        this.percentageView = (TextView)this.findViewById(R.id.percentage);
    }

    @Override
    protected void onSetUpView() {
        EMVideoMessageBody videoBody;
        if (this.bubbleLayout != null) {
            this.bubbleLayout.setBackground(null);
        }
        if ((videoBody = (EMVideoMessageBody)this.message.getBody()).getDuration() > 0) {
            String time = EaseDateUtils.toTime(videoBody.getDuration());
            this.timeLengthView.setText((CharSequence)time);
        }
        if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            if (videoBody.getVideoFileLength() > 0L) {
                String size = TextFormater.getDataSize((long)videoBody.getVideoFileLength());
                this.sizeView.setText((CharSequence)size);
            }
        } else {
            long videoFileLength = videoBody.getVideoFileLength();
            this.sizeView.setText((CharSequence)TextFormater.getDataSize((long)videoFileLength));
        }
        EMLog.d((String)TAG, (String)("video thumbnailStatus:" + videoBody.thumbnailDownloadStatus()));
        if (this.message.direct() == EMMessage.Direct.RECEIVE) {
            if (videoBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.DOWNLOADING) {
                this.imageView.setImageResource(R.drawable.ease_default_image);
            } else {
                this.imageView.setImageResource(R.drawable.ease_default_image);
                this.showVideoThumbView(this.message);
            }
        } else if (videoBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.DOWNLOADING || videoBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.PENDING || videoBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.FAILED) {
            if (this.progressBar != null) {
                this.progressBar.setVisibility(4);
            }
            if (this.percentageView != null) {
                this.percentageView.setVisibility(4);
            }
            if (videoBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.PENDING) {
                this.showVideoThumbView(this.message);
            } else {
                this.imageView.setImageResource(R.drawable.ease_default_image);
            }
        } else {
            if (this.progressBar != null) {
                this.progressBar.setVisibility(8);
            }
            if (this.percentageView != null) {
                this.percentageView.setVisibility(8);
            }
            this.imageView.setImageResource(R.drawable.ease_default_image);
            this.showVideoThumbView(this.message);
        }
    }

    @SuppressLint(value={"StaticFieldLeak"})
    private void showVideoThumbView(EMMessage message) {
        ViewGroup.LayoutParams params = EaseImageUtils.showVideoThumb(this.context, this.imageView, message);
        this.setBubbleView(params.width, params.height);
    }

    private void setBubbleView(int width, int height) {
        ViewGroup.LayoutParams params = this.bubbleLayout.getLayoutParams();
        params.width = width;
        params.height = height;
    }
}

