/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.menu;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.hyphenate.easeui.modules.menu.MenuItemBean;

public class EasePopupWindow
extends PopupWindow {
    private Context mContext;
    private float mShowAlpha = 0.88f;
    private Drawable mBackgroundDrawable;
    private boolean mCloseChangeBg;

    public EasePopupWindow(Context context) {
        this.mContext = context;
        this.initBasePopupWindow();
    }

    public EasePopupWindow(Context context, boolean closeChangeBg) {
        this.mContext = context;
        this.mCloseChangeBg = closeChangeBg;
        this.initBasePopupWindow();
    }

    public void setBackgroundAlpha(float alpha) {
        this.mShowAlpha = alpha;
    }

    public void setOutsideTouchable(boolean touchable) {
        super.setOutsideTouchable(touchable);
        if (touchable) {
            if (this.mBackgroundDrawable == null) {
                this.mBackgroundDrawable = new ColorDrawable(0);
            }
            super.setBackgroundDrawable(this.mBackgroundDrawable);
        } else {
            super.setBackgroundDrawable(null);
        }
    }

    public void setBackgroundDrawable(Drawable background) {
        this.mBackgroundDrawable = background;
        this.setOutsideTouchable(this.isOutsideTouchable());
    }

    private void initBasePopupWindow() {
        this.setAnimationStyle(16973826);
        this.setHeight(-2);
        this.setWidth(-2);
        this.setOutsideTouchable(true);
        this.setFocusable(true);
    }

    public void setContentView(View contentView) {
        if (contentView != null) {
            contentView.measure(0, 0);
            super.setContentView(contentView);
            this.addKeyListener(contentView);
        }
    }

    public Context getContext() {
        return this.mContext;
    }

    public void showAtLocation(View parent, int gravity, int x, int y) {
        super.showAtLocation(parent, gravity, x, y);
        this.showAnimator().start();
    }

    public void showAsDropDown(View anchor) {
        super.showAsDropDown(anchor);
        this.showAnimator().start();
    }

    public void showAsDropDown(View anchor, int xoff, int yoff) {
        super.showAsDropDown(anchor, xoff, yoff);
        this.showAnimator().start();
    }

    public void showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        super.showAsDropDown(anchor, xoff, yoff, gravity);
        this.showAnimator().start();
    }

    public void dismiss() {
        super.dismiss();
        this.dismissAnimator().start();
    }

    private ValueAnimator showAnimator() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, this.mShowAlpha});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                if (!EasePopupWindow.this.mCloseChangeBg) {
                    EasePopupWindow.this.setWindowBackgroundAlpha(alpha);
                }
            }
        });
        animator.setDuration(360L);
        return animator;
    }

    private ValueAnimator dismissAnimator() {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{this.mShowAlpha, 1.0f});
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                float alpha = ((Float)animation.getAnimatedValue()).floatValue();
                if (!EasePopupWindow.this.mCloseChangeBg) {
                    EasePopupWindow.this.setWindowBackgroundAlpha(alpha);
                }
            }
        });
        animator.setDuration(320L);
        return animator;
    }

    private void addKeyListener(View contentView) {
        if (contentView != null) {
            contentView.setFocusable(true);
            contentView.setFocusableInTouchMode(true);
            contentView.setOnKeyListener(new View.OnKeyListener(){

                public boolean onKey(View view, int keyCode, KeyEvent event) {
                    switch (keyCode) {
                        case 4: {
                            EasePopupWindow.this.dismiss();
                            return true;
                        }
                    }
                    return false;
                }
            });
        }
    }

    private void setWindowBackgroundAlpha(float alpha) {
        Window window = ((Activity)this.getContext()).getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.alpha = alpha;
        window.setAttributes(layoutParams);
    }

    public static interface OnPopupWindowDismissListener {
        public void onDismiss(PopupWindow var1);
    }

    public static interface OnPopupWindowItemClickListener {
        public boolean onMenuItemClick(MenuItemBean var1);
    }
}

