/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.conversation.presenter;

import android.text.TextUtils;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationInfo;
import com.hyphenate.easeui.modules.conversation.presenter.EaseConversationPresenter;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class EaseConversationPresenterImpl
extends EaseConversationPresenter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadData() {
        Map conversations = EMClient.getInstance().chatManager().getAllConversations();
        if (conversations.isEmpty()) {
            this.runOnUI(() -> {
                if (!this.isDestroy()) {
                    this.mView.loadConversationListNoData();
                }
            });
            return;
        }
        ArrayList<EaseConversationInfo> infos = new ArrayList<EaseConversationInfo>();
        EaseConversationPresenterImpl easeConversationPresenterImpl = this;
        synchronized (easeConversationPresenterImpl) {
            EaseConversationInfo info = null;
            for (EMConversation conversation : conversations.values()) {
                if (conversation.getAllMessages().size() == 0 || !this.showSystemMessage && TextUtils.equals((CharSequence)conversation.conversationId(), (CharSequence)"em_system")) continue;
                info = new EaseConversationInfo();
                info.setInfo(conversation);
                String extField = conversation.getExtField();
                long lastMsgTime = conversation.getLastMessage().getMsgTime();
                if (!TextUtils.isEmpty((CharSequence)extField) && EaseCommonUtils.isTimestamp(extField)) {
                    info.setTop(true);
                    long makeTopTime = Long.parseLong(extField);
                    if (makeTopTime > lastMsgTime) {
                        info.setTimestamp(makeTopTime);
                    } else {
                        info.setTimestamp(lastMsgTime);
                    }
                } else {
                    info.setTimestamp(lastMsgTime);
                }
                infos.add(info);
            }
        }
        if (this.isActive()) {
            this.runOnUI(() -> this.mView.loadConversationListSuccess(infos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sortData(List<EaseConversationInfo> data) {
        if (data == null || data.isEmpty()) {
            this.runOnUI(() -> {
                if (!this.isDestroy()) {
                    this.mView.loadConversationListNoData();
                }
            });
            return;
        }
        ArrayList<EaseConversationInfo> sortList = new ArrayList<EaseConversationInfo>();
        ArrayList<EaseConversationInfo> topSortList = new ArrayList<EaseConversationInfo>();
        EaseConversationPresenterImpl easeConversationPresenterImpl = this;
        synchronized (easeConversationPresenterImpl) {
            for (EaseConversationInfo info : data) {
                if (info.isTop()) {
                    topSortList.add(info);
                    continue;
                }
                sortList.add(info);
            }
            this.sortByTimestamp(topSortList);
            this.sortByTimestamp(sortList);
            sortList.addAll(0, topSortList);
        }
        this.runOnUI(() -> {
            if (!this.isDestroy()) {
                this.mView.sortConversationListSuccess(sortList);
            }
        });
    }

    private void sortByTimestamp(List<EaseConversationInfo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        Collections.sort(list, new Comparator<EaseConversationInfo>(){

            @Override
            public int compare(EaseConversationInfo o1, EaseConversationInfo o2) {
                if (o2.getTimestamp() > o1.getTimestamp()) {
                    return 1;
                }
                if (o2.getTimestamp() == o1.getTimestamp()) {
                    return 0;
                }
                return -1;
            }
        });
    }

    @Override
    public void makeConversionRead(int position, EaseConversationInfo info) {
        if (info.getInfo() instanceof EMConversation) {
            ((EMConversation)info.getInfo()).markAllMessagesAsRead();
        }
        if (!this.isDestroy()) {
            this.mView.refreshList(position);
        }
    }

    @Override
    public void makeConversationTop(int position, EaseConversationInfo info) {
        if (info.getInfo() instanceof EMConversation) {
            long timestamp = System.currentTimeMillis();
            ((EMConversation)info.getInfo()).setExtField(timestamp + "");
            info.setTop(true);
            info.setTimestamp(timestamp);
        }
        if (!this.isDestroy()) {
            this.mView.refreshList();
        }
    }

    @Override
    public void cancelConversationTop(int position, EaseConversationInfo info) {
        if (info.getInfo() instanceof EMConversation) {
            ((EMConversation)info.getInfo()).setExtField("");
            info.setTop(false);
            info.setTimestamp(((EMConversation)info.getInfo()).getLastMessage().getMsgTime());
        }
        if (!this.isDestroy()) {
            this.mView.refreshList();
        }
    }

    @Override
    public void deleteConversation(int position, EaseConversationInfo info) {
        if (info.getInfo() instanceof EMConversation) {
            boolean isDelete = EMClient.getInstance().chatManager().deleteConversation(((EMConversation)info.getInfo()).conversationId(), !TextUtils.equals((CharSequence)((EMConversation)info.getInfo()).conversationId(), (CharSequence)"em_system"));
            if (!this.isDestroy()) {
                if (isDelete) {
                    this.mView.deleteItem(position);
                    EMClient.getInstance().translationManager().removeResultsByConversationId(((EMConversation)info.getInfo()).conversationId());
                } else {
                    this.mView.deleteItemFail(position, "");
                }
            }
        }
    }
}

