/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.contact.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.modules.contact.model.EaseContactSetStyle;
import com.hyphenate.easeui.provider.EaseUserProfileProvider;
import com.hyphenate.easeui.utils.EaseUserUtils;
import com.hyphenate.easeui.widget.EaseImageView;

public class EaseContactListAdapter
extends EaseBaseRecyclerViewAdapter<EaseUser> {
    private int emptyLayoutResource;
    private EaseContactSetStyle contactSetModel;

    @Override
    public EaseBaseRecyclerViewAdapter.ViewHolder getViewHolder(ViewGroup parent, int viewType) {
        return new ContactViewHolder(LayoutInflater.from((Context)this.mContext).inflate(R.layout.ease_widget_contact_item, parent, false));
    }

    @Override
    public int getEmptyLayoutId() {
        if (this.emptyLayoutResource != 0) {
            return this.emptyLayoutResource;
        }
        return R.layout.ease_layout_no_data_show_nothing;
    }

    public void setSettingModel(EaseContactSetStyle settingModel) {
        this.contactSetModel = settingModel;
    }

    public void setEmptyLayoutResource(int emptyLayoutResource) {
        this.emptyLayoutResource = emptyLayoutResource;
    }

    private class ContactViewHolder
    extends EaseBaseRecyclerViewAdapter.ViewHolder<EaseUser> {
        private TextView mHeader;
        private EaseImageView mAvatar;
        private TextView mName;
        private TextView mSignature;
        private TextView mUnreadMsgNumber;
        private ConstraintLayout clUser;

        public ContactViewHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void initView(View itemView) {
            this.mHeader = (TextView)this.findViewById(R.id.header);
            this.mAvatar = (EaseImageView)((Object)this.findViewById(R.id.avatar));
            this.mName = (TextView)this.findViewById(R.id.name);
            this.mSignature = (TextView)this.findViewById(R.id.signature);
            this.mUnreadMsgNumber = (TextView)this.findViewById(R.id.unread_msg_number);
            this.clUser = (ConstraintLayout)this.findViewById(R.id.cl_user);
            EaseUserUtils.setUserAvatarStyle(this.mAvatar);
            if (EaseContactListAdapter.this.contactSetModel != null) {
                float itemHeight;
                int borderColor;
                float borderWidth;
                float avatarRadius;
                Drawable avatarDefaultSrc;
                int titleTextColor;
                float titleTextSize;
                Drawable headerBgDrawable;
                int headerTextColor;
                float headerTextSize = EaseContactListAdapter.this.contactSetModel.getHeaderTextSize();
                if (headerTextSize != 0.0f) {
                    this.mHeader.setTextSize(0, headerTextSize);
                }
                if ((headerTextColor = EaseContactListAdapter.this.contactSetModel.getHeaderTextColor()) != 0) {
                    this.mHeader.setTextColor(headerTextColor);
                }
                if ((headerBgDrawable = EaseContactListAdapter.this.contactSetModel.getHeaderBgDrawable()) != null) {
                    this.mHeader.setBackground(headerBgDrawable);
                }
                if ((titleTextSize = EaseContactListAdapter.this.contactSetModel.getTitleTextSize()) != 0.0f) {
                    this.mName.setTextSize(0, titleTextSize);
                }
                if ((titleTextColor = EaseContactListAdapter.this.contactSetModel.getTitleTextColor()) != 0) {
                    this.mName.setTextColor(titleTextColor);
                }
                if ((avatarDefaultSrc = EaseContactListAdapter.this.contactSetModel.getAvatarDefaultSrc()) != null) {
                    this.mAvatar.setImageDrawable(avatarDefaultSrc);
                }
                if ((avatarRadius = EaseContactListAdapter.this.contactSetModel.getAvatarRadius()) != 0.0f) {
                    this.mAvatar.setRadius((int)avatarRadius);
                }
                if ((borderWidth = EaseContactListAdapter.this.contactSetModel.getBorderWidth()) != 0.0f) {
                    this.mAvatar.setBorderWidth((int)borderWidth);
                }
                if ((borderColor = EaseContactListAdapter.this.contactSetModel.getBorderColor()) != 0) {
                    this.mAvatar.setBorderColor(borderColor);
                }
                this.mAvatar.setShapeType(EaseContactListAdapter.this.contactSetModel.getShapeType());
                float avatarSize = EaseContactListAdapter.this.contactSetModel.getAvatarSize();
                if (avatarSize != 0.0f) {
                    ViewGroup.LayoutParams mAvatarLayoutParams = this.mAvatar.getLayoutParams();
                    mAvatarLayoutParams.height = (int)avatarSize;
                    mAvatarLayoutParams.width = (int)avatarSize;
                }
                if ((itemHeight = EaseContactListAdapter.this.contactSetModel.getItemHeight()) != 0.0f) {
                    ViewGroup.LayoutParams userLayoutParams = this.clUser.getLayoutParams();
                    userLayoutParams.height = (int)itemHeight;
                }
                Drawable bgDrawable = EaseContactListAdapter.this.contactSetModel.getBgDrawable();
                this.clUser.setBackground(bgDrawable);
            }
        }

        @Override
        public void setData(EaseUser item, int position) {
            EaseUser user;
            EaseUserProfileProvider provider = EaseIM.getInstance().getUserProvider();
            if (provider != null && (user = provider.getUser(item.getUsername())) != null) {
                item = user;
            }
            String header = item.getInitialLetter();
            this.mHeader.setVisibility(8);
            if ((position == 0 || header != null && !header.equals(((EaseUser)EaseContactListAdapter.this.getItem(position - 1)).getInitialLetter())) && !TextUtils.isEmpty((CharSequence)header)) {
                this.mHeader.setVisibility(0);
                if (EaseContactListAdapter.this.contactSetModel != null) {
                    this.mHeader.setVisibility(EaseContactListAdapter.this.contactSetModel.isShowItemHeader() ? 0 : 8);
                }
                this.mHeader.setText((CharSequence)header);
            }
            this.mName.setText((CharSequence)item.getNickname());
            ((RequestBuilder)Glide.with((Context)EaseContactListAdapter.this.mContext).load(item.getAvatar()).error(EaseContactListAdapter.this.contactSetModel.getAvatarDefaultSrc() != null ? EaseContactListAdapter.this.contactSetModel.getAvatarDefaultSrc() : ContextCompat.getDrawable((Context)EaseContactListAdapter.this.mContext, (int)R.drawable.ease_default_avatar))).into((ImageView)this.mAvatar);
        }
    }
}

