/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.contact.adapter;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.bumptech.glide.Glide;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.modules.contact.model.EaseContactCustomBean;
import com.hyphenate.easeui.modules.contact.model.EaseContactSetStyle;
import com.hyphenate.easeui.widget.EaseImageView;

public class EaseContactCustomAdapter
extends EaseBaseRecyclerViewAdapter<EaseContactCustomBean> {
    private EaseContactSetStyle contactSetModel;

    @Override
    public EaseBaseRecyclerViewAdapter.ViewHolder getViewHolder(ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.ease_widget_contact_custom_item, parent, false);
        return new CustomViewHolder(view);
    }

    public void setSettingModel(EaseContactSetStyle settingModel) {
        this.contactSetModel = settingModel;
    }

    public void addItem(int id2, int image, String name) {
        EaseContactCustomBean bean = new EaseContactCustomBean();
        bean.setId(id2);
        bean.setResourceId(image);
        bean.setName(name);
        this.addData(bean);
    }

    public void addItem(int id2, String image, String name) {
        EaseContactCustomBean bean = new EaseContactCustomBean();
        bean.setId(id2);
        bean.setImage(image);
        bean.setName(name);
        this.addData(bean);
    }

    private class CustomViewHolder
    extends EaseBaseRecyclerViewAdapter.ViewHolder<EaseContactCustomBean> {
        private TextView mHeader;
        private EaseImageView mAvatar;
        private TextView mName;
        private ConstraintLayout clUser;

        public CustomViewHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void initView(View itemView) {
            this.mHeader = (TextView)this.findViewById(R.id.header);
            this.mAvatar = (EaseImageView)((Object)this.findViewById(R.id.avatar));
            this.mName = (TextView)this.findViewById(R.id.name);
            this.clUser = (ConstraintLayout)this.findViewById(R.id.cl_user);
            if (EaseContactCustomAdapter.this.contactSetModel != null) {
                float itemHeight;
                int borderColor;
                float borderWidth;
                float avatarRadius;
                Drawable avatarDefaultSrc;
                int titleTextColor;
                float titleTextSize = EaseContactCustomAdapter.this.contactSetModel.getTitleTextSize();
                if (titleTextSize != 0.0f) {
                    this.mName.setTextSize(0, titleTextSize);
                }
                if ((titleTextColor = EaseContactCustomAdapter.this.contactSetModel.getTitleTextColor()) != 0) {
                    this.mName.setTextColor(titleTextColor);
                }
                if ((avatarDefaultSrc = EaseContactCustomAdapter.this.contactSetModel.getAvatarDefaultSrc()) != null) {
                    this.mAvatar.setImageDrawable(avatarDefaultSrc);
                }
                if ((avatarRadius = EaseContactCustomAdapter.this.contactSetModel.getAvatarRadius()) != 0.0f) {
                    this.mAvatar.setRadius((int)avatarRadius);
                }
                if ((borderWidth = EaseContactCustomAdapter.this.contactSetModel.getBorderWidth()) != 0.0f) {
                    this.mAvatar.setBorderWidth((int)borderWidth);
                }
                if ((borderColor = EaseContactCustomAdapter.this.contactSetModel.getBorderColor()) != 0) {
                    this.mAvatar.setBorderColor(borderColor);
                }
                this.mAvatar.setShapeType(EaseContactCustomAdapter.this.contactSetModel.getShapeType());
                float avatarSize = EaseContactCustomAdapter.this.contactSetModel.getAvatarSize();
                if (avatarSize != 0.0f) {
                    ViewGroup.LayoutParams mAvatarLayoutParams = this.mAvatar.getLayoutParams();
                    mAvatarLayoutParams.height = (int)avatarSize;
                    mAvatarLayoutParams.width = (int)avatarSize;
                }
                if ((itemHeight = EaseContactCustomAdapter.this.contactSetModel.getItemHeight()) != 0.0f) {
                    ViewGroup.LayoutParams userLayoutParams = this.clUser.getLayoutParams();
                    userLayoutParams.height = (int)itemHeight;
                }
                Drawable bgDrawable = EaseContactCustomAdapter.this.contactSetModel.getBgDrawable();
                this.clUser.setBackground(bgDrawable);
            }
        }

        @Override
        public void setData(EaseContactCustomBean item, int position) {
            this.mHeader.setVisibility(8);
            this.mName.setText((CharSequence)item.getName());
            if (item.getResourceId() != 0) {
                this.mAvatar.setImageResource(item.getResourceId());
            } else if (TextUtils.isEmpty((CharSequence)item.getImage())) {
                Glide.with((Context)this.itemView.getContext()).load(item.getImage()).into((ImageView)this.mAvatar);
            }
        }
    }
}

