/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.contact;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.manager.SidebarPresenter;
import com.hyphenate.easeui.modules.contact.EaseContactListLayout;
import com.hyphenate.easeui.modules.contact.interfaces.IContactLayout;
import com.hyphenate.easeui.modules.contact.interfaces.OnContactLoadListener;
import com.hyphenate.easeui.widget.EaseSidebar;
import java.util.List;

public class EaseContactLayout
extends RelativeLayout
implements IContactLayout,
SwipeRefreshLayout.OnRefreshListener,
OnContactLoadListener {
    private SwipeRefreshLayout srlContactRefresh;
    private EaseContactListLayout contactList;
    private EaseSidebar sideBarContact;
    private TextView floatingHeader;
    private SidebarPresenter sidebarPresenter;
    private boolean canUseRefresh = true;

    public EaseContactLayout(Context context) {
        this(context, null);
    }

    public EaseContactLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseContactLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        LayoutInflater.from((Context)context).inflate(R.layout.ease_layout_contact, (ViewGroup)this);
        this.initViews();
        this.initListener();
    }

    private void initViews() {
        this.srlContactRefresh = (SwipeRefreshLayout)this.findViewById(R.id.srl_contact_refresh);
        this.contactList = (EaseContactListLayout)this.findViewById(R.id.contact_list);
        this.sideBarContact = (EaseSidebar)this.findViewById(R.id.side_bar_contact);
        this.floatingHeader = (TextView)this.findViewById(R.id.floating_header);
        this.srlContactRefresh.setEnabled(this.canUseRefresh);
        this.sidebarPresenter = new SidebarPresenter();
        this.sidebarPresenter.setupWithRecyclerView(this.contactList, this.contactList.getListAdapter(), this.floatingHeader);
        this.sideBarContact.setOnTouchEventListener(this.sidebarPresenter);
    }

    private void initListener() {
        this.srlContactRefresh.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.contactList.setOnContactLoadListener(this);
    }

    public void loadDefaultData() {
        this.contactList.loadDefaultData();
    }

    @Override
    public void showSimple() {
        this.contactList.showItemHeader(false);
        this.sideBarContact.setVisibility(8);
    }

    @Override
    public void showNormal() {
        this.contactList.showItemHeader(true);
        this.sideBarContact.setVisibility(0);
    }

    @Override
    public void canUseRefresh(boolean canUseRefresh) {
        this.canUseRefresh = canUseRefresh;
        this.srlContactRefresh.setEnabled(canUseRefresh);
    }

    @Override
    public EaseContactListLayout getContactList() {
        return this.contactList;
    }

    @Override
    public SwipeRefreshLayout getSwipeRefreshLayout() {
        return this.srlContactRefresh;
    }

    public void onRefresh() {
        this.contactList.loadDefaultData();
    }

    @Override
    public void loadDataFinish(List<EaseUser> data) {
        this.finishRefresh();
    }

    @Override
    public void loadDataFail(String message) {
        this.finishRefresh();
    }

    private void finishRefresh() {
        if (this.srlContactRefresh != null) {
            this.post(() -> this.srlContactRefresh.setRefreshing(false));
        }
    }
}

