/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat.presenter;

import android.text.TextUtils;
import com.hyphenate.EMValueCallBack;
import com.hyphenate.chat.EMChatRoom;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMCursorResult;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.modules.chat.presenter.EaseChatMessagePresenter;
import java.util.List;

public class EaseChatMessagePresenterImpl
extends EaseChatMessagePresenter {
    @Override
    public void joinChatRoom(String username) {
        EMClient.getInstance().chatroomManager().joinChatRoom(username, (EMValueCallBack)new EMValueCallBack<EMChatRoom>(){

            public void onSuccess(EMChatRoom value) {
                EaseChatMessagePresenterImpl.this.runOnUI(() -> {
                    if (EaseChatMessagePresenterImpl.this.isActive()) {
                        EaseChatMessagePresenterImpl.this.mView.joinChatRoomSuccess(value);
                    }
                });
            }

            public void onError(int error, String errorMsg) {
                EaseChatMessagePresenterImpl.this.runOnUI(() -> {
                    if (EaseChatMessagePresenterImpl.this.isActive()) {
                        EaseChatMessagePresenterImpl.this.mView.joinChatRoomFail(error, errorMsg);
                    }
                });
            }
        });
    }

    @Override
    public void loadLocalMessages(int pageSize) {
        if (this.conversation == null) {
            throw new NullPointerException("should first set up with conversation");
        }
        List messages = null;
        try {
            messages = this.conversation.loadMoreMsgFromDB(null, pageSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (messages == null || messages.isEmpty()) {
            if (this.isActive()) {
                this.runOnUI(() -> this.mView.loadNoLocalMsg());
            }
            return;
        }
        if (this.isActive()) {
            this.checkMessageStatus(messages);
            List finalMessages = messages;
            this.runOnUI(() -> this.mView.loadLocalMsgSuccess(finalMessages));
        }
    }

    @Override
    public void loadMoreLocalMessages(String msgId, int pageSize) {
        if (this.conversation == null) {
            throw new NullPointerException("should first set up with conversation");
        }
        if (!this.isMessageId(msgId)) {
            throw new IllegalArgumentException("please check if set correct msg id");
        }
        List moreMsgs = null;
        try {
            moreMsgs = this.conversation.loadMoreMsgFromDB(msgId, pageSize);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (moreMsgs == null || moreMsgs.isEmpty()) {
            if (this.isActive()) {
                this.runOnUI(() -> this.mView.loadNoMoreLocalMsg());
            }
            return;
        }
        if (this.isActive()) {
            this.checkMessageStatus(moreMsgs);
            List finalMoreMsgs = moreMsgs;
            this.runOnUI(() -> this.mView.loadMoreLocalMsgSuccess(finalMoreMsgs));
        }
    }

    @Override
    public void loadMoreLocalHistoryMessages(String msgId, int pageSize, EMConversation.EMSearchDirection direction) {
        if (this.conversation == null) {
            throw new NullPointerException("should first set up with conversation");
        }
        if (!this.isMessageId(msgId)) {
            throw new IllegalArgumentException("please check if set correct msg id");
        }
        EMMessage message = this.conversation.getMessage(msgId, true);
        List messages = this.conversation.searchMsgFromDB(message.getMsgTime() - 1L, pageSize, direction);
        if (this.isActive()) {
            this.runOnUI(() -> {
                if (messages == null || messages.isEmpty()) {
                    this.mView.loadNoMoreLocalHistoryMsg();
                } else {
                    this.mView.loadMoreLocalHistoryMsgSuccess(messages, direction);
                }
            });
        }
    }

    @Override
    public void loadServerMessages(final int pageSize) {
        if (this.conversation == null) {
            throw new NullPointerException("should first set up with conversation");
        }
        EMClient.getInstance().chatManager().asyncFetchHistoryMessage(this.conversation.conversationId(), this.conversation.getType(), pageSize, "", (EMValueCallBack)new EMValueCallBack<EMCursorResult<EMMessage>>(){

            public void onSuccess(EMCursorResult<EMMessage> value) {
                EaseChatMessagePresenterImpl.this.conversation.loadMoreMsgFromDB("", pageSize);
                EaseChatMessagePresenterImpl.this.runOnUI(() -> {
                    if (EaseChatMessagePresenterImpl.this.isActive()) {
                        EaseChatMessagePresenterImpl.this.mView.loadServerMsgSuccess((List)value.getData());
                    }
                });
            }

            public void onError(int error, String errorMsg) {
                EaseChatMessagePresenterImpl.this.runOnUI(() -> {
                    if (EaseChatMessagePresenterImpl.this.isActive()) {
                        EaseChatMessagePresenterImpl.this.mView.loadMsgFail(error, errorMsg);
                        EaseChatMessagePresenterImpl.this.loadLocalMessages(pageSize);
                    }
                });
            }
        });
    }

    @Override
    public void loadMoreServerMessages(final String msgId, final int pageSize) {
        if (this.conversation == null) {
            throw new NullPointerException("should first set up with conversation");
        }
        if (!this.isMessageId(msgId)) {
            throw new IllegalArgumentException("please check if set correct msg id");
        }
        EMClient.getInstance().chatManager().asyncFetchHistoryMessage(this.conversation.conversationId(), this.conversation.getType(), pageSize, msgId, (EMValueCallBack)new EMValueCallBack<EMCursorResult<EMMessage>>(){

            public void onSuccess(EMCursorResult<EMMessage> value) {
                EaseChatMessagePresenterImpl.this.conversation.loadMoreMsgFromDB(msgId, pageSize);
                EaseChatMessagePresenterImpl.this.runOnUI(() -> {
                    if (EaseChatMessagePresenterImpl.this.isActive()) {
                        EaseChatMessagePresenterImpl.this.mView.loadMoreServerMsgSuccess((List)value.getData());
                    }
                });
            }

            public void onError(int error, String errorMsg) {
                EaseChatMessagePresenterImpl.this.runOnUI(() -> {
                    if (EaseChatMessagePresenterImpl.this.isActive()) {
                        EaseChatMessagePresenterImpl.this.mView.loadMsgFail(error, errorMsg);
                        EaseChatMessagePresenterImpl.this.loadMoreLocalMessages(msgId, pageSize);
                    }
                });
            }
        });
    }

    @Override
    public void refreshCurrentConversation() {
        if (this.conversation == null) {
            throw new NullPointerException("should first set up with conversation");
        }
        this.conversation.markAllMessagesAsRead();
        List allMessages = this.conversation.getAllMessages();
        if (this.isActive()) {
            this.runOnUI(() -> this.mView.refreshCurrentConSuccess(allMessages, false));
        }
    }

    @Override
    public void refreshToLatest() {
        if (this.conversation == null) {
            throw new NullPointerException("should first set up with conversation");
        }
        this.conversation.markAllMessagesAsRead();
        List allMessages = this.conversation.getAllMessages();
        if (this.isActive()) {
            this.runOnUI(() -> this.mView.refreshCurrentConSuccess(allMessages, true));
        }
    }

    public boolean isMessageId(String msgId) {
        if (TextUtils.isEmpty((CharSequence)msgId)) {
            return true;
        }
        EMMessage message = this.conversation.getMessage(msgId, true);
        return message != null;
    }

    private void checkMessageStatus(List<EMMessage> messages) {
        if (messages == null || messages.isEmpty()) {
            return;
        }
        for (EMMessage message : messages) {
            if (message.status() == EMMessage.Status.SUCCESS || message.status() == EMMessage.Status.FAIL) continue;
            message.setStatus(EMMessage.Status.FAIL);
        }
    }
}

