/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.adapter;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseBaseChatExtendMenuAdapter;
import com.hyphenate.easeui.interfaces.OnItemClickListener;
import com.hyphenate.easeui.modules.chat.EaseChatExtendMenu;

public class EaseChatExtendMenuAdapter
extends EaseBaseChatExtendMenuAdapter<ViewHolder, EaseChatExtendMenu.ChatMenuItemModel> {
    private OnItemClickListener itemListener;

    @Override
    protected int getItemLayoutId() {
        return R.layout.ease_chat_menu_item;
    }

    @Override
    protected ViewHolder easeCreateViewHolder(View view) {
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, final int position) {
        final EaseChatExtendMenu.ChatMenuItemModel item = (EaseChatExtendMenu.ChatMenuItemModel)this.mData.get(position);
        holder.imageView.setBackgroundResource(item.image);
        holder.textView.setText((CharSequence)item.name);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (item.clickListener != null) {
                    item.clickListener.onChatExtendMenuItemClick(item.id, v);
                }
                if (EaseChatExtendMenuAdapter.this.itemListener != null) {
                    EaseChatExtendMenuAdapter.this.itemListener.onItemClick(v, position);
                }
            }
        });
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.itemListener = listener;
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private ImageView imageView;
        private TextView textView;

        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            this.imageView = (ImageView)itemView.findViewById(R.id.image);
            this.textView = (TextView)itemView.findViewById(R.id.text);
        }
    }
}

