/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.viewholder;

import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMNormalFileMessageBody;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.ui.EaseShowNormalFileActivity;
import com.hyphenate.easeui.utils.EaseCompat;
import com.hyphenate.easeui.utils.EaseFileUtils;
import com.hyphenate.easeui.viewholder.EaseChatRowViewHolder;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowFile;
import com.hyphenate.exceptions.HyphenateException;

public class EaseFileViewHolder
extends EaseChatRowViewHolder {
    public EaseFileViewHolder(@NonNull View itemView, MessageListItemClickListener itemClickListener) {
        super(itemView, itemClickListener);
    }

    public static EaseChatRowViewHolder create(ViewGroup parent, boolean isSender, MessageListItemClickListener itemClickListener) {
        return new EaseFileViewHolder((View)new EaseChatRowFile(parent.getContext(), isSender), itemClickListener);
    }

    @Override
    public void onBubbleClick(EMMessage message) {
        super.onBubbleClick(message);
        EMNormalFileMessageBody fileMessageBody = (EMNormalFileMessageBody)message.getBody();
        Uri filePath = fileMessageBody.getLocalUri();
        EaseFileUtils.takePersistableUriPermission(this.getContext(), filePath);
        if (EaseFileUtils.isFileExistByUri(this.getContext(), filePath)) {
            EaseCompat.openFile(this.getContext(), filePath);
        } else {
            this.getContext().startActivity(new Intent(this.getContext(), EaseShowNormalFileActivity.class).putExtra("msg", (Parcelable)message));
        }
        if (message.direct() == EMMessage.Direct.RECEIVE && !message.isAcked() && message.getChatType() == EMMessage.ChatType.Chat) {
            try {
                EMClient.getInstance().chatManager().ackMessageRead(message.getFrom(), message.getMsgId());
            }
            catch (HyphenateException e) {
                e.printStackTrace();
            }
        }
    }
}

