/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.ui;

import android.content.Context;
import android.os.Bundle;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.hyphenate.EMCallBack;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.ui.base.EaseBaseActivity;
import com.hyphenate.easeui.utils.EaseCompat;

public class EaseShowNormalFileActivity
extends EaseBaseActivity {
    private static final String TAG = EaseShowNormalFileActivity.class.getSimpleName();
    private ProgressBar progressBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.ease_activity_show_file);
        this.setFitSystemForTheme(true, R.color.transparent, true);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        final EMMessage message = (EMMessage)this.getIntent().getParcelableExtra("msg");
        if (!(message.getBody() instanceof EMFileMessageBody)) {
            Toast.makeText((Context)this, (CharSequence)this.getApplicationContext().getString(R.string.unsupported_message_body), (int)0).show();
            this.finish();
            return;
        }
        message.setMessageStatusCallback(new EMCallBack(){

            public void onSuccess() {
                EaseShowNormalFileActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        EaseCompat.openFile((Context)EaseShowNormalFileActivity.this, ((EMFileMessageBody)message.getBody()).getLocalUri());
                        EaseShowNormalFileActivity.this.finish();
                    }
                });
            }

            public void onError(final int code, String error) {
                EaseShowNormalFileActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        EaseCompat.deleteFile((Context)EaseShowNormalFileActivity.this, ((EMFileMessageBody)message.getBody()).getLocalUri());
                        String str4 = EaseShowNormalFileActivity.this.getResources().getString(R.string.Failed_to_download_file);
                        if (code == 400) {
                            str4 = EaseShowNormalFileActivity.this.getResources().getString(R.string.File_expired);
                        }
                        Toast.makeText((Context)EaseShowNormalFileActivity.this.getApplicationContext(), (CharSequence)(str4 + message), (int)0).show();
                        EaseShowNormalFileActivity.this.finish();
                    }
                });
            }

            public void onProgress(final int progress, String status) {
                EaseShowNormalFileActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        EaseShowNormalFileActivity.this.progressBar.setProgress(progress);
                    }
                });
            }
        });
        EMClient.getInstance().chatManager().downloadAttachment(message);
    }
}

