/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.conversation.delegate;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.adapter.EaseBaseRecyclerViewAdapter;
import com.hyphenate.easeui.modules.conversation.delegate.EaseBaseConversationDelegate;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationInfo;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationSetStyle;
import com.hyphenate.easeui.utils.EaseUserUtils;
import com.hyphenate.easeui.widget.EaseImageView;

public abstract class EaseDefaultConversationDelegate
extends EaseBaseConversationDelegate<EaseConversationInfo, ViewHolder> {
    public EaseDefaultConversationDelegate(EaseConversationSetStyle setModel) {
        super(setModel);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup parent, String tag) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ease_item_row_chat_history, parent, false);
        return new ViewHolder(view, this.setModel);
    }

    @Override
    public void onBindViewHolder(ViewHolder holder, int position, EaseConversationInfo item) {
        super.onBindViewHolder(holder, position, item);
        this.onBindConViewHolder(holder, position, item);
    }

    protected abstract void onBindConViewHolder(ViewHolder var1, int var2, EaseConversationInfo var3);

    public void showUnreadNum(ViewHolder holder, int unreadMsgCount) {
        if (unreadMsgCount > 0) {
            holder.mUnreadMsgNumber.setText((CharSequence)this.handleBigNum(unreadMsgCount));
            holder.unreadMsgNumberRight.setText((CharSequence)this.handleBigNum(unreadMsgCount));
            this.showUnreadRight(holder, this.setModel.getUnreadDotPosition() == EaseConversationSetStyle.UnreadDotPosition.RIGHT);
        } else {
            holder.mUnreadMsgNumber.setVisibility(8);
            holder.unreadMsgNumberRight.setVisibility(8);
        }
    }

    public String handleBigNum(int unreadMsgCount) {
        if (unreadMsgCount <= 99) {
            return String.valueOf(unreadMsgCount);
        }
        return "99+";
    }

    public void showUnreadRight(ViewHolder holder, boolean isRight) {
        if (isRight) {
            holder.mUnreadMsgNumber.setVisibility(8);
            holder.unreadMsgNumberRight.setVisibility(0);
        } else {
            holder.mUnreadMsgNumber.setVisibility(0);
            holder.unreadMsgNumberRight.setVisibility(8);
        }
    }

    public static class ViewHolder
    extends EaseBaseRecyclerViewAdapter.ViewHolder<EaseConversationInfo> {
        public ConstraintLayout listIteaseLayout;
        public EaseImageView avatar;
        public TextView mUnreadMsgNumber;
        public TextView unreadMsgNumberRight;
        public TextView name;
        public TextView time;
        public ImageView mMsgState;
        public TextView mentioned;
        public TextView message;
        public Context mContext;
        private final Drawable bgDrawable;

        public ViewHolder(@NonNull View itemView, EaseConversationSetStyle setModel) {
            super(itemView);
            this.mContext = itemView.getContext();
            this.listIteaseLayout = (ConstraintLayout)this.findViewById(R.id.list_itease_layout);
            this.avatar = (EaseImageView)((Object)this.findViewById(R.id.avatar));
            this.mUnreadMsgNumber = (TextView)this.findViewById(R.id.unread_msg_number);
            this.unreadMsgNumberRight = (TextView)this.findViewById(R.id.unread_msg_number_right);
            this.name = (TextView)this.findViewById(R.id.name);
            this.time = (TextView)this.findViewById(R.id.time);
            this.mMsgState = (ImageView)this.findViewById(R.id.msg_state);
            this.mentioned = (TextView)this.findViewById(R.id.mentioned);
            this.message = (TextView)this.findViewById(R.id.message);
            EaseUserUtils.setUserAvatarStyle(this.avatar);
            if (setModel != null) {
                Drawable bgDrawable;
                float itemHeight;
                float avatarRadius;
                int borderColor;
                float avatarSize;
                int mentionTextColor;
                float mentionTextSize;
                int dateTextColor;
                float dateTextSize;
                int contentTextColor;
                float contentTextSize;
                int titleTextColor;
                float titleTextSize = setModel.getTitleTextSize();
                if (titleTextSize != 0.0f) {
                    this.name.setTextSize(0, titleTextSize);
                }
                if ((titleTextColor = setModel.getTitleTextColor()) != 0) {
                    this.name.setTextColor(titleTextColor);
                }
                if ((contentTextSize = setModel.getContentTextSize()) != 0.0f) {
                    this.message.setTextSize(0, contentTextSize);
                }
                if ((contentTextColor = setModel.getContentTextColor()) != 0) {
                    this.message.setTextColor(contentTextColor);
                }
                if ((dateTextSize = setModel.getDateTextSize()) != 0.0f) {
                    this.time.setTextSize(0, dateTextSize);
                }
                if ((dateTextColor = setModel.getDateTextColor()) != 0) {
                    this.time.setTextColor(dateTextColor);
                }
                if ((mentionTextSize = setModel.getMentionTextSize()) != 0.0f) {
                    this.mentioned.setTextSize(0, mentionTextSize);
                }
                if ((mentionTextColor = setModel.getMentionTextColor()) != 0) {
                    this.mentioned.setTextColor(mentionTextColor);
                }
                if ((avatarSize = setModel.getAvatarSize()) != 0.0f) {
                    ViewGroup.LayoutParams layoutParams = this.avatar.getLayoutParams();
                    layoutParams.height = (int)avatarSize;
                    layoutParams.width = (int)avatarSize;
                }
                this.avatar.setShapeType(setModel.getShapeType());
                float borderWidth = setModel.getBorderWidth();
                if (borderWidth != 0.0f) {
                    this.avatar.setBorderWidth((int)borderWidth);
                }
                if ((borderColor = setModel.getBorderColor()) != 0) {
                    this.avatar.setBorderColor(borderColor);
                }
                if ((avatarRadius = setModel.getAvatarRadius()) != 0.0f) {
                    this.avatar.setRadius((int)avatarRadius);
                }
                if ((itemHeight = setModel.getItemHeight()) != 0.0f) {
                    ViewGroup.LayoutParams layoutParams = itemView.getLayoutParams();
                    layoutParams.height = (int)itemHeight;
                }
                if ((bgDrawable = setModel.getBgDrawable()) != null) {
                    itemView.setBackground(bgDrawable);
                }
                this.mUnreadMsgNumber.setVisibility(setModel.isHideUnreadDot() ? 8 : 0);
                EaseConversationSetStyle.UnreadDotPosition dotPosition = setModel.getUnreadDotPosition();
                if (dotPosition == EaseConversationSetStyle.UnreadDotPosition.LEFT) {
                    this.mUnreadMsgNumber.setVisibility(0);
                    this.unreadMsgNumberRight.setVisibility(8);
                } else {
                    this.mUnreadMsgNumber.setVisibility(8);
                    this.unreadMsgNumberRight.setVisibility(0);
                }
            }
            this.bgDrawable = itemView.getBackground();
        }

        @Override
        public void initView(View itemView) {
        }

        @Override
        public void setData(final EaseConversationInfo item, int position) {
            item.setOnSelectListener(new EaseConversationInfo.OnSelectListener(){

                @Override
                public void onSelect(boolean isSelected) {
                    if (isSelected) {
                        itemView.setBackgroundResource(R.drawable.ease_conversation_item_selected);
                    } else if (item.isTop()) {
                        itemView.setBackgroundResource(R.drawable.ease_conversation_top_bg);
                    } else {
                        itemView.setBackground(bgDrawable);
                    }
                }
            });
        }
    }
}

