/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.os.Handler;
import android.os.Looper;
import com.hyphenate.easeui.manager.BackgroundThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class EaseThreadManager {
    private static volatile EaseThreadManager instance;
    private Executor mIOThreadExecutor;
    private Handler mMainThreadHandler;

    private EaseThreadManager() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EaseThreadManager getInstance() {
        if (instance != null) return instance;
        Class<EaseThreadManager> clazz = EaseThreadManager.class;
        synchronized (EaseThreadManager.class) {
            if (instance != null) return instance;
            instance = new EaseThreadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void init() {
        int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
        int KEEP_ALIVE_TIME = 1;
        TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
        LinkedBlockingDeque<Runnable> taskQueue = new LinkedBlockingDeque<Runnable>();
        this.mIOThreadExecutor = new ThreadPoolExecutor(NUMBER_OF_CORES, NUMBER_OF_CORES * 2, (long)KEEP_ALIVE_TIME, KEEP_ALIVE_TIME_UNIT, taskQueue, new BackgroundThreadFactory(10));
        this.mMainThreadHandler = new Handler(Looper.getMainLooper());
    }

    public void runOnIOThread(Runnable runnable) {
        this.mIOThreadExecutor.execute(runnable);
    }

    public void runOnMainThread(Runnable runnable) {
        this.mMainThreadHandler.post(runnable);
    }

    public boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }
}

