/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.delegate;

import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.adapter.EaseAdapterDelegate;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.model.styles.EaseMessageListItemStyle;
import com.hyphenate.easeui.viewholder.EaseChatRowViewHolder;
import com.hyphenate.easeui.widget.chatrow.EaseChatRow;

public abstract class EaseMessageAdapterDelegate<T, VH extends EaseChatRowViewHolder>
extends EaseAdapterDelegate<T, VH> {
    private MessageListItemClickListener mItemClickListener;

    public EaseMessageAdapterDelegate() {
    }

    public EaseMessageAdapterDelegate(MessageListItemClickListener itemClickListener) {
        this();
        this.mItemClickListener = itemClickListener;
    }

    public EaseMessageAdapterDelegate(MessageListItemClickListener itemClickListener, EaseMessageListItemStyle itemStyle) {
        this(itemClickListener);
    }

    public EaseMessageListItemStyle createDefaultItemStyle() {
        EaseMessageListItemStyle.Builder builder = new EaseMessageListItemStyle.Builder();
        builder.showAvatar(true).showUserNick(false);
        return builder.build();
    }

    @Override
    public VH onCreateViewHolder(ViewGroup parent, String tag) {
        EaseChatRow view = this.getEaseChatRow(parent, this.isSender(tag));
        return this.createViewHolder((View)view, this.mItemClickListener);
    }

    private boolean isSender(String tag) {
        return !TextUtils.isEmpty((CharSequence)tag) && TextUtils.equals((CharSequence)tag, (CharSequence)EMMessage.Direct.SEND.toString());
    }

    protected abstract EaseChatRow getEaseChatRow(ViewGroup var1, boolean var2);

    protected abstract VH createViewHolder(View var1, MessageListItemClickListener var2);

    public void setListItemClickListener(MessageListItemClickListener itemClickListener) {
        this.mItemClickListener = itemClickListener;
    }
}

