/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget.chatrow;

import android.content.Context;
import android.text.Spannable;
import android.view.ViewGroup;
import android.widget.TextView;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMTextMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.manager.EaseDingMessageHelper;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import com.hyphenate.easeui.widget.chatrow.EaseChatRow;

public class EaseChatRowText
extends EaseChatRow {
    private TextView contentView;
    private EaseDingMessageHelper.IAckUserUpdateListener userUpdateListener = list -> this.onAckUserUpdate(list.size());

    public EaseChatRowText(Context context, boolean isSender) {
        super(context, isSender);
    }

    public EaseChatRowText(Context context, EMMessage message, int position, Object adapter) {
        super(context, message, position, adapter);
    }

    @Override
    protected void onInflateView() {
        this.inflater.inflate(!this.showSenderType ? R.layout.ease_row_received_message : R.layout.ease_row_sent_message, (ViewGroup)this);
    }

    @Override
    protected void onFindViewById() {
        this.contentView = (TextView)this.findViewById(R.id.tv_chatcontent);
    }

    @Override
    public void onSetUpView() {
        EMTextMessageBody txtBody = (EMTextMessageBody)this.message.getBody();
        Spannable span = EaseSmileUtils.getSmiledText(this.context, txtBody.getMessage());
        this.contentView.setText((CharSequence)span, TextView.BufferType.SPANNABLE);
    }

    @Override
    protected void onMessageCreate() {
        this.setStatus(0, 8);
    }

    @Override
    protected void onMessageSuccess() {
        this.setStatus(8, 8);
        if (this.isSender() && EaseDingMessageHelper.get().isDingMessage(this.message) && this.ackedView != null) {
            this.ackedView.setVisibility(0);
            int count = this.message.groupAckCount();
            this.ackedView.setText((CharSequence)String.format(this.getContext().getString(R.string.group_ack_read_count), count));
        }
        EaseDingMessageHelper.get().setUserUpdateListener(this.message, this.userUpdateListener);
    }

    @Override
    protected void onMessageError() {
        this.setStatus(8, 0);
    }

    @Override
    protected void onMessageInProgress() {
        this.setStatus(0, 8);
    }

    private void setStatus(int progressVisible, int statusVisible) {
        if (this.progressBar != null) {
            this.progressBar.setVisibility(progressVisible);
        }
        if (this.statusView != null) {
            this.statusView.setVisibility(statusVisible);
        }
    }

    public void onAckUserUpdate(int count) {
        if (this.ackedView == null) {
            return;
        }
        this.ackedView.post(() -> {
            if (this.isSender()) {
                this.ackedView.setVisibility(0);
                this.ackedView.setText((CharSequence)String.format(this.getContext().getString(R.string.group_ack_read_count), count));
            }
        });
    }
}

