/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import java.util.ArrayList;
import java.util.List;

public class EaseRecyclerView
extends RecyclerView {
    private static final int BASE_HEADER_VIEW_TYPE = -1024;
    private static final int BASE_FOOTER_VIEW_TYPE = -2048;
    private RecyclerViewContextMenuInfo mContextMenuInfo;
    private List<FixedViewInfo> mHeaderViewInfos = new ArrayList<FixedViewInfo>();
    private List<FixedViewInfo> mFooterViewInfos = new ArrayList<FixedViewInfo>();
    private RecyclerView.Adapter mAdapter;
    private boolean isStaggered;
    private boolean isShouldSpan;
    private RecyclerView.AdapterDataObserver mObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            EaseRecyclerView.this.mAdapter.notifyDataSetChanged();
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            EaseRecyclerView.this.mAdapter.notifyItemRangeChanged(positionStart += EaseRecyclerView.this.getHeadersCount(), itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            EaseRecyclerView.this.mAdapter.notifyItemRangeChanged(positionStart += EaseRecyclerView.this.getHeadersCount(), itemCount, payload);
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            EaseRecyclerView.this.mAdapter.notifyItemRangeInserted(positionStart += EaseRecyclerView.this.getHeadersCount(), itemCount);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            EaseRecyclerView.this.mAdapter.notifyItemRangeRemoved(positionStart += EaseRecyclerView.this.getHeadersCount(), itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            EaseRecyclerView.this.mAdapter.notifyItemMoved(fromPosition += EaseRecyclerView.this.getHeadersCount(), toPosition += EaseRecyclerView.this.getHeadersCount());
        }
    };

    public EaseRecyclerView(@NonNull Context context) {
        super(context);
    }

    public EaseRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public EaseRecyclerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void addHeaderView(View view) {
        FixedViewInfo info = new FixedViewInfo();
        info.view = view;
        info.viewType = -1024 + this.mHeaderViewInfos.size();
        this.mHeaderViewInfos.add(info);
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void removeHeaderViews() {
        if (this.mHeaderViewInfos != null) {
            this.mHeaderViewInfos.clear();
        }
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void addFooterView(View view) {
        FixedViewInfo info = new FixedViewInfo();
        info.view = view;
        info.viewType = -2048 + this.mFooterViewInfos.size();
        this.mFooterViewInfos.add(info);
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void setAdapter(@Nullable RecyclerView.Adapter adapter) {
        if (!(adapter instanceof WrapperRecyclerViewAdapter)) {
            if (adapter != null) {
                adapter.registerAdapterDataObserver(this.mObserver);
            }
            this.mAdapter = new WrapperRecyclerViewAdapter(adapter);
        }
        super.setAdapter(this.mAdapter);
        if (this.isShouldSpan) {
            ((WrapperRecyclerViewAdapter)this.mAdapter).adjustSpanSize(this);
        }
    }

    public void setLayoutManager(@Nullable RecyclerView.LayoutManager layout2) {
        if (layout2 instanceof GridLayoutManager || layout2 instanceof StaggeredGridLayoutManager) {
            this.isShouldSpan = true;
        }
        super.setLayoutManager(layout2);
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getChildBindingAdapterPosition(originalView);
        if (longPressPosition >= 0) {
            long longPressId = this.getAdapter().getItemId(longPressPosition);
            this.mContextMenuInfo = new RecyclerViewContextMenuInfo(longPressPosition, longPressId);
            return super.showContextMenuForChild(originalView);
        }
        return false;
    }

    public int getChildBindingAdapterPosition(@NonNull View child) {
        RecyclerView.ViewHolder holder = this.getChildViewHolderInt(child);
        return holder != null ? holder.getBindingAdapterPosition() : -1;
    }

    RecyclerView.ViewHolder getChildViewHolderInt(View child) {
        if (child == null) {
            return null;
        }
        return this.getChildViewHolder(child);
    }

    public RecyclerView.ViewHolder getChildViewHolder(@NonNull View child) {
        return super.getChildViewHolder(child);
    }

    public int getFootersCount() {
        return this.mFooterViewInfos.size();
    }

    public int getHeadersCount() {
        return this.mHeaderViewInfos.size();
    }

    private RecyclerView.ViewHolder viewHolder(View itemView) {
        if (this.isStaggered) {
            StaggeredGridLayoutManager.LayoutParams params = new StaggeredGridLayoutManager.LayoutParams(-1, -2);
            params.setFullSpan(true);
            itemView.setLayoutParams((ViewGroup.LayoutParams)params);
        }
        return new ViewHolder(itemView);
    }

    public static class RecyclerViewContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public int position;
        public long id;

        public RecyclerViewContextMenuInfo(int position, long id2) {
            this.position = position;
            this.id = id2;
        }
    }

    static class ViewHolder
    extends RecyclerView.ViewHolder {
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
        }
    }

    public class WrapperRecyclerViewAdapter
    extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
        private RecyclerView.Adapter mAdapter;

        public WrapperRecyclerViewAdapter(RecyclerView.Adapter adapter) {
            this.mAdapter = adapter;
        }

        @NonNull
        public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
            if (viewType >= -1024 && viewType < -1024 + EaseRecyclerView.this.getHeadersCount()) {
                View view = ((FixedViewInfo)((EaseRecyclerView)EaseRecyclerView.this).mHeaderViewInfos.get((int)(viewType - -1024))).view;
                return EaseRecyclerView.this.viewHolder(view);
            }
            if (viewType >= -2048 && viewType < -2048 + EaseRecyclerView.this.getFootersCount()) {
                View view = ((FixedViewInfo)((EaseRecyclerView)EaseRecyclerView.this).mFooterViewInfos.get((int)(viewType - -2048))).view;
                return EaseRecyclerView.this.viewHolder(view);
            }
            return this.mAdapter.onCreateViewHolder(parent, viewType);
        }

        public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
            if (this.isHeaderOrFooter(holder)) {
                return;
            }
            this.mAdapter.onBindViewHolder(holder, position -= EaseRecyclerView.this.getHeadersCount());
        }

        public int findRelativeAdapterPositionIn(@NonNull RecyclerView.Adapter<? extends RecyclerView.ViewHolder> adapter, @NonNull RecyclerView.ViewHolder viewHolder, int localPosition) {
            if (adapter == this) {
                return localPosition;
            }
            if (this.mAdapter instanceof ConcatAdapter) {
                List adapters = ((ConcatAdapter)this.mAdapter).getAdapters();
                int prePosition = 0;
                for (int i = 0; i < adapters.size(); ++i) {
                    RecyclerView.Adapter curAdapter = (RecyclerView.Adapter)adapters.get(i);
                    if (curAdapter == adapter) {
                        return localPosition - prePosition;
                    }
                    prePosition += curAdapter.getItemCount();
                }
                return -1;
            }
            return super.findRelativeAdapterPositionIn(adapter, viewHolder, localPosition);
        }

        public long getItemId(int position) {
            if (this.isHeaderOrFooter(position)) {
                return -1L;
            }
            return this.mAdapter.getItemId(position -= EaseRecyclerView.this.getHeadersCount());
        }

        public int getItemCount() {
            return EaseRecyclerView.this.getHeadersCount() + EaseRecyclerView.this.getFootersCount() + this.getContentCount();
        }

        public int getItemViewType(int position) {
            if (this.isHeader(position)) {
                return ((FixedViewInfo)((EaseRecyclerView)EaseRecyclerView.this).mHeaderViewInfos.get((int)position)).viewType;
            }
            if (this.isFooter(position)) {
                return ((FixedViewInfo)((EaseRecyclerView)EaseRecyclerView.this).mFooterViewInfos.get((int)(position - EaseRecyclerView.this.getHeadersCount() - this.getContentCount()))).viewType;
            }
            return this.mAdapter.getItemViewType(position - EaseRecyclerView.this.getHeadersCount());
        }

        public int getContentCount() {
            return this.mAdapter == null ? 0 : this.mAdapter.getItemCount();
        }

        public boolean isHeader(int position) {
            return position < EaseRecyclerView.this.getHeadersCount();
        }

        public boolean isFooter(int position) {
            return position >= EaseRecyclerView.this.getHeadersCount() + this.getContentCount();
        }

        public boolean isHeaderOrFooter(RecyclerView.ViewHolder holder) {
            return holder instanceof ViewHolder || this.isHeaderOrFooter(holder.getAdapterPosition());
        }

        public boolean isHeaderOrFooter(int position) {
            return this.isHeader(position) || this.isFooter(position);
        }

        public void adjustSpanSize(RecyclerView recyclerView) {
            if (recyclerView.getLayoutManager() instanceof GridLayoutManager) {
                final GridLayoutManager manager = (GridLayoutManager)recyclerView.getLayoutManager();
                manager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                    public int getSpanSize(int position) {
                        int headersCount = EaseRecyclerView.this.getHeadersCount();
                        int adjPosition = position - headersCount;
                        if (position < headersCount || adjPosition >= WrapperRecyclerViewAdapter.this.mAdapter.getItemCount()) {
                            return manager.getSpanCount();
                        }
                        return 1;
                    }
                });
            }
            if (recyclerView.getLayoutManager() instanceof StaggeredGridLayoutManager) {
                EaseRecyclerView.this.isStaggered = true;
            }
        }

        public RecyclerView.Adapter getAdapter() {
            return this.mAdapter;
        }
    }

    public class FixedViewInfo {
        public View view;
        public int viewType;
    }
}

