/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.viewholder;

import android.content.Context;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.chat.EMVoiceMessageBody;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.viewholder.EaseChatRowViewHolder;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowVoice;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowVoicePlayer;
import com.hyphenate.exceptions.HyphenateException;
import com.hyphenate.util.EMLog;
import java.io.File;

public class EaseVoiceViewHolder
extends EaseChatRowViewHolder {
    private EaseChatRowVoicePlayer voicePlayer = EaseChatRowVoicePlayer.getInstance(this.getContext());

    public EaseVoiceViewHolder(@NonNull View itemView, MessageListItemClickListener itemClickListener) {
        super(itemView, itemClickListener);
    }

    public static EaseChatRowViewHolder create(ViewGroup parent, boolean isSender, MessageListItemClickListener itemClickListener) {
        return new EaseVoiceViewHolder((View)new EaseChatRowVoice(parent.getContext(), isSender), itemClickListener);
    }

    @Override
    public void onBubbleClick(EMMessage message) {
        super.onBubbleClick(message);
        String msgId = message.getMsgId();
        if (this.voicePlayer.isPlaying()) {
            this.voicePlayer.stop();
            ((EaseChatRowVoice)this.getChatRow()).stopVoicePlayAnimation();
            String playingId = this.voicePlayer.getCurrentPlayingId();
            if (msgId.equals(playingId)) {
                return;
            }
        }
        if (message.direct() == EMMessage.Direct.SEND) {
            String localPath = ((EMVoiceMessageBody)message.getBody()).getLocalUrl();
            File file = new File(localPath);
            if (file.exists() && file.isFile()) {
                this.playVoice(message);
                ((EaseChatRowVoice)this.getChatRow()).startVoicePlayAnimation();
            } else {
                this.asyncDownloadVoice(message);
            }
        } else {
            String st = this.getContext().getResources().getString(R.string.Is_download_voice_click_later);
            if (message.status() == EMMessage.Status.SUCCESS) {
                if (EMClient.getInstance().getOptions().getAutodownloadThumbnail()) {
                    this.play(message);
                } else {
                    EMVoiceMessageBody voiceBody = (EMVoiceMessageBody)message.getBody();
                    EMLog.i((String)"EMClient", (String)("Voice body download status: " + voiceBody.downloadStatus()));
                    switch (voiceBody.downloadStatus()) {
                        case PENDING: 
                        case FAILED: {
                            this.getChatRow().updateView(message);
                            this.asyncDownloadVoice(message);
                            break;
                        }
                        case DOWNLOADING: {
                            Toast.makeText((Context)this.getContext(), (CharSequence)st, (int)0).show();
                            break;
                        }
                        case SUCCESSED: {
                            this.play(message);
                        }
                    }
                }
            } else if (message.status() == EMMessage.Status.INPROGRESS) {
                Toast.makeText((Context)this.getContext(), (CharSequence)st, (int)0).show();
            } else if (message.status() == EMMessage.Status.FAIL) {
                Toast.makeText((Context)this.getContext(), (CharSequence)st, (int)0).show();
                this.asyncDownloadVoice(message);
            }
        }
    }

    private void playVoice(EMMessage msg) {
        this.voicePlayer.play(msg, new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                ((EaseChatRowVoice)EaseVoiceViewHolder.this.getChatRow()).stopVoicePlayAnimation();
            }
        });
    }

    private void asyncDownloadVoice(final EMMessage message) {
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                EMClient.getInstance().chatManager().downloadAttachment(message);
                return null;
            }

            protected void onPostExecute(Void result) {
                super.onPostExecute((Object)result);
                EaseVoiceViewHolder.this.getChatRow().updateView(message);
            }
        }.execute((Object[])new Void[0]);
    }

    private void play(EMMessage message) {
        String localPath = ((EMVoiceMessageBody)message.getBody()).getLocalUrl();
        File file = new File(localPath);
        if (file.exists() && file.isFile()) {
            this.ackMessage(message);
            this.playVoice(message);
            ((EaseChatRowVoice)this.getChatRow()).startVoicePlayAnimation();
        } else {
            EMLog.e((String)"EMClient", (String)"file not exist");
        }
    }

    private void ackMessage(EMMessage message) {
        EMMessage.ChatType chatType = message.getChatType();
        if (!message.isAcked() && chatType == EMMessage.ChatType.Chat) {
            try {
                EMClient.getInstance().chatManager().ackMessageRead(message.getFrom(), message.getMsgId());
            }
            catch (HyphenateException e) {
                e.printStackTrace();
            }
        }
        if (!message.isListened()) {
            EMClient.getInstance().chatManager().setVoiceMessageListened(message);
        }
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.voicePlayer.isPlaying()) {
            this.voicePlayer.stop();
        }
    }
}

