/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.viewholder;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMFileMessageBody;
import com.hyphenate.chat.EMImageMessageBody;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.interfaces.MessageListItemClickListener;
import com.hyphenate.easeui.ui.EaseShowBigImageActivity;
import com.hyphenate.easeui.viewholder.EaseChatRowViewHolder;
import com.hyphenate.easeui.widget.chatrow.EaseChatRowImage;
import com.hyphenate.util.UriUtils;

public class EaseImageViewHolder
extends EaseChatRowViewHolder {
    public EaseImageViewHolder(@NonNull View itemView, MessageListItemClickListener itemClickListener) {
        super(itemView, itemClickListener);
    }

    public static EaseChatRowViewHolder create(ViewGroup parent, boolean isSender, MessageListItemClickListener itemClickListener) {
        return new EaseImageViewHolder((View)new EaseChatRowImage(parent.getContext(), isSender), itemClickListener);
    }

    @Override
    public void onBubbleClick(EMMessage message) {
        super.onBubbleClick(message);
        EMImageMessageBody imgBody = (EMImageMessageBody)message.getBody();
        if (EMClient.getInstance().getOptions().getAutodownloadThumbnail()) {
            if (imgBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.FAILED) {
                this.getChatRow().updateView(message);
                EMClient.getInstance().chatManager().downloadThumbnail(message);
            }
        } else if (imgBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.DOWNLOADING || imgBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.PENDING || imgBody.thumbnailDownloadStatus() == EMFileMessageBody.EMDownloadStatus.FAILED) {
            EMClient.getInstance().chatManager().downloadThumbnail(message);
            this.getChatRow().updateView(message);
            return;
        }
        Intent intent = new Intent(this.getContext(), EaseShowBigImageActivity.class);
        Uri imgUri = imgBody.getLocalUri();
        if (UriUtils.isFileExistByUri((Context)this.getContext(), (Uri)imgUri)) {
            intent.putExtra("uri", (Parcelable)imgUri);
        } else {
            String msgId = message.getMsgId();
            intent.putExtra("messageId", msgId);
            intent.putExtra("filename", imgBody.getFileName());
        }
        if (!EaseIM.getInstance().getConfigsManager().enableSendChannelAck() && message != null && message.direct() == EMMessage.Direct.RECEIVE && !message.isAcked() && message.getChatType() == EMMessage.ChatType.Chat) {
            try {
                EMClient.getInstance().chatManager().ackMessageRead(message.getFrom(), message.getMsgId());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.getContext().startActivity(intent);
    }

    @Override
    protected void handleReceiveMessage(EMMessage message) {
        super.handleReceiveMessage(message);
        this.getChatRow().updateView(message);
    }
}

