/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import com.hyphenate.easeui.utils.RomUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class StatusBarCompat {
    private static final int INVALID_VAL = -1;
    private static final int COLOR_DEFAULT = Color.parseColor((String)"#20000000");

    public static void setFitSystemForTheme(Activity activity, boolean fitSystemForTheme, String color2) {
        StatusBarCompat.setFitSystemForTheme(activity, fitSystemForTheme, Color.parseColor((String)color2));
    }

    public static void setFitSystemForTheme(Activity activity, boolean fitSystemForTheme, int color2) {
        ViewGroup contentFrameLayout;
        View parentView;
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            activity.getWindow().addFlags(0x4000000);
        }
        if (fitSystemForTheme && (parentView = (contentFrameLayout = (ViewGroup)activity.findViewById(0x1020002)).getChildAt(0)) != null && Build.VERSION.SDK_INT >= 14) {
            parentView.setFitsSystemWindows(true);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = activity.getWindow();
            window.clearFlags(0x4000000);
            window.getDecorView().setSystemUiVisibility(1280);
            window.addFlags(Integer.MIN_VALUE);
        }
        StatusBarCompat.compat(activity, color2);
    }

    @TargetApi(value=21)
    public static void compat(Activity activity, int statusColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            if (statusColor != -1) {
                activity.getWindow().setStatusBarColor(statusColor);
            }
            return;
        }
        if (Build.VERSION.SDK_INT >= 19 && Build.VERSION.SDK_INT < 21) {
            int childCount;
            int color2 = COLOR_DEFAULT;
            ViewGroup contentView = (ViewGroup)activity.findViewById(0x1020002);
            if (statusColor != -1) {
                color2 = statusColor;
            }
            if ((childCount = contentView.getChildCount()) > 1) {
                contentView.removeViewAt(1);
            }
            View statusBarView = new View((Context)activity);
            ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, StatusBarCompat.getStatusBarHeight((Context)activity));
            statusBarView.setBackgroundColor(color2);
            contentView.addView(statusBarView, lp);
        }
    }

    public static void compat(Activity activity) {
        StatusBarCompat.compat(activity, -1);
    }

    public static int getStatusBarHeight(Context context) {
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static void setLightStatusBar(Activity activity, boolean dark) {
        if (Build.VERSION.SDK_INT >= 19) {
            switch (RomUtils.getLightStatusBarAvailableRomType()) {
                case 1: {
                    StatusBarCompat.setMIUISetStatusBarLightMode(activity, dark);
                    break;
                }
                case 2: {
                    StatusBarCompat.setFlymeLightStatusBar(activity, dark);
                    break;
                }
                case 3: {
                    StatusBarCompat.setAndroidNativeLightStatusBar(activity, dark);
                }
            }
        }
    }

    public static boolean setMIUISetStatusBarLightMode(Activity activity, boolean dark) {
        boolean result = false;
        Window window = activity.getWindow();
        if (window != null) {
            Class<?> clazz = window.getClass();
            try {
                int darkModeFlag = 0;
                Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
                Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
                darkModeFlag = field.getInt(layoutParams);
                Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
                if (dark) {
                    extraFlagField.invoke((Object)window, darkModeFlag, darkModeFlag);
                } else {
                    extraFlagField.invoke((Object)window, 0, darkModeFlag);
                }
                result = true;
                if (Build.VERSION.SDK_INT >= 23 && RomUtils.isMiUIV7OrAbove()) {
                    if (dark) {
                        activity.getWindow().getDecorView().setSystemUiVisibility(9216);
                    } else {
                        activity.getWindow().getDecorView().setSystemUiVisibility(1280);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static boolean setFlymeLightStatusBar(Activity activity, boolean dark) {
        boolean result = false;
        if (activity != null) {
            try {
                WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
                Field darkFlag = WindowManager.LayoutParams.class.getDeclaredField("MEIZU_FLAG_DARK_STATUS_BAR_ICON");
                Field meizuFlags = WindowManager.LayoutParams.class.getDeclaredField("meizuFlags");
                darkFlag.setAccessible(true);
                meizuFlags.setAccessible(true);
                int bit = darkFlag.getInt(null);
                int value = meizuFlags.getInt(lp);
                value = dark ? (value |= bit) : (value &= ~bit);
                meizuFlags.setInt(lp, value);
                activity.getWindow().setAttributes(lp);
                result = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private static void setAndroidNativeLightStatusBar(Activity activity, boolean dark) {
        View decor = activity.getWindow().getDecorView();
        if (dark) {
            decor.setSystemUiVisibility(9216);
        } else {
            decor.setSystemUiVisibility(1280);
        }
    }
}

