/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.text.format.DateFormat;
import com.hyphenate.util.TimeInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class EaseDateUtils {
    private static final long INTERVAL_IN_MILLISECONDS = 30000L;

    /*
     * Enabled aggressive block sorting
     */
    public static String getTimestampString(Context context, Date messageDate) {
        boolean isZh;
        String format;
        block7: {
            format = null;
            String language = Locale.getDefault().getLanguage();
            isZh = language.startsWith("zh");
            long messageTime = messageDate.getTime();
            if (EaseDateUtils.isSameDay(messageTime)) {
                format = EaseDateUtils.is24HourFormat(context) ? "HH:mm" : (isZh ? "aa hh:mm" : "hh:mm aa");
            } else {
                if (EaseDateUtils.isYesterday(messageTime)) {
                    if (isZh) {
                        format = EaseDateUtils.is24HourFormat(context) ? "\u6628\u5929 HH:mm" : "\u6628\u5929aa hh:mm";
                        break block7;
                    } else {
                        if (EaseDateUtils.is24HourFormat(context)) {
                            return "Yesterday " + new SimpleDateFormat("HH:mm", Locale.ENGLISH).format(messageDate);
                        }
                        return "Yesterday " + new SimpleDateFormat("hh:mm aa", Locale.ENGLISH).format(messageDate);
                    }
                }
                format = isZh ? (EaseDateUtils.is24HourFormat(context) ? "M\u6708d\u65e5 HH:mm" : "M\u6708d\u65e5aa hh:mm") : (EaseDateUtils.is24HourFormat(context) ? "MMM dd HH:mm" : "MMM dd hh:mm aa");
            }
        }
        if (isZh) {
            return new SimpleDateFormat(format, Locale.CHINESE).format(messageDate);
        }
        return new SimpleDateFormat(format, Locale.ENGLISH).format(messageDate);
    }

    public static boolean isCloseEnough(long time1, long time2) {
        long delta = time1 - time2;
        if (delta < 0L) {
            delta = -delta;
        }
        return delta < 30000L;
    }

    private static boolean isSameDay(long inputTime) {
        TimeInfo tStartAndEndTime = EaseDateUtils.getTodayStartAndEndTime();
        return inputTime > tStartAndEndTime.getStartTime() && inputTime < tStartAndEndTime.getEndTime();
    }

    private static boolean isYesterday(long inputTime) {
        TimeInfo yStartAndEndTime = EaseDateUtils.getYesterdayStartAndEndTime();
        return inputTime > yStartAndEndTime.getStartTime() && inputTime < yStartAndEndTime.getEndTime();
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static Date StringToDate(String dateStr, String formatStr) {
        SimpleDateFormat format = new SimpleDateFormat(formatStr);
        Date date = null;
        try {
            date = format.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toTime(int timeLength) {
        int minute = (timeLength /= 1000) / 60;
        int hour = 0;
        if (minute >= 60) {
            hour = minute / 60;
            minute %= 60;
        }
        int second = timeLength % 60;
        return String.format("%02d:%02d", minute, second);
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String toTimeBySecond(int timeLength) {
        int minute = timeLength / 60;
        int hour = 0;
        if (minute >= 60) {
            hour = minute / 60;
            minute %= 60;
        }
        int second = timeLength % 60;
        return String.format("%02d:%02d", minute, second);
    }

    public static TimeInfo getYesterdayStartAndEndTime() {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.add(5, -1);
        calendar1.set(11, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        calendar1.set(14, 0);
        Date startDate = calendar1.getTime();
        long startTime = startDate.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, -1);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date endDate = calendar2.getTime();
        long endTime = endDate.getTime();
        TimeInfo info = new TimeInfo();
        info.setStartTime(startTime);
        info.setEndTime(endTime);
        return info;
    }

    public static TimeInfo getTodayStartAndEndTime() {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.set(11, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        calendar1.set(14, 0);
        Date startDate = calendar1.getTime();
        long startTime = startDate.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date endDate = calendar2.getTime();
        long endTime = endDate.getTime();
        TimeInfo info = new TimeInfo();
        info.setStartTime(startTime);
        info.setEndTime(endTime);
        return info;
    }

    public static TimeInfo getBeforeYesterdayStartAndEndTime() {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.add(5, -2);
        calendar1.set(11, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        calendar1.set(14, 0);
        Date startDate = calendar1.getTime();
        long startTime = startDate.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(5, -2);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        Date endDate = calendar2.getTime();
        long endTime = endDate.getTime();
        TimeInfo info = new TimeInfo();
        info.setStartTime(startTime);
        info.setEndTime(endTime);
        return info;
    }

    public static TimeInfo getCurrentMonthStartAndEndTime() {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.set(5, 1);
        calendar1.set(11, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        calendar1.set(14, 0);
        Date startDate = calendar1.getTime();
        long startTime = startDate.getTime();
        Calendar calendar2 = Calendar.getInstance();
        Date endDate = calendar2.getTime();
        long endTime = endDate.getTime();
        TimeInfo info = new TimeInfo();
        info.setStartTime(startTime);
        info.setEndTime(endTime);
        return info;
    }

    public static TimeInfo getLastMonthStartAndEndTime() {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.add(2, -1);
        calendar1.set(5, 1);
        calendar1.set(11, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        calendar1.set(14, 0);
        Date startDate = calendar1.getTime();
        long startTime = startDate.getTime();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.add(2, -1);
        calendar2.set(5, 1);
        calendar2.set(11, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        calendar2.roll(5, -1);
        Date endDate = calendar2.getTime();
        long endTime = endDate.getTime();
        TimeInfo info = new TimeInfo();
        info.setStartTime(startTime);
        info.setEndTime(endTime);
        return info;
    }

    public static String getTimestampStr() {
        return Long.toString(System.currentTimeMillis());
    }

    public static boolean is24HourFormat(Context context) {
        return DateFormat.is24HourFormat((Context)context);
    }
}

