/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.ui.base;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.hyphenate.easeui.manager.EaseThreadManager;

public class EaseBaseFragment
extends Fragment {
    public Activity mContext;
    public boolean onClickBackPress;

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.mContext = (Activity)context;
    }

    protected <T extends View> T findViewById(@IdRes int id2) {
        return (T)this.requireView().findViewById(id2);
    }

    public void onBackPress() {
        this.onClickBackPress = true;
        this.mContext.onBackPressed();
    }

    protected void hideKeyboard() {
        if (this.getActivity().getWindow().getAttributes().softInputMode != 2 && this.getActivity().getCurrentFocus() != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
            if (inputManager == null) {
                return;
            }
            inputManager.hideSoftInputFromWindow(this.getActivity().getCurrentFocus().getWindowToken(), 2);
        }
    }

    public boolean isActivityDisable() {
        return this.mContext == null || this.mContext.isFinishing();
    }

    public void runOnUiThread(Runnable runnable) {
        EaseThreadManager.getInstance().runOnMainThread(runnable);
    }
}

