/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.ui;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Toast;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.LocationClient;
import com.baidu.location.LocationClientOption;
import com.baidu.mapapi.SDKInitializer;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BaiduMapOptions;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.utils.CoordinateConverter;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.ui.base.EaseBaseActivity;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.widget.EaseTitleBar;

public class EaseBaiduMapActivity
extends EaseBaseActivity
implements EaseTitleBar.OnBackPressListener,
EaseTitleBar.OnRightClickListener {
    private EaseTitleBar titleBarMap;
    private MapView mapView;
    private BaiduMap baiduMap;
    private BDLocation lastLocation;
    protected double latitude;
    protected double longtitude;
    protected String address;
    private BaiduSDKReceiver mBaiduReceiver;
    private LocationClient mLocClient;

    public static void actionStartForResult(Fragment fragment, int requestCode) {
        Intent intent = new Intent(fragment.getContext(), EaseBaiduMapActivity.class);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void actionStartForResult(Activity activity, int requestCode) {
        Intent intent = new Intent((Context)activity, EaseBaiduMapActivity.class);
        activity.startActivityForResult(intent, requestCode);
    }

    public static void actionStart(Context context, double latitude, double longtitude, String address) {
        Intent intent = new Intent(context, EaseBaiduMapActivity.class);
        intent.putExtra("latitude", latitude);
        intent.putExtra("longtitude", longtitude);
        intent.putExtra("address", address);
        context.startActivity(intent);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        SDKInitializer.initialize((Context)this.getApplicationContext());
        this.setContentView(R.layout.ease_activity_baidumap);
        this.setFitSystemForTheme(false, R.color.transparent, true);
        this.initIntent();
        this.initView();
        this.initListener();
        this.initData();
    }

    private void initIntent() {
        this.latitude = this.getIntent().getDoubleExtra("latitude", 0.0);
        this.longtitude = this.getIntent().getDoubleExtra("longtitude", 0.0);
        this.address = this.getIntent().getStringExtra("address");
    }

    private void initView() {
        this.titleBarMap = (EaseTitleBar)this.findViewById(R.id.title_bar_map);
        this.mapView = (MapView)this.findViewById(R.id.bmapView);
        this.titleBarMap.setRightTitleResource(R.string.button_send);
        double latitude = this.getIntent().getDoubleExtra("latitude", 0.0);
        if (latitude != 0.0) {
            this.titleBarMap.getRightLayout().setVisibility(8);
        } else {
            this.titleBarMap.getRightLayout().setVisibility(0);
            this.titleBarMap.getRightLayout().setClickable(false);
        }
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.titleBarMap.getLayoutParams();
        params.topMargin = (int)EaseCommonUtils.dip2px((Context)this, 24.0f);
        this.titleBarMap.setBackgroundColor(ContextCompat.getColor((Context)this, (int)R.color.transparent));
        this.titleBarMap.getRightText().setTextColor(ContextCompat.getColor((Context)this, (int)R.color.white));
        this.titleBarMap.getRightText().setBackgroundResource(R.drawable.ease_title_bar_right_selector);
        int left = (int)EaseCommonUtils.dip2px((Context)this, 10.0f);
        int top = (int)EaseCommonUtils.dip2px((Context)this, 5.0f);
        this.titleBarMap.getRightText().setPadding(left, top, left, top);
        ViewGroup.LayoutParams layoutParams = this.titleBarMap.getRightLayout().getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(0, 0, left, 0);
        }
        this.baiduMap = this.mapView.getMap();
        this.baiduMap.setMapStatus(MapStatusUpdateFactory.zoomTo((float)15.0f));
        this.mapView.setLongClickable(true);
    }

    private void initListener() {
        this.titleBarMap.setOnBackPressListener(this);
        this.titleBarMap.setOnRightClickListener(this);
    }

    private void initData() {
        if (this.latitude == 0.0) {
            this.mapView = new MapView((Context)this, new BaiduMapOptions());
            this.baiduMap.setMyLocationConfigeration(new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, true, null));
            this.showMapWithLocationClient();
        } else {
            LatLng lng = new LatLng(this.latitude, this.longtitude);
            this.mapView = new MapView((Context)this, new BaiduMapOptions().mapStatus(new MapStatus.Builder().target(lng).build()));
            this.showMap(this.latitude, this.longtitude);
        }
        IntentFilter iFilter = new IntentFilter();
        iFilter.addAction("permission check error");
        iFilter.addAction("network error");
        this.mBaiduReceiver = new BaiduSDKReceiver();
        this.registerReceiver(this.mBaiduReceiver, iFilter);
    }

    protected void showMapWithLocationClient() {
        this.mLocClient = new LocationClient((Context)this);
        this.mLocClient.registerLocationListener((BDLocationListener)new EaseBDLocationListener());
        LocationClientOption option = new LocationClientOption();
        option.setOpenGps(true);
        option.setCoorType("gcj02");
        option.setScanSpan(30000);
        option.setAddrType("all");
        option.setIgnoreKillProcess(true);
        this.mLocClient.setLocOption(option);
        if (!this.mLocClient.isStarted()) {
            this.mLocClient.start();
        }
    }

    protected void showMap(double latitude, double longtitude) {
        LatLng lng = new LatLng(latitude, longtitude);
        CoordinateConverter converter = new CoordinateConverter();
        converter.coord(lng);
        converter.from(CoordinateConverter.CoordType.COMMON);
        LatLng convertLatLng = converter.convert();
        MarkerOptions ooA = new MarkerOptions().position(convertLatLng).icon(BitmapDescriptorFactory.fromResource((int)R.drawable.ease_icon_marka)).zIndex(4).draggable(true);
        this.baiduMap.addOverlay((OverlayOptions)ooA);
        MapStatusUpdate u = MapStatusUpdateFactory.newLatLngZoom((LatLng)convertLatLng, (float)17.0f);
        this.baiduMap.animateMapStatus(u);
    }

    @Override
    public void onBackPress(View view) {
        this.onBackPressed();
    }

    @Override
    public void onRightClick(View view) {
        this.sendLocation();
    }

    public void onReceiveBDLocation(BDLocation bdLocation) {
        if (bdLocation == null) {
            return;
        }
        if (this.lastLocation != null && this.lastLocation.getLatitude() == bdLocation.getLatitude() && this.lastLocation.getLongitude() == bdLocation.getLongitude()) {
            Log.d((String)"map", (String)"same location, skip refresh");
            return;
        }
        this.titleBarMap.getRightLayout().setClickable(true);
        this.lastLocation = bdLocation;
        this.baiduMap.clear();
        this.showMap(this.lastLocation.getLatitude(), this.lastLocation.getLongitude());
    }

    private void sendLocation() {
        Intent intent = this.getIntent();
        intent.putExtra("latitude", this.lastLocation.getLatitude());
        intent.putExtra("longitude", this.lastLocation.getLongitude());
        intent.putExtra("address", this.lastLocation.getAddrStr());
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    protected void onResume() {
        this.mapView.onResume();
        if (this.mLocClient != null && !this.mLocClient.isStarted()) {
            this.mLocClient.start();
        }
        super.onResume();
    }

    protected void onPause() {
        this.mapView.onPause();
        if (this.mLocClient != null) {
            this.mLocClient.stop();
        }
        super.onPause();
        this.lastLocation = null;
    }

    protected void onDestroy() {
        if (this.mLocClient != null) {
            this.mLocClient.stop();
        }
        this.mapView.onDestroy();
        this.unregisterReceiver(this.mBaiduReceiver);
        super.onDestroy();
    }

    protected void showErrorToast(String message) {
        Toast.makeText((Context)this, (CharSequence)message, (int)0).show();
    }

    public class EaseBDLocationListener
    implements BDLocationListener {
        public void onReceiveLocation(BDLocation bdLocation) {
            EaseBaiduMapActivity.this.onReceiveBDLocation(bdLocation);
        }
    }

    public class BaiduSDKReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (TextUtils.equals((CharSequence)action, (CharSequence)"permission check error")) {
                EaseBaiduMapActivity.this.showErrorToast(EaseBaiduMapActivity.this.getResources().getString(R.string.please_check));
            } else if (TextUtils.equals((CharSequence)action, (CharSequence)"network error")) {
                EaseBaiduMapActivity.this.showErrorToast(EaseBaiduMapActivity.this.getResources().getString(R.string.Network_error));
            }
        }
    }
}

