/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.conversation.delegate;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.hyphenate.chat.EMChatRoom;
import com.hyphenate.chat.EMClient;
import com.hyphenate.chat.EMConversation;
import com.hyphenate.chat.EMGroup;
import com.hyphenate.chat.EMMessage;
import com.hyphenate.easeui.EaseIM;
import com.hyphenate.easeui.R;
import com.hyphenate.easeui.domain.EaseUser;
import com.hyphenate.easeui.manager.EaseAtMessageHelper;
import com.hyphenate.easeui.manager.EasePreferenceManager;
import com.hyphenate.easeui.modules.conversation.delegate.EaseDefaultConversationDelegate;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationInfo;
import com.hyphenate.easeui.modules.conversation.model.EaseConversationSetStyle;
import com.hyphenate.easeui.provider.EaseConversationInfoProvider;
import com.hyphenate.easeui.provider.EaseUserProfileProvider;
import com.hyphenate.easeui.utils.EaseCommonUtils;
import com.hyphenate.easeui.utils.EaseDateUtils;
import com.hyphenate.easeui.utils.EaseSmileUtils;
import java.util.Date;

public class EaseConversationDelegate
extends EaseDefaultConversationDelegate {
    public EaseConversationDelegate(EaseConversationSetStyle setModel) {
        super(setModel);
    }

    @Override
    public boolean isForViewType(EaseConversationInfo item, int position) {
        return item != null && item.getInfo() instanceof EMConversation;
    }

    @Override
    protected void onBindConViewHolder(EaseDefaultConversationDelegate.ViewHolder holder, int position, EaseConversationInfo bean) {
        String unSendMsg;
        EaseUser user;
        EaseUserProfileProvider userProvider;
        Drawable avatarResource;
        EMConversation item = (EMConversation)bean.getInfo();
        Context context = holder.itemView.getContext();
        String username = item.conversationId();
        holder.listIteaseLayout.setBackground(!TextUtils.isEmpty((CharSequence)item.getExtField()) ? ContextCompat.getDrawable((Context)context, (int)R.drawable.ease_conversation_top_bg) : null);
        holder.mentioned.setVisibility(8);
        int defaultAvatar = 0;
        String showName = null;
        if (item.getType() == EMConversation.EMConversationType.GroupChat) {
            if (EaseAtMessageHelper.get().hasAtMeMsg(username)) {
                holder.mentioned.setText(R.string.were_mentioned);
                holder.mentioned.setVisibility(0);
            }
            defaultAvatar = R.drawable.ease_group_icon;
            EMGroup group = EMClient.getInstance().groupManager().getGroup(username);
            showName = group != null ? group.getGroupName() : username;
        } else if (item.getType() == EMConversation.EMConversationType.ChatRoom) {
            defaultAvatar = R.drawable.ease_chat_room_icon;
            EMChatRoom chatRoom = EMClient.getInstance().chatroomManager().getChatRoom(username);
            showName = chatRoom != null && !TextUtils.isEmpty((CharSequence)chatRoom.getName()) ? chatRoom.getName() : username;
        } else {
            defaultAvatar = R.drawable.ease_default_avatar;
            showName = username;
        }
        holder.avatar.setImageResource(defaultAvatar);
        holder.name.setText((CharSequence)showName);
        EaseConversationInfoProvider infoProvider = EaseIM.getInstance().getConversationInfoProvider();
        if (infoProvider != null && (avatarResource = infoProvider.getDefaultTypeAvatar(item.getType().name())) != null) {
            ((RequestBuilder)Glide.with((Context)holder.mContext).load(avatarResource).error(defaultAvatar)).into((ImageView)holder.avatar);
        }
        if ((userProvider = EaseIM.getInstance().getUserProvider()) != null && (user = userProvider.getUser(username)) != null) {
            if (!TextUtils.isEmpty((CharSequence)user.getNickname())) {
                holder.name.setText((CharSequence)user.getNickname());
            }
            if (!TextUtils.isEmpty((CharSequence)user.getAvatar())) {
                Drawable drawable2 = holder.avatar.getDrawable();
                ((RequestBuilder)Glide.with((Context)holder.mContext).load(user.getAvatar()).error(drawable2)).into((ImageView)holder.avatar);
            }
        }
        if (!this.setModel.isHideUnreadDot()) {
            this.showUnreadNum(holder, item.getUnreadMsgCount());
        }
        if (item.getAllMsgCount() != 0) {
            EMMessage lastMessage = item.getLastMessage();
            holder.message.setText((CharSequence)EaseSmileUtils.getSmiledText(context, EaseCommonUtils.getMessageDigest(lastMessage, context)));
            holder.time.setText((CharSequence)EaseDateUtils.getTimestampString(context, new Date(lastMessage.getMsgTime())));
            if (lastMessage.direct() == EMMessage.Direct.SEND && lastMessage.status() == EMMessage.Status.FAIL) {
                holder.mMsgState.setVisibility(0);
            } else {
                holder.mMsgState.setVisibility(8);
            }
        }
        if (holder.mentioned.getVisibility() != 0 && !TextUtils.isEmpty((CharSequence)(unSendMsg = EasePreferenceManager.getInstance().getUnSendMsgInfo(username)))) {
            holder.mentioned.setText(R.string.were_not_send_msg);
            holder.message.setText((CharSequence)unSendMsg);
            holder.mentioned.setVisibility(0);
        }
    }
}

