/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.modules.chat;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;

public class EaseInputEditText
extends EditText
implements View.OnKeyListener,
TextView.OnEditorActionListener {
    private boolean ctrlPress = false;
    private OnEditTextChangeListener listener;

    public EaseInputEditText(Context context) {
        this(context, null);
    }

    public EaseInputEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EaseInputEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOnKeyListener(this);
        this.setOnEditorActionListener(this);
    }

    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (this.listener != null) {
            this.listener.onEditTextHasFocus(focused);
        }
    }

    public boolean onKey(View v, int keyCode, KeyEvent event) {
        if (keyCode == 0) {
            if (event.getAction() == 0) {
                this.ctrlPress = true;
            } else if (event.getAction() == 1) {
                this.ctrlPress = false;
            }
        }
        return false;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == 4 || event != null && event.getKeyCode() == 66 && event.getAction() == 0 && this.ctrlPress) {
            String s = this.getText().toString();
            if (this.listener != null) {
                this.setText("");
                this.listener.onClickKeyboardSendBtn(s);
            }
            return true;
        }
        return false;
    }

    public void setOnEditTextChangeListener(OnEditTextChangeListener listener) {
        this.listener = listener;
    }

    public static interface OnEditTextChangeListener {
        public void onClickKeyboardSendBtn(String var1);

        public void onEditTextHasFocus(boolean var1);
    }
}

