/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.content.Context;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.text.format.Time;
import com.hyphenate.chat.EMClient;
import com.hyphenate.util.EMLog;
import com.hyphenate.util.PathUtil;
import java.io.File;
import java.io.IOException;
import java.util.Date;

public class EaseVoiceRecorder {
    MediaRecorder recorder;
    static final String PREFIX = "voice";
    static final String EXTENSION = ".amr";
    private boolean isRecording = false;
    private long startTime;
    private String voiceFilePath = null;
    private String voiceFileName = null;
    private File file;
    private Handler handler;

    public EaseVoiceRecorder(Handler handler) {
        this.handler = handler;
    }

    public String startRecording(Context appContext) {
        this.file = null;
        try {
            if (this.recorder != null) {
                this.recorder.release();
                this.recorder = null;
            }
            this.recorder = new MediaRecorder();
            this.recorder.setAudioSource(1);
            this.recorder.setOutputFormat(3);
            this.recorder.setAudioEncoder(1);
            this.recorder.setAudioChannels(1);
            this.recorder.setAudioSamplingRate(8000);
            this.recorder.setAudioEncodingBitRate(64);
            this.voiceFileName = this.getVoiceFileName(EMClient.getInstance().getCurrentUser());
            this.voiceFilePath = PathUtil.getInstance().getVoicePath() + "/" + this.voiceFileName;
            this.file = new File(this.voiceFilePath);
            this.recorder.setOutputFile(this.file.getAbsolutePath());
            this.recorder.prepare();
            this.isRecording = true;
            this.recorder.start();
        }
        catch (IOException e) {
            EMLog.e((String)PREFIX, (String)"prepare() failed");
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (EaseVoiceRecorder.this.isRecording) {
                        Message msg = new Message();
                        msg.what = EaseVoiceRecorder.this.recorder.getMaxAmplitude() * 13 / Short.MAX_VALUE;
                        EaseVoiceRecorder.this.handler.sendMessage(msg);
                        SystemClock.sleep((long)100L);
                    }
                }
                catch (Exception e) {
                    EMLog.e((String)EaseVoiceRecorder.PREFIX, (String)e.toString());
                }
            }
        }).start();
        this.startTime = new Date().getTime();
        EMLog.d((String)PREFIX, (String)("start voice recording to file:" + this.file.getAbsolutePath()));
        return this.file == null ? null : this.file.getAbsolutePath();
    }

    public void discardRecording() {
        if (this.recorder != null) {
            try {
                this.recorder.stop();
                this.recorder.release();
                this.recorder = null;
                if (this.file != null && this.file.exists() && !this.file.isDirectory()) {
                    this.file.delete();
                }
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            this.isRecording = false;
        }
    }

    public int stopRecoding() {
        if (this.recorder != null) {
            this.isRecording = false;
            this.recorder.stop();
            this.recorder.release();
            this.recorder = null;
            if (this.file == null || !this.file.exists() || !this.file.isFile()) {
                return 401;
            }
            if (this.file.length() == 0L) {
                this.file.delete();
                return 401;
            }
            int seconds = (int)(new Date().getTime() - this.startTime) / 1000;
            EMLog.d((String)PREFIX, (String)("voice recording finished. seconds:" + seconds + " file length:" + this.file.length()));
            return seconds;
        }
        return 0;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.recorder != null) {
            this.recorder.release();
        }
    }

    private String getVoiceFileName(String uid) {
        Time now = new Time();
        now.setToNow();
        return uid + now.toString().substring(0, 15) + EXTENSION;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public String getVoiceFilePath() {
        return this.voiceFilePath;
    }

    public String getVoiceFileName() {
        return this.voiceFileName;
    }
}

