/*
 * Decompiled with CFR 0.152.
 */
package com.hyphenate.easeui.manager;

import android.annotation.SuppressLint;
import android.content.SharedPreferences;
import com.hyphenate.easeui.EaseIM;
import java.util.Set;

public class EasePreferenceManager {
    private SharedPreferences.Editor editor;
    private SharedPreferences mSharedPreferences = EaseIM.getInstance().getContext().getSharedPreferences("EM_SP_AT_MESSAGE", 0);
    private static final String KEY_AT_GROUPS = "AT_GROUPS";
    private static String SHARED_KEY_SETTING_RECORD_ON_SERVER = "shared_key_setting_record_on_server";
    private static String SHARED_KEY_SETTING_MERGE_STREAM = "shared_key_setting_merge_stream";
    private static EasePreferenceManager instance;

    @SuppressLint(value={"CommitPrefEdits"})
    private EasePreferenceManager() {
        this.editor = this.mSharedPreferences.edit();
    }

    public static synchronized EasePreferenceManager getInstance() {
        if (instance == null) {
            instance = new EasePreferenceManager();
        }
        return instance;
    }

    public void setAtMeGroups(Set<String> groups) {
        this.editor.remove(KEY_AT_GROUPS);
        this.editor.putStringSet(KEY_AT_GROUPS, groups);
        this.editor.apply();
    }

    public Set<String> getAtMeGroups() {
        return this.mSharedPreferences.getStringSet(KEY_AT_GROUPS, null);
    }

    public void setRecordOnServer(boolean value) {
        this.editor.putBoolean(SHARED_KEY_SETTING_RECORD_ON_SERVER, value);
        this.editor.apply();
    }

    public boolean isRecordOnServer() {
        return this.mSharedPreferences.getBoolean(SHARED_KEY_SETTING_RECORD_ON_SERVER, false);
    }

    public void setMergeStream(boolean value) {
        this.editor.putBoolean(SHARED_KEY_SETTING_MERGE_STREAM, value);
        this.editor.apply();
    }

    public boolean isMergeStream() {
        return this.mSharedPreferences.getBoolean(SHARED_KEY_SETTING_MERGE_STREAM, false);
    }

    public void saveUnSendMsgInfo(String toChatUsername, String content) {
        this.editor.putString(toChatUsername, content);
        this.editor.apply();
    }

    public String getUnSendMsgInfo(String toChatUsername) {
        return this.mSharedPreferences.getString(toChatUsername, "");
    }
}

