/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe;

import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.AbstractExecution;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.ExecutionResult;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.FailsafeException;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.FailsafeFuture;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.PolicyExecutor;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.RetryPolicy;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal.EventListener;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.internal.util.RandomDelay;
import io.github.gradlenexus.publishplugin.shadow.net.jodah.failsafe.util.concurrent.Scheduler;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

class RetryPolicyExecutor<R>
extends PolicyExecutor<R, RetryPolicy<R>> {
    private volatile int failedAttempts;
    private volatile boolean retriesExceeded;
    private volatile long delayNanos;
    private final EventListener abortListener;
    private final EventListener failedAttemptListener;
    private final EventListener retriesExceededListener;
    private final EventListener retryListener;
    private final EventListener retryScheduledListener;

    RetryPolicyExecutor(RetryPolicy<R> retryPolicy, AbstractExecution<R> execution, EventListener abortListener, EventListener failedAttemptListener, EventListener retriesExceededListener, EventListener retryListener, EventListener retryScheduledListener) {
        super(retryPolicy, execution);
        this.abortListener = abortListener;
        this.failedAttemptListener = failedAttemptListener;
        this.retriesExceededListener = retriesExceededListener;
        this.retryListener = retryListener;
        this.retryScheduledListener = retryScheduledListener;
    }

    @Override
    protected Supplier<ExecutionResult> supply(Supplier<ExecutionResult> supplier, Scheduler scheduler) {
        return () -> {
            while (true) {
                ExecutionResult result = (ExecutionResult)supplier.get();
                if (this.retriesExceeded || this.executionCancelled()) {
                    return result;
                }
                if ((result = this.postExecute(result)).isComplete() || this.executionCancelled()) {
                    return result;
                }
                try {
                    if (this.retryScheduledListener != null) {
                        this.retryScheduledListener.handle(result, this.execution);
                    }
                    this.execution.canInterrupt = true;
                    Thread.sleep(TimeUnit.NANOSECONDS.toMillis(result.getWaitNanos()));
                }
                catch (InterruptedException e) {
                    if (!this.execution.interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    ExecutionResult executionResult = ExecutionResult.failure(new FailsafeException(e));
                    return executionResult;
                }
                finally {
                    this.execution.canInterrupt = false;
                }
                if (this.executionCancelled()) {
                    return result;
                }
                if (this.retryListener == null) continue;
                this.retryListener.handle(result, this.execution);
            }
        };
    }

    @Override
    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(final Supplier<CompletableFuture<ExecutionResult>> supplier, final Scheduler scheduler, final FailsafeFuture<R> future) {
        return () -> {
            final CompletableFuture promise = new CompletableFuture();
            Callable<Object> callable = new Callable<Object>(){
                volatile ExecutionResult previousResult;

                @Override
                public Object call() {
                    if (RetryPolicyExecutor.this.retryListener != null && this.previousResult != null) {
                        RetryPolicyExecutor.this.retryListener.handle(this.previousResult, RetryPolicyExecutor.this.execution);
                    }
                    ((CompletableFuture)supplier.get()).whenComplete((result, error) -> {
                        if (error != null) {
                            promise.completeExceptionally((Throwable)error);
                        } else if (result == null) {
                            promise.complete(null);
                        } else if (RetryPolicyExecutor.this.retriesExceeded || RetryPolicyExecutor.this.executionCancelled()) {
                            promise.complete(result);
                        } else {
                            RetryPolicyExecutor.this.postExecuteAsync((ExecutionResult)result, scheduler, future).whenComplete((postResult, postError) -> {
                                if (postError != null) {
                                    promise.completeExceptionally((Throwable)postError);
                                } else if (postResult == null) {
                                    promise.complete(null);
                                } else if (postResult.isComplete() || RetryPolicyExecutor.this.executionCancelled()) {
                                    promise.complete(postResult);
                                } else {
                                    FailsafeFuture failsafeFuture = future;
                                    synchronized (failsafeFuture) {
                                        if (!future.isDone()) {
                                            try {
                                                if (RetryPolicyExecutor.this.retryScheduledListener != null) {
                                                    RetryPolicyExecutor.this.retryScheduledListener.handle((ExecutionResult)postResult, RetryPolicyExecutor.this.execution);
                                                }
                                                this.previousResult = postResult;
                                                ScheduledFuture<?> scheduledRetry = scheduler.schedule(this, postResult.getWaitNanos(), TimeUnit.NANOSECONDS);
                                                future.injectCancelFn((mayInterrupt, cancelResult) -> {
                                                    scheduledRetry.cancel((boolean)mayInterrupt);
                                                    if (RetryPolicyExecutor.this.executionCancelled()) {
                                                        promise.complete(cancelResult);
                                                    }
                                                });
                                            }
                                            catch (Throwable t) {
                                                promise.completeExceptionally(t);
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    });
                    return null;
                }
            };
            try {
                callable.call();
            }
            catch (Throwable t) {
                promise.completeExceptionally(t);
            }
            return promise;
        };
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        boolean success;
        if (this.failedAttemptListener != null) {
            this.failedAttemptListener.handle(result, this.execution);
        }
        ++this.failedAttempts;
        long waitNanos = this.delayNanos;
        Duration computedDelay = ((RetryPolicy)this.policy).computeDelay(this.execution);
        if (computedDelay != null) {
            waitNanos = computedDelay.toNanos();
        } else {
            waitNanos = this.getFixedOrRandomDelayNanos(waitNanos);
            this.delayNanos = waitNanos = this.adjustForBackoff(waitNanos);
        }
        waitNanos = this.adjustForJitter(waitNanos);
        long elapsedNanos = this.execution.getElapsedTime().toNanos();
        waitNanos = this.adjustForMaxDuration(waitNanos, elapsedNanos);
        boolean maxRetriesExceeded = ((RetryPolicy)this.policy).getMaxRetries() != -1 && this.failedAttempts > ((RetryPolicy)this.policy).getMaxRetries();
        boolean maxDurationExceeded = ((RetryPolicy)this.policy).getMaxDuration() != null && elapsedNanos > ((RetryPolicy)this.policy).getMaxDuration().toNanos();
        this.retriesExceeded = maxRetriesExceeded || maxDurationExceeded;
        boolean isAbortable = ((RetryPolicy)this.policy).isAbortable(result.getResult(), result.getFailure());
        boolean shouldRetry = !result.isSuccess() && !isAbortable && !this.retriesExceeded && ((RetryPolicy)this.policy).allowsRetries();
        boolean completed = isAbortable || !shouldRetry;
        boolean bl = success = completed && result.isSuccess() && !isAbortable;
        if (this.abortListener != null && isAbortable) {
            this.abortListener.handle(result, this.execution);
        } else if (this.retriesExceededListener != null && !success && this.retriesExceeded) {
            this.retriesExceededListener.handle(result, this.execution);
        }
        return result.with(waitNanos, completed, success);
    }

    @Override
    protected CompletableFuture<ExecutionResult> onFailureAsync(ExecutionResult result, Scheduler scheduler, FailsafeFuture<R> future) {
        return super.onFailureAsync(result.withNotComplete(), scheduler, future);
    }

    private long getFixedOrRandomDelayNanos(long waitNanos) {
        Duration delay = ((RetryPolicy)this.policy).getDelay();
        Duration delayMin = ((RetryPolicy)this.policy).getDelayMin();
        Duration delayMax = ((RetryPolicy)this.policy).getDelayMax();
        if (waitNanos == 0L && delay != null && !delay.equals(Duration.ZERO)) {
            waitNanos = delay.toNanos();
        } else if (delayMin != null && delayMax != null) {
            waitNanos = RandomDelay.randomDelayInRange(delayMin.toNanos(), delayMax.toNanos(), Math.random());
        }
        return waitNanos;
    }

    private long adjustForBackoff(long waitNanos) {
        if (this.execution.getAttemptCount() != 1 && ((RetryPolicy)this.policy).getMaxDelay() != null) {
            waitNanos = (long)Math.min((double)waitNanos * ((RetryPolicy)this.policy).getDelayFactor(), (double)((RetryPolicy)this.policy).getMaxDelay().toNanos());
        }
        return waitNanos;
    }

    private long adjustForJitter(long waitNanos) {
        if (((RetryPolicy)this.policy).getJitter() != null) {
            waitNanos = RandomDelay.randomDelay(waitNanos, ((RetryPolicy)this.policy).getJitter().toNanos(), Math.random());
        } else if (((RetryPolicy)this.policy).getJitterFactor() > 0.0) {
            waitNanos = RandomDelay.randomDelay(waitNanos, ((RetryPolicy)this.policy).getJitterFactor(), Math.random());
        }
        return waitNanos;
    }

    private long adjustForMaxDuration(long waitNanos, long elapsedNanos) {
        long maxRemainingWaitTime;
        if (((RetryPolicy)this.policy).getMaxDuration() != null && (waitNanos = Math.min(waitNanos, (maxRemainingWaitTime = ((RetryPolicy)this.policy).getMaxDuration().toNanos() - elapsedNanos) < 0L ? 0L : maxRemainingWaitTime)) < 0L) {
            waitNanos = 0L;
        }
        return waitNanos;
    }
}

