/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin;

import io.github.gradlenexus.publishplugin.AbstractNexusStagingRepositoryTask;
import io.github.gradlenexus.publishplugin.FindStagingRepository;
import io.github.gradlenexus.publishplugin.NexusPublishExtension;
import io.github.gradlenexus.publishplugin.NexusRepository;
import io.github.gradlenexus.publishplugin.internal.NexusClient;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptor;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptorRegistry;
import java.net.URI;
import java.time.Duration;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.gradle.api.GradleException;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Incubating
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0007R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lio/github/gradlenexus/publishplugin/FindStagingRepository;", "Lio/github/gradlenexus/publishplugin/AbstractNexusStagingRepositoryTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "extension", "Lio/github/gradlenexus/publishplugin/NexusPublishExtension;", "repository", "Lio/github/gradlenexus/publishplugin/NexusRepository;", "registry", "Lorg/gradle/api/provider/Provider;", "Lio/github/gradlenexus/publishplugin/internal/StagingRepositoryDescriptorRegistry;", "(Lorg/gradle/api/model/ObjectFactory;Lio/github/gradlenexus/publishplugin/NexusPublishExtension;Lio/github/gradlenexus/publishplugin/NexusRepository;Lorg/gradle/api/provider/Provider;)V", "descriptionRegex", "Lorg/gradle/api/provider/Property;", "", "getDescriptionRegex", "()Lorg/gradle/api/provider/Property;", "packageGroup", "getPackageGroup", "stagingRepositoryId", "getStagingRepositoryId", "determineStagingProfileId", "client", "Lio/github/gradlenexus/publishplugin/internal/NexusClient;", "findStagingRepository", "", "publish-plugin"})
@SourceDebugExtension(value={"SMAP\nFindStagingRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FindStagingRepository.kt\nio/github/gradlenexus/publishplugin/FindStagingRepository\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n*L\n1#1,86:1\n59#2:87\n59#2:88\n59#2:89\n*E\n*S KotlinDebug\n*F\n+ 1 FindStagingRepository.kt\nio/github/gradlenexus/publishplugin/FindStagingRepository\n*L\n42#1:87\n47#1:88\n52#1:89\n*E\n"})
public class FindStagingRepository
extends AbstractNexusStagingRepositoryTask {
    @Optional
    @Input
    @NotNull
    private final Property<String> packageGroup;
    @Input
    @NotNull
    private final Property<String> descriptionRegex;
    @Internal
    @NotNull
    private final Property<String> stagingRepositoryId;
    private final Provider<StagingRepositoryDescriptorRegistry> registry;

    @NotNull
    public final Property<String> getPackageGroup() {
        return this.packageGroup;
    }

    @NotNull
    public final Property<String> getDescriptionRegex() {
        return this.descriptionRegex;
    }

    @NotNull
    public final Property<String> getStagingRepositoryId() {
        return this.stagingRepositoryId;
    }

    @TaskAction
    public final void findStagingRepository() {
        Object object = this.getRepository().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"repository.get()");
        NexusRepository repository = (NexusRepository)object;
        Object object2 = repository.getNexusUrl().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"repository.nexusUrl.get()");
        URI serverUrl = (URI)object2;
        NexusClient client = new NexusClient(serverUrl, (String)repository.getUsername().getOrNull(), (String)repository.getPassword().getOrNull(), (Duration)this.getClientTimeout().getOrNull(), (Duration)this.getConnectTimeout().getOrNull());
        String stagingProfileId = this.determineStagingProfileId(repository, client);
        this.getLogger().info("Fetching staging repositories for {} at {}, stagingProfileId '{}'", new Object[]{repository.getName(), serverUrl, stagingProfileId});
        Object object3 = this.descriptionRegex.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"descriptionRegex.get()");
        String descriptionRegex2 = (String)object3;
        StagingRepositoryDescriptor descriptor = client.findStagingRepository(stagingProfileId, new Regex(descriptionRegex2));
        this.getLogger().lifecycle("Staging repository for {} at {}, stagingProfileId '{}', descriptionRegex '{}' is '{}'", new Object[]{repository.getName(), serverUrl, stagingProfileId, descriptionRegex2, descriptor.getStagingRepositoryId()});
        this.stagingRepositoryId.set((Object)descriptor.getStagingRepositoryId());
        ((StagingRepositoryDescriptorRegistry)this.registry.get()).set(repository.getName(), descriptor);
    }

    private final String determineStagingProfileId(NexusRepository repository, NexusClient client) {
        String stagingProfileId = (String)repository.getStagingProfileId().getOrNull();
        if (stagingProfileId == null) {
            Object object = this.packageGroup.get();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"packageGroup.get()");
            String packageGroup = (String)object;
            this.getLogger().info("No stagingProfileId set, querying for packageGroup '{}'", (Object)packageGroup);
            String string = client.findStagingProfileId(packageGroup);
            if (string == null) {
                throw (Throwable)new GradleException("Failed to find staging profile for package group: " + packageGroup);
            }
            stagingProfileId = string;
        }
        return stagingProfileId;
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public FindStagingRepository(@NotNull ObjectFactory objects, @NotNull NexusPublishExtension extension, @NotNull NexusRepository repository, @NotNull Provider<StagingRepositoryDescriptorRegistry> registry) {
        void $this$apply;
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
        super(objects, extension, repository);
        this.registry = registry;
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property22 = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        ObjectFactory $i$f$property22 = $this$property$iv = property;
        FindStagingRepository findStagingRepository = this;
        boolean bl = false;
        $this$apply.set((Provider)extension.getPackageGroup());
        Unit unit = Unit.INSTANCE;
        findStagingRepository.packageGroup = $this$property$iv;
        $this$property$iv = objects;
        boolean $i$f$property32 = false;
        Property property2 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        ObjectFactory $i$f$property32 = $this$property$iv = property2;
        findStagingRepository = this;
        boolean bl2 = false;
        $this$apply.set(extension.getRepositoryDescription().map((Transformer)descriptionRegex.1.1.INSTANCE));
        unit = Unit.INSTANCE;
        findStagingRepository.descriptionRegex = $this$property$iv;
        $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property3 = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"property(T::class.java)");
        this.stagingRepositoryId = property3;
        this.getOutputs().cacheIf("the task requests data from the external repository, so we don't want to cache it", (Spec)1.INSTANCE);
    }
}

